/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstanceCache<SeedObject, Instance> {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceCache.class);
    Map<SeedObject, Instance> cache = new HashMap<SeedObject, Instance>();

    public Instance retrieve(SeedObject hv) throws AvroSerdeException {
        return this.retrieve(hv, null);
    }

    public synchronized Instance retrieve(SeedObject hv, Set<SeedObject> seenSchemas) throws AvroSerdeException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking for hv: " + hv.toString());
        }
        if (this.cache.containsKey(hv)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Returning cache result.");
            }
            return this.cache.get(hv);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new instance and storing in cache");
        }
        Instance instance = this.makeInstance(hv, seenSchemas);
        this.cache.put(hv, instance);
        return instance;
    }

    protected abstract Instance makeInstance(SeedObject var1, Set<SeedObject> var2) throws AvroSerdeException;
}

