/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.operation;

import java.io.Serializable;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.spark.operation.SparkOperation;
import org.apache.kyuubi.operation.AnalyzeMode$;
import org.apache.kyuubi.operation.ArrayFetchIterator;
import org.apache.kyuubi.operation.ExecutionMode$;
import org.apache.kyuubi.operation.IterableFetchIterator;
import org.apache.kyuubi.operation.JsonStyle$;
import org.apache.kyuubi.operation.OptimizeMode$;
import org.apache.kyuubi.operation.OptimizeWithStatsMode$;
import org.apache.kyuubi.operation.ParseMode$;
import org.apache.kyuubi.operation.PhysicalMode$;
import org.apache.kyuubi.operation.PlainStyle$;
import org.apache.kyuubi.operation.PlanOnlyMode;
import org.apache.kyuubi.operation.PlanOnlyMode$;
import org.apache.kyuubi.operation.PlanOnlyStyle;
import org.apache.kyuubi.operation.PlanOnlyStyle$;
import org.apache.kyuubi.operation.UnknownMode$;
import org.apache.kyuubi.operation.UnknownStyle$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.session.Session;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001\u0002\n\u0014\u0001\u0001B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tW\u0001\u0011)\u0019!C!Y!A!\b\u0001B\u0001B\u0003%Q\u0006\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001d9\u0005A1A\u0005\n!Caa\u0014\u0001!\u0002\u0013I\u0005b\u0002)\u0001\u0005\u0004%I!\u0015\u0005\u00077\u0002\u0001\u000b\u0011\u0002*\t\u000fq\u0003!\u0019!C\u0005;\"1\u0011\r\u0001Q\u0001\nyCQA\u0019\u0001\u0005B\rDQ\u0001\u001b\u0001\u0005R%DQa\u001d\u0001\u0005RQDQ\u0001\u001f\u0001\u0005RQDQ!\u001f\u0001\u0005\niDq!a\u0004\u0001\t\u0013\t\tBA\tQY\u0006twJ\u001c7z'R\fG/Z7f]RT!\u0001F\u000b\u0002\u0013=\u0004XM]1uS>t'B\u0001\f\u0018\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0012$\u0001\u0004f]\u001eLg.\u001a\u0006\u00035m\taa[=vk\nL'B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001CA\u0011!eI\u0007\u0002'%\u0011Ae\u0005\u0002\u000f'B\f'o[(qKJ\fG/[8o\u0003\u001d\u0019Xm]:j_:\u0004\"aJ\u0015\u000e\u0003!R!!J\r\n\u0005)B#aB*fgNLwN\\\u0001\ngR\fG/Z7f]R,\u0012!\f\t\u0003]]r!aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0005Iz\u0012A\u0002\u001fs_>$hHC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14'\u0001\u0004Qe\u0016$WMZ\u0005\u0003qe\u0012aa\u0015;sS:<'B\u0001\u001c4\u0003)\u0019H/\u0019;f[\u0016tG\u000fI\u0001\u0005[>$W\r\u0005\u0002>\u007f5\taH\u0003\u0002\u00153%\u0011\u0001I\u0010\u0002\r!2\fgn\u00148ms6{G-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\r#UI\u0012\t\u0003E\u0001AQ!J\u0003A\u0002\u0019BQaK\u0003A\u00025BQaO\u0003A\u0002q\nAb\u001c9fe\u0006$\u0018n\u001c8M_\u001e,\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019z\n1\u0001\\8h\u0013\tq5J\u0001\u0007Pa\u0016\u0014\u0018\r^5p]2{w-A\u0007pa\u0016\u0014\u0018\r^5p]2{w\rI\u0001\ra2\fg.\u0012=dYV$Wm]\u000b\u0002%B\u00191\u000bW\u0017\u000f\u0005Q3fB\u0001\u0019V\u0013\u0005!\u0014BA,4\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0017.\u0003\u0007M+\u0017O\u0003\u0002Xg\u0005i\u0001\u000f\\1o\u000bb\u001cG.\u001e3fg\u0002\nQa\u001d;zY\u0016,\u0012A\u0018\t\u0003{}K!\u0001\u0019 \u0003\u001bAc\u0017M\\(oYf\u001cF/\u001f7f\u0003\u0019\u0019H/\u001f7fA\u0005yq-\u001a;Pa\u0016\u0014\u0018\r^5p]2{w-F\u0001e!\r)g-S\u0007\u0002g%\u0011qm\r\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0019I,7/\u001e7u'\u000eDW-\\1\u0016\u0003)\u0004\"a[9\u000e\u00031T!!\u001c8\u0002\u000bQL\b/Z:\u000b\u0005=\u0004\u0018aA:rY*\u0011acG\u0005\u0003e2\u0014!b\u0015;sk\u000e$H+\u001f9f\u0003%\u0011WMZ8sKJ+h\u000eF\u0001v!\t)g/\u0003\u0002xg\t!QK\\5u\u0003-\u0011XO\\%oi\u0016\u0014h.\u00197\u0002+\u0015D\b\u000f\\1j]^KG\u000f\u001b)mC&t7\u000b^=mKR\u0011Qo\u001f\u0005\u0006yB\u0001\r!`\u0001\u0005a2\fg\u000eE\u0002\u007f\u0003\u0017i\u0011a \u0006\u0005\u0003\u0003\t\u0019!A\u0004m_\u001eL7-\u00197\u000b\t\u0005\u0015\u0011qA\u0001\u0006a2\fgn\u001d\u0006\u0004\u0003\u0013q\u0017\u0001C2bi\u0006d\u0017p\u001d;\n\u0007\u00055qPA\u0006M_\u001eL7-\u00197QY\u0006t\u0017\u0001F3ya2\f\u0017N\\,ji\"T5o\u001c8TifdW\rF\u0002v\u0003'AQ\u0001`\tA\u0002u\u0004")
public class PlanOnlyStatement
extends SparkOperation {
    private final Session session;
    private final String statement;
    private final PlanOnlyMode mode;
    private final OperationLog operationLog;
    private final Seq<String> planExcludes;
    private final PlanOnlyStyle style;

    @Override
    public String statement() {
        return this.statement;
    }

    private OperationLog operationLog() {
        return this.operationLog;
    }

    private Seq<String> planExcludes() {
        return this.planExcludes;
    }

    private PlanOnlyStyle style() {
        return this.style;
    }

    @Override
    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this.operationLog());
    }

    @Override
    public StructType resultSchema() {
        if (this.result() == null) {
            return new StructType().add("plan", "string");
        }
        if (this.result().isEmpty()) {
            return new StructType().add("result", "string");
        }
        return this.result().schema();
    }

    @Override
    public void beforeRun() {
        OperationLog$.MODULE$.setCurrentOperationLog(this.operationLog());
        super.beforeRun();
    }

    @Override
    public void runInternal() {
        try {
            this.withLocalProperties((Function0 & Serializable & scala.Serializable)() -> SQLConf$.MODULE$.withExistingConf(this.spark().sessionState().conf(), (Function0 & Serializable & scala.Serializable)() -> {
                LogicalPlan parsed;
                LogicalPlan logicalPlan = parsed = this.spark().sessionState().sqlParser().parsePlan(this.statement());
                if (this.planExcludes().contains((Object)logicalPlan.getClass().getSimpleName())) {
                    this.result_$eq((Dataset<Row>)this.spark().sql(this.statement()));
                    this.iter_$eq(new ArrayFetchIterator(this.result().collect()));
                    return BoxedUnit.UNIT;
                }
                PlanOnlyStyle planOnlyStyle = this.style();
                if (PlainStyle$.MODULE$.equals(planOnlyStyle)) {
                    this.explainWithPlainStyle(logicalPlan);
                    return BoxedUnit.UNIT;
                }
                if (JsonStyle$.MODULE$.equals(planOnlyStyle)) {
                    this.explainWithJsonStyle(logicalPlan);
                    return BoxedUnit.UNIT;
                }
                if (UnknownStyle$.MODULE$.equals(planOnlyStyle)) {
                    return PlanOnlyStyle$.MODULE$.unknownStyleError(this.style());
                }
                throw PlanOnlyStyle$.MODULE$.notSupportedStyleError(planOnlyStyle, "Spark SQL");
            }));
        }
        catch (Throwable x$3) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(this.onError$default$1());
            if (catchExpr$1.isDefinedAt((Object)x$3)) {
                catchExpr$1.apply((Object)x$3);
            }
            throw x$3;
        }
    }

    private void explainWithPlainStyle(LogicalPlan plan) {
        PlanOnlyMode planOnlyMode = this.mode;
        if (ParseMode$.MODULE$.equals(planOnlyMode)) {
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{plan.toString()})), (List)Nil$.MODULE$)));
            return;
        }
        if (AnalyzeMode$.MODULE$.equals(planOnlyMode)) {
            LogicalPlan analyzed = this.spark().sessionState().analyzer().execute(plan);
            this.spark().sessionState().analyzer().checkAnalysis(analyzed);
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analyzed.toString()})), (List)Nil$.MODULE$)));
            return;
        }
        if (OptimizeMode$.MODULE$.equals(planOnlyMode)) {
            LogicalPlan analyzed = this.spark().sessionState().analyzer().execute(plan);
            this.spark().sessionState().analyzer().checkAnalysis(analyzed);
            LogicalPlan optimized = (LogicalPlan)this.spark().sessionState().optimizer().execute((TreeNode)analyzed);
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimized.toString()})), (List)Nil$.MODULE$)));
            return;
        }
        if (OptimizeWithStatsMode$.MODULE$.equals(planOnlyMode)) {
            LogicalPlan analyzed = this.spark().sessionState().analyzer().execute(plan);
            this.spark().sessionState().analyzer().checkAnalysis(analyzed);
            LogicalPlan optimized = (LogicalPlan)this.spark().sessionState().optimizer().execute((TreeNode)analyzed);
            optimized.stats();
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimized.treeString(true, true, SQLConf$.MODULE$.get().maxToStringFields(), false)})), (List)Nil$.MODULE$)));
            return;
        }
        if (PhysicalMode$.MODULE$.equals(planOnlyMode)) {
            SparkPlan physical = this.spark().sql(this.statement()).queryExecution().sparkPlan();
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{physical.toString()})), (List)Nil$.MODULE$)));
            return;
        }
        if (ExecutionMode$.MODULE$.equals(planOnlyMode)) {
            SparkPlan executed = this.spark().sql(this.statement()).queryExecution().executedPlan();
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executed.toString()})), (List)Nil$.MODULE$)));
            return;
        }
        if (UnknownMode$.MODULE$.equals(planOnlyMode)) {
            throw PlanOnlyMode$.MODULE$.unknownModeError(this.mode);
        }
        throw PlanOnlyMode$.MODULE$.notSupportedModeError(this.mode, "Spark SQL");
    }

    private void explainWithJsonStyle(LogicalPlan plan) {
        PlanOnlyMode planOnlyMode = this.mode;
        if (ParseMode$.MODULE$.equals(planOnlyMode)) {
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{plan.toJSON()})), (List)Nil$.MODULE$)));
            return;
        }
        if (AnalyzeMode$.MODULE$.equals(planOnlyMode)) {
            LogicalPlan analyzed = this.spark().sessionState().analyzer().execute(plan);
            this.spark().sessionState().analyzer().checkAnalysis(analyzed);
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analyzed.toJSON()})), (List)Nil$.MODULE$)));
            return;
        }
        if (OptimizeMode$.MODULE$.equals(planOnlyMode) ? true : OptimizeWithStatsMode$.MODULE$.equals(planOnlyMode)) {
            LogicalPlan analyzed = this.spark().sessionState().analyzer().execute(plan);
            this.spark().sessionState().analyzer().checkAnalysis(analyzed);
            LogicalPlan optimized = (LogicalPlan)this.spark().sessionState().optimizer().execute((TreeNode)analyzed);
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimized.toJSON()})), (List)Nil$.MODULE$)));
            return;
        }
        if (PhysicalMode$.MODULE$.equals(planOnlyMode)) {
            SparkPlan physical = this.spark().sql(this.statement()).queryExecution().sparkPlan();
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{physical.toJSON()})), (List)Nil$.MODULE$)));
            return;
        }
        if (ExecutionMode$.MODULE$.equals(planOnlyMode)) {
            SparkPlan executed = this.spark().sql(this.statement()).queryExecution().executedPlan();
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executed.toJSON()})), (List)Nil$.MODULE$)));
            return;
        }
        if (UnknownMode$.MODULE$.equals(planOnlyMode)) {
            throw PlanOnlyMode$.MODULE$.unknownModeError(this.mode);
        }
        throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(56).append("The operation mode ").append(this.mode).append(" doesn't support in Spark SQL engine.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
    }

    public PlanOnlyStatement(Session session, String statement, PlanOnlyMode mode) {
        this.session = session;
        this.statement = statement;
        this.mode = mode;
        super(session);
        this.operationLog = OperationLog$.MODULE$.createOperationLog(session, this.getHandle());
        this.planExcludes = (Seq)this.spark().conf().getOption(KyuubiConf$.MODULE$.OPERATION_PLAN_ONLY_EXCLUDES().key()).map((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(","))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.session.sessionManager().getConf().get(KyuubiConf$.MODULE$.OPERATION_PLAN_ONLY_EXCLUDES()));
        this.style = PlanOnlyStyle$.MODULE$.fromString(this.spark().conf().get(KyuubiConf$.MODULE$.OPERATION_PLAN_ONLY_OUT_STYLE().key(), session.sessionManager().getConf().get(KyuubiConf$.MODULE$.OPERATION_PLAN_ONLY_OUT_STYLE())));
        this.spark().conf().set(KyuubiConf$.MODULE$.OPERATION_PLAN_ONLY_OUT_STYLE().key(), this.style().name());
    }
}

