/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.engine.SemanticVersion;
import org.apache.kyuubi.engine.SemanticVersion$;
import org.apache.spark.SparkContext;
import org.apache.spark.package$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class KyuubiSparkUtil$
implements Logging {
    public static KyuubiSparkUtil$ MODULE$;
    private String diagnostics;
    private Tuple2<Object, Object> sparkMajorMinorVersion;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile byte bitmap$0;

    static {
        new KyuubiSparkUtil$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public final String SPARK_SCHEDULER_POOL_KEY() {
        return "spark.scheduler.pool";
    }

    public final String SPARK_SQL_EXECUTION_ID_KEY() {
        return "spark.sql.execution.id";
    }

    public SparkContext globalSparkContext() {
        return SparkSession$.MODULE$.active().sparkContext();
    }

    public void initializeSparkSession(SparkSession spark, Seq<String> initializationSQLs) {
        initializationSQLs.foreach((Function1 & Serializable & scala.Serializable)sql -> BoxesRunTime.boxToBoolean((boolean)KyuubiSparkUtil$.$anonfun$initializeSparkSession$1(spark, sql)));
    }

    public String engineId() {
        return this.globalSparkContext().applicationId();
    }

    private String diagnostics$lzycompute() {
        KyuubiSparkUtil$ kyuubiSparkUtil$ = this;
        synchronized (kyuubiSparkUtil$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                SparkContext sc = this.globalSparkContext();
                String webUrl = (String)sc.getConf().getOption("spark.org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter.param.PROXY_URI_BASES").orElse((Function0 & Serializable & scala.Serializable)() -> sc.uiWebUrl()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                this.diagnostics = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(298).append("\n       |           Spark application name: ").append(sc.appName()).append("\n       |                 application ID: ").append(this.engineId()).append("\n       |                 application web UI: ").append(webUrl).append("\n       |                 master: ").append(sc.master()).append("\n       |                 deploy mode: ").append(sc.deployMode()).append("\n       |                 version: ").append(sc.version()).append("\n       |           Start time: ").append(LocalDateTime.ofInstant(Instant.ofEpochMilli(sc.startTime()), ZoneId.systemDefault())).append("\n       |           User: ").append(sc.sparkUser()).toString())).stripMargin();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.diagnostics;
    }

    public String diagnostics() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.diagnostics$lzycompute() : this.diagnostics;
    }

    public boolean hiveClassesArePresent() {
        boolean bl;
        try {
            Class.forName("org.apache.spark.sql.hive.HiveSessionStateBuilder");
            Class.forName("org.apache.hadoop.hive.conf.HiveConf");
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl2 = throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError;
            if (!bl2) {
                throw throwable;
            }
            boolean bl3 = false;
            bl = bl3;
        }
        return bl;
    }

    private Tuple2<Object, Object> sparkMajorMinorVersion$lzycompute() {
        KyuubiSparkUtil$ kyuubiSparkUtil$ = this;
        synchronized (kyuubiSparkUtil$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String runtimeSparkVer = package$.MODULE$.SPARK_VERSION();
                SemanticVersion runtimeVersion = SemanticVersion$.MODULE$.apply(runtimeSparkVer);
                this.sparkMajorMinorVersion = new Tuple2.mcII.sp(runtimeVersion.majorVersion(), runtimeVersion.minorVersion());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkMajorMinorVersion;
    }

    public Tuple2<Object, Object> sparkMajorMinorVersion() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sparkMajorMinorVersion$lzycompute() : this.sparkMajorMinorVersion;
    }

    public static final /* synthetic */ boolean $anonfun$initializeSparkSession$1(SparkSession spark$1, String sql) {
        boolean bl;
        spark$1.sparkContext().setJobGroup("initialization sql queries", sql, true);
        MODULE$.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Execute initialization sql: ").append(sql).toString());
        try {
            bl = spark$1.sql(sql).isEmpty();
        }
        finally {
            spark$1.sparkContext().clearJobGroup();
        }
        return bl;
    }

    private KyuubiSparkUtil$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

