/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.curator.framework.recipes.queue;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kyuubi.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.kyuubi.shade.org.apache.curator.framework.api.BackgroundCallback;
import org.apache.kyuubi.shade.org.apache.curator.framework.api.BackgroundPathable;
import org.apache.kyuubi.shade.org.apache.curator.framework.api.CuratorEvent;
import org.apache.kyuubi.shade.org.apache.curator.framework.api.CuratorWatcher;
import org.apache.kyuubi.shade.org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.kyuubi.shade.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.kyuubi.shade.org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.kyuubi.shade.org.apache.curator.utils.PathUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;

class ChildrenCache
implements Closeable {
    private final CuratorFramework client;
    private final String path;
    private final AtomicReference<Data> children = new AtomicReference<Data>(new Data(Lists.newArrayList(), 0L));
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final CuratorWatcher watcher = new CuratorWatcher(){

        @Override
        public void process(WatchedEvent event) throws Exception {
            if (!ChildrenCache.this.isClosed.get()) {
                ChildrenCache.this.sync(true);
            }
        }
    };
    private final BackgroundCallback callback = new BackgroundCallback(){

        @Override
        public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
            if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                ChildrenCache.this.setNewChildren(event.getChildren());
            }
        }
    };

    ChildrenCache(CuratorFramework client, String path) {
        this.client = client;
        this.path = PathUtils.validatePath(path);
    }

    void start() throws Exception {
        this.sync(true);
    }

    @Override
    public void close() throws IOException {
        this.isClosed.set(true);
        this.notifyFromCallback();
    }

    Data getData() {
        return this.children.get();
    }

    Data blockingNextGetData(long startVersion) throws InterruptedException {
        return this.blockingNextGetData(startVersion, 0L, null);
    }

    synchronized Data blockingNextGetData(long startVersion, long maxWait, TimeUnit unit) throws InterruptedException {
        long maxWaitMs;
        long startMs = System.currentTimeMillis();
        boolean hasMaxWait = unit != null;
        long l = maxWaitMs = hasMaxWait ? unit.toMillis(maxWait) : -1L;
        while (startVersion == this.children.get().version) {
            if (hasMaxWait) {
                long elapsedMs = System.currentTimeMillis() - startMs;
                long thisWaitMs = maxWaitMs - elapsedMs;
                if (thisWaitMs <= 0L) break;
                this.wait(thisWaitMs);
                continue;
            }
            this.wait();
        }
        return this.children.get();
    }

    private synchronized void notifyFromCallback() {
        this.notifyAll();
    }

    private synchronized void sync(boolean watched) throws Exception {
        if (watched) {
            ((ErrorListenerPathable)((BackgroundPathable)this.client.getChildren().usingWatcher(this.watcher)).inBackground(this.callback)).forPath(this.path);
        } else {
            ((ErrorListenerPathable)this.client.getChildren().inBackground(this.callback)).forPath(this.path);
        }
    }

    private synchronized void setNewChildren(List<String> newChildren) {
        if (newChildren != null) {
            Data currentData = this.children.get();
            this.children.set(new Data(newChildren, currentData.version + 1L));
            this.notifyFromCallback();
        }
    }

    static class Data {
        final List<String> children;
        final long version;

        private Data(List<String> children, long version) {
            this.children = ImmutableList.copyOf(children);
            this.version = version;
        }
    }
}

