/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark;

import java.io.Serializable;
import java.nio.file.Path;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.spark.KyuubiSparkUtil$;
import org.apache.kyuubi.engine.spark.SparkSQLEngine;
import org.apache.kyuubi.engine.spark.events.EngineEvent;
import org.apache.kyuubi.engine.spark.events.EngineEvent$;
import org.apache.kyuubi.engine.spark.events.EngineEventsStore;
import org.apache.kyuubi.engine.spark.events.SparkEventLoggingService;
import org.apache.kyuubi.events.EventLogging$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.RetryPolicies$;
import org.apache.kyuubi.util.SignalRegister$;
import org.apache.spark.SparkConf;
import org.apache.spark.kyuubi.SparkContextHelper$;
import org.apache.spark.kyuubi.SparkUtilsHelper$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.ui.EngineTab;
import org.apache.spark.util.kvstore.KVStore;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SparkSQLEngine$
implements Logging,
scala.Serializable {
    public static SparkSQLEngine$ MODULE$;
    private String user;
    private SparkConf _sparkConf;
    private KyuubiConf _kyuubiConf;
    private Option<SparkSQLEngine> currentEngine;
    private final CountDownLatch org$apache$kyuubi$engine$spark$SparkSQLEngine$$countDownLatch;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new SparkSQLEngine$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private SparkConf _sparkConf() {
        return this._sparkConf;
    }

    private void _sparkConf_$eq(SparkConf x$1) {
        this._sparkConf = x$1;
    }

    private KyuubiConf _kyuubiConf() {
        return this._kyuubiConf;
    }

    private void _kyuubiConf_$eq(KyuubiConf x$1) {
        this._kyuubiConf = x$1;
    }

    public KyuubiConf kyuubiConf() {
        return this._kyuubiConf();
    }

    public Option<SparkSQLEngine> currentEngine() {
        return this.currentEngine;
    }

    public void currentEngine_$eq(Option<SparkSQLEngine> x$1) {
        this.currentEngine = x$1;
    }

    private String user$lzycompute() {
        SparkSQLEngine$ sparkSQLEngine$ = this;
        synchronized (sparkSQLEngine$) {
            if (!this.bitmap$0) {
                this.user = Utils$.MODULE$.currentUser();
                this.bitmap$0 = true;
            }
        }
        return this.user;
    }

    private String user() {
        return !this.bitmap$0 ? this.user$lzycompute() : this.user;
    }

    public CountDownLatch org$apache$kyuubi$engine$spark$SparkSQLEngine$$countDownLatch() {
        return this.org$apache$kyuubi$engine$spark$SparkSQLEngine$$countDownLatch;
    }

    public void setupConf() {
        block0: {
            this._sparkConf_$eq(new SparkConf());
            this._kyuubiConf_$eq(new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1()));
            String rootDir = (String)this._sparkConf().getOption("spark.repl.classdir").getOrElse((Function0 & Serializable & scala.Serializable)() -> SparkUtilsHelper$.MODULE$.getLocalDir(MODULE$._sparkConf()));
            Path outputDir = Utils$.MODULE$.createTempDir(rootDir, "repl");
            this._sparkConf().setIfMissing("spark.sql.execution.topKSortFallbackThreshold", "10000");
            this._sparkConf().setIfMissing("spark.sql.legacy.castComplexTypesToString.enabled", "true");
            this._sparkConf().setIfMissing("spark.master", "local");
            this._sparkConf().setIfMissing("spark.ui.port", "0");
            this._sparkConf().set("spark.repl.class.outputDir", outputDir.toFile().getAbsolutePath());
            this._sparkConf().setIfMissing("spark.hadoop.mapreduce.input.fileinputformat.list-status.num-threads", "20");
            String appName = new StringBuilder(14).append("kyuubi_").append(this.user()).append("_spark_").append(Instant.now()).toString();
            this._sparkConf().setIfMissing("spark.app.name", appName);
            String defaultCat = KyuubiSparkUtil$.MODULE$.hiveClassesArePresent() ? "hive" : "in-memory";
            this._sparkConf().setIfMissing("spark.sql.catalogImplementation", defaultCat);
            this.kyuubiConf().setIfMissing(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_BIND_PORT(), BoxesRunTime.boxToInteger((int)0));
            this.kyuubiConf().setIfMissing(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_RETRY_POLICY(), RetryPolicies$.MODULE$.N_TIME().toString());
            String sparkToKyuubiPrefix = "spark.kyuubi.";
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._sparkConf().getAllWithPrefix(sparkToKyuubiPrefix))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                KyuubiConf kyuubiConf = MODULE$.kyuubiConf().set(new StringBuilder(7).append("kyuubi.").append(k).toString(), v);
                return kyuubiConf;
            });
            if (!this.logger().isDebugEnabled()) break block0;
            this.kyuubiConf().getAll().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                SparkSQLEngine$.$anonfun$setupConf$3(x0$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public SparkSession createSpark() {
        void var1_1;
        SparkSession session = SparkSession$.MODULE$.builder().config(this._sparkConf()).getOrCreate();
        ((IterableLike)((TraversableLike)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_INITIALIZE_SQL())).$plus$plus((GenTraversableOnce)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_SESSION_INITIALIZE_SQL()), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)sqlStr -> {
            SparkSQLEngine$.$anonfun$createSpark$1(session, sqlStr);
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    public void startEngine(SparkSession spark) {
        this.currentEngine_$eq((Option<SparkSQLEngine>)new Some((Object)new SparkSQLEngine(spark)));
        this.currentEngine().foreach((Function1 & Serializable & scala.Serializable)engine -> {
            SparkSQLEngine$.$anonfun$startEngine$1(spark, engine);
            return BoxedUnit.UNIT;
        });
    }

    public void main(String[] args) {
        block12: {
            long l;
            long startedTime = System.currentTimeMillis();
            Option<String> option = this.kyuubiConf().getOption("kyuubi.engine.submit.time");
            if (option instanceof Some) {
                Some some = (Some)option;
                String t = (String)some.value();
                l = new StringOps(Predef$.MODULE$.augmentString(t)).toLong();
            } else {
                l = startedTime;
            }
            long submitTime = l;
            long initTimeout = BoxesRunTime.unboxToLong((Object)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
            long totalInitTime = startedTime - submitTime;
            if (totalInitTime > initTimeout) {
                throw new KyuubiException(new StringBuilder(119).append("The total engine initialization time (").append(totalInitTime).append(" ms)").append(" exceeds `kyuubi.session.engine.initialize.timeout` (").append(initTimeout).append(" ms),").append(" and submitted at ").append(submitTime).append(".").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
            SparkSession spark = null;
            try {
                try {
                    spark = this.createSpark();
                    try {
                        this.startEngine(spark);
                        this.org$apache$kyuubi$engine$spark$SparkSQLEngine$$countDownLatch().await();
                    }
                    catch (KyuubiException e) {
                        Option<SparkSQLEngine> option2 = this.currentEngine();
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            SparkSQLEngine engine = (SparkSQLEngine)some.value();
                            engine.stop();
                            EngineEvent qual$1 = EngineEvent$.MODULE$.apply(engine);
                            String x$1 = e.getMessage();
                            String x$2 = qual$1.copy$default$1();
                            Option<String> x$3 = qual$1.copy$default$2();
                            String x$4 = qual$1.copy$default$3();
                            String x$5 = qual$1.copy$default$4();
                            String x$6 = qual$1.copy$default$5();
                            String x$7 = qual$1.copy$default$6();
                            String x$8 = qual$1.copy$default$7();
                            String x$9 = qual$1.copy$default$8();
                            String x$10 = qual$1.copy$default$9();
                            long x$11 = qual$1.copy$default$10();
                            long x$12 = qual$1.copy$default$11();
                            int x$13 = qual$1.copy$default$12();
                            Map<String, String> x$14 = qual$1.copy$default$14();
                            EngineEvent event = qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$1, x$14);
                            EventLogging$.MODULE$.onEvent(event);
                            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> event, e);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block12;
                        }
                        this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Current SparkSQLEngine is not created.");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                catch (Throwable t) {
                    this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Failed to instantiate SparkSession: ").append(t.getMessage()).toString(), t);
                }
            }
            finally {
                if (spark != null) {
                    spark.stop();
                }
            }
        }
    }

    public SparkSQLEngine apply(SparkSession spark) {
        return new SparkSQLEngine(spark);
    }

    public Option<SparkSession> unapply(SparkSQLEngine x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.spark());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$setupConf$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        MODULE$.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("KyuubiConf: ").append(k).append(" = ").append(v).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$createSpark$1(SparkSession session$1, String sqlStr) {
        session$1.sparkContext().setJobGroup("engine_initializing_queries", sqlStr, true);
        MODULE$.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Execute session initializing sql: ").append(sqlStr).toString());
        session$1.sql(sqlStr).isEmpty();
        session$1.sparkContext().clearJobGroup();
    }

    public static final /* synthetic */ void $anonfun$startEngine$1(SparkSession spark$1, SparkSQLEngine engine) {
        SparkEventLoggingService eventLogging = new SparkEventLoggingService(spark$1.sparkContext());
        try {
            eventLogging.initialize(MODULE$.kyuubiConf());
            eventLogging.start();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                MODULE$.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to initialize EventLoggingService: ").append(e.getMessage()).toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        try {
            engine.initialize(MODULE$.kyuubiConf());
            EventLogging$.MODULE$.onEvent(EngineEvent$.MODULE$.apply(engine));
        }
        catch (Throwable t) {
            throw new KyuubiException(new StringBuilder(37).append("Failed to initialize SparkSQLEngine: ").append(t.getMessage()).toString(), t);
        }
        try {
            engine.start();
            ElementTrackingStore kvStore = SparkContextHelper$.MODULE$.getKvStore(spark$1.sparkContext());
            EngineEventsStore store = new EngineEventsStore((KVStore)kvStore);
            new EngineTab((Option<SparkSQLEngine>)new Some((Object)engine), SparkContextHelper$.MODULE$.getSparkUI(spark$1.sparkContext()), store, MODULE$.kyuubiConf());
            EngineEvent event = EngineEvent$.MODULE$.apply(engine);
            MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> event);
            EventLogging$.MODULE$.onEvent(event);
        }
        catch (Throwable t) {
            throw new KyuubiException(new StringBuilder(32).append("Failed to start SparkSQLEngine: ").append(t.getMessage()).toString(), t);
        }
        Utils$.MODULE$.addShutdownHook(() -> engine.stop(), Utils$.MODULE$.SPARK_CONTEXT_SHUTDOWN_PRIORITY() + 2);
        Utils$.MODULE$.addShutdownHook(() -> eventLogging.stop(), Utils$.MODULE$.SPARK_CONTEXT_SHUTDOWN_PRIORITY() + 1);
    }

    private SparkSQLEngine$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.currentEngine = None$.MODULE$;
        this.org$apache$kyuubi$engine$spark$SparkSQLEngine$$countDownLatch = new CountDownLatch(1);
        SignalRegister$.MODULE$.registerLogger(this.logger());
        this.setupConf();
    }
}

