/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.buffer.impl;

import org.apache.kyuubi.shade.io.netty.buffer.AbstractByteBufAllocator;
import org.apache.kyuubi.shade.io.netty.buffer.ByteBuf;
import org.apache.kyuubi.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.kyuubi.shade.io.netty.buffer.PooledByteBufAllocator;
import org.apache.kyuubi.shade.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.kyuubi.shade.io.netty.util.internal.PlatformDependent;
import org.apache.kyuubi.shade.io.vertx.core.buffer.impl.VertxHeapByteBuf;
import org.apache.kyuubi.shade.io.vertx.core.buffer.impl.VertxUnsafeHeapByteBuf;

public abstract class VertxByteBufAllocator
extends AbstractByteBufAllocator {
    public static final ByteBufAllocator POOLED_ALLOCATOR = new PooledByteBufAllocator(true);
    public static final ByteBufAllocator UNPOOLED_ALLOCATOR = new UnpooledByteBufAllocator(false);
    private static final VertxByteBufAllocator UNSAFE_IMPL = new VertxByteBufAllocator(){

        @Override
        protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
            return new VertxUnsafeHeapByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity);
        }
    };
    private static final VertxByteBufAllocator IMPL = new VertxByteBufAllocator(){

        @Override
        protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
            return new VertxHeapByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity);
        }
    };
    public static final VertxByteBufAllocator DEFAULT = PlatformDependent.hasUnsafe() ? UNSAFE_IMPL : IMPL;

    @Override
    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        return UNPOOLED_ALLOCATOR.directBuffer(initialCapacity, maxCapacity);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return false;
    }
}

