/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.arrow;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kyuubi.jdbc.hive.arrow.ArrowColumnVector;
import org.apache.kyuubi.jdbc.hive.arrow.ArrowColumnarBatchRow;

public class ArrowColumnarBatch
implements AutoCloseable {
    protected int numRows;
    protected final ArrowColumnVector[] columns;
    protected final ArrowColumnarBatchRow row;

    @Override
    public void close() {
        for (ArrowColumnVector c : this.columns) {
            c.close();
        }
    }

    public Iterator<ArrowColumnarBatchRow> rowIterator() {
        final int maxRows = this.numRows;
        final ArrowColumnarBatchRow row = new ArrowColumnarBatchRow(this.columns);
        return new Iterator<ArrowColumnarBatchRow>(){
            int rowId = 0;

            @Override
            public boolean hasNext() {
                return this.rowId < maxRows;
            }

            @Override
            public ArrowColumnarBatchRow next() {
                if (this.rowId >= maxRows) {
                    throw new NoSuchElementException();
                }
                row.rowId = this.rowId++;
                return row;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public int numCols() {
        return this.columns.length;
    }

    public int numRows() {
        return this.numRows;
    }

    public ArrowColumnVector column(int ordinal) {
        return this.columns[ordinal];
    }

    public ArrowColumnarBatchRow getRow(int rowId) {
        assert (rowId >= 0 && rowId < this.numRows);
        this.row.rowId = rowId;
        return this.row;
    }

    public ArrowColumnarBatch(ArrowColumnVector[] columns) {
        this(columns, 0);
    }

    public ArrowColumnarBatch(ArrowColumnVector[] columns, int numRows) {
        this.columns = columns;
        this.numRows = numRows;
        this.row = new ArrowColumnarBatchRow(columns);
    }
}

