/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.jdbc;

import java.io.Serializable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.deploy.DeployMode$;
import org.apache.kyuubi.engine.jdbc.JdbcProcessBuilder;
import org.apache.kyuubi.engine.jdbc.JdbcYarnModeProcessBuilder;
import org.apache.kyuubi.operation.log.OperationLog;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;

public final class JdbcProcessBuilder$
implements Logging {
    public static JdbcProcessBuilder$ MODULE$;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new JdbcProcessBuilder$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Option<OperationLog> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public final String JDBC_ENGINE_NAME() {
        return "jdbc.engine.name";
    }

    public JdbcProcessBuilder apply(String proxyUser, boolean doAsEnabled, KyuubiConf conf, String engineRefId, Option<OperationLog> extraEngineLog, String defaultEngineName) {
        this.checkKeytab(proxyUser, conf);
        Enumeration.Value value = DeployMode$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_JDBC_DEPLOY_MODE()));
        Enumeration.Value value2 = DeployMode$.MODULE$.LOCAL();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return new JdbcProcessBuilder(proxyUser, doAsEnabled, conf, engineRefId, extraEngineLog);
        }
        Enumeration.Value value4 = DeployMode$.MODULE$.YARN();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "JDBC on YARN model is experimental.");
            conf.setIfMissing((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_DEPLOY_YARN_MODE_APP_NAME(), (Object)new Some((Object)defaultEngineName));
            return new JdbcYarnModeProcessBuilder(proxyUser, doAsEnabled, conf, engineRefId, extraEngineLog);
        }
        throw new KyuubiException(new StringBuilder(25).append("Unsupported deploy mode: ").append(value).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
    }

    private void checkKeytab(String proxyUser, KyuubiConf conf) {
        Option principal = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_PRINCIPAL());
        Option keytab = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_KEYTAB());
        if (!UserGroupInformation.isSecurityEnabled()) {
            if (principal.isDefined() || keytab.isDefined()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Principal and keytab takes no effect when hadoop security is not enabled.");
            }
            return;
        }
        Predef$.MODULE$.require(principal.isDefined() == keytab.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Both principal and keytab must be defined, or neither.");
        if (principal.isDefined() && keytab.isDefined()) {
            UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)((String)principal.get()), (String)((String)keytab.get()));
            String string = ugi.getShortUserName();
            String string2 = proxyUser;
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Proxy user: ").append(proxyUser).append(" is not same with ").append("engine principal: ").append(ugi.getShortUserName()).append(".").toString());
        }
        Enumeration.Value deployMode = DeployMode$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_JDBC_DEPLOY_MODE()));
        if (principal.isEmpty() && keytab.isEmpty()) {
            Enumeration.Value value = deployMode;
            Enumeration.Value value2 = DeployMode$.MODULE$.YARN();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "JDBC on YARN can not work properly without principal and keytab.");
                return;
            }
        }
    }

    private JdbcProcessBuilder$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

