/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.engine.KubernetesApplicationOperation$;
import org.apache.kyuubi.engine.KubernetesInfo;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;

public final class KubernetesApplicationAuditLogger$
implements Logging {
    public static KubernetesApplicationAuditLogger$ MODULE$;
    private final ThreadLocal<scala.collection.mutable.StringBuilder> AUDIT_BUFFER;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new KubernetesApplicationAuditLogger$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private final ThreadLocal<scala.collection.mutable.StringBuilder> AUDIT_BUFFER() {
        return this.AUDIT_BUFFER;
    }

    public void audit(Enumeration.Value eventType, KubernetesInfo kubernetesInfo, Pod pod, Enumeration.Value appStateSource, String appStateContainer) {
        scala.collection.mutable.StringBuilder sb = this.AUDIT_BUFFER().get();
        sb.setLength(0);
        sb.append("eventType=").append((Object)eventType).append("\t");
        sb.append(new StringBuilder(6).append("label=").append(pod.getMetadata().getLabels().get(KubernetesApplicationOperation$.MODULE$.LABEL_KYUUBI_UNIQUE_KEY())).toString()).append("\t");
        sb.append(new StringBuilder(8).append("context=").append(kubernetesInfo.context().orNull(Predef$.MODULE$.$conforms())).toString()).append("\t");
        sb.append(new StringBuilder(10).append("namespace=").append(kubernetesInfo.namespace().orNull(Predef$.MODULE$.$conforms())).toString()).append("\t");
        sb.append(new StringBuilder(4).append("pod=").append(pod.getMetadata().getName()).toString()).append("\t");
        sb.append(new StringBuilder(9).append("podState=").append(pod.getStatus().getPhase()).toString()).append("\t");
        String containerStatuses = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getStatus().getContainerStatuses()).asScala()).map((Function1 & Serializable & scala.Serializable)containerState -> new StringBuilder(2).append(containerState.getName()).append("->").append(containerState.getState()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
        sb.append(new StringBuilder(11).append("containers=").append(containerStatuses).toString()).append("\t");
        sb.append(new StringBuilder(6).append("appId=").append(KubernetesApplicationOperation$.MODULE$.getPodAppId(pod)).toString()).append("\t");
        sb.append(new StringBuilder(8).append("appName=").append(KubernetesApplicationOperation$.MODULE$.getPodAppName(pod)).toString()).append("\t");
        Tuple2<Enumeration.Value, Option<String>> tuple2 = KubernetesApplicationOperation$.MODULE$.toApplicationStateAndError(pod, appStateSource, appStateContainer, eventType);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Enumeration.Value appState = (Enumeration.Value)tuple2._1();
        Option appError = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)appState, (Object)appError);
        Enumeration.Value appState2 = (Enumeration.Value)tuple22._1();
        Option appError2 = (Option)tuple22._2();
        sb.append(new StringBuilder(9).append("appState=").append(appState2).toString()).append("\t");
        sb.append(new StringBuilder(11).append("appError='").append(appError2.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'").toString());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> sb.toString());
    }

    private KubernetesApplicationAuditLogger$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.AUDIT_BUFFER = new ThreadLocal<scala.collection.mutable.StringBuilder>(){

            public scala.collection.mutable.StringBuilder initialValue() {
                return new scala.collection.mutable.StringBuilder();
            }
        };
    }
}

