/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.KyuubiBatchService;
import org.apache.kyuubi.server.KyuubiRestFrontendService$;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.api.v1.ApiRootResource$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.server.http.authentication.KyuubiHttpAuthenticationFactory;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.ui.JettyServer;
import org.apache.kyuubi.server.ui.JettyServer$;
import org.apache.kyuubi.server.ui.JettyUtils$;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.service.authentication.AuthTypes$;
import org.apache.kyuubi.service.authentication.AuthUtils$;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.util.JavaUtils;
import org.apache.kyuubi.util.ThreadUtils$;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0012%\u00015B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t%\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005m!)!\b\u0001C\u0001w!IQ\u0005\u0001a\u0001\u0002\u0004%Ia\u0010\u0005\n\r\u0002\u0001\r\u00111A\u0005\n\u001dC\u0011\u0002\u0015\u0001A\u0002\u0003\u0005\u000b\u0015\u0002!\t\u000fE\u0003!\u0019!C\u0005%\"1q\f\u0001Q\u0001\nMCQ\u0001\u0019\u0001\u0005\n\u0005DaA\u001b\u0001\u0005\u0002\u0019Z\u0007b\u0002:\u0001\u0005\u0004%Ia\u001d\u0005\u0007q\u0002\u0001\u000b\u0011\u0002;\t\u0013e\u0004\u0001R1A\u0005\u0002\u0019R\bBCA\u0002\u0001!\u0015\r\u0011\"\u0001\u0002\u0006!Q\u0011Q\u0004\u0001\t\u0006\u0004%I!a\b\t\u0017\u0005\u001d\u0002\u0001#b\u0001\n\u00031\u0013\u0011\u0006\u0005\u000b\u0003c\u0001\u0001R1A\u0005\n\u0005M\u0002bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003\u0007\u0002A\u0011IA#\u0011\u001d\t)\u0006\u0001C!\u0003\u000bAq!a\u0016\u0001\t\u0013\tI\u0006C\u0004\u0002\\\u0001!I!!\u0017\t\u000f\u0005u\u0003\u0001\"\u0003\u0002Z!A\u0011q\f\u0001\u0005\u0002\u0019\nI\u0006C\u0004\u0002|\u0001!\t!!\u0017\t\u000f\u0005u\u0004\u0001\"\u0011\u0002Z!9\u0011q\u0010\u0001\u0005B\u0005e\u0003bBAA\u0001\u0011\u0005\u00111\u0011\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\t)\t\u0001C\u0001\u0003\u001bCq!!'\u0001\t\u0003\t)\u0001C\u0004\u0002\u001c\u0002!I!!(\t\u0013\u0005%\u0006A1A\u0005B\u0005-\u0006\u0002CA[\u0001\u0001\u0006I!!,\u00033-KX/\u001e2j%\u0016\u001cHO\u0012:p]R,g\u000eZ*feZL7-\u001a\u0006\u0003K\u0019\naa]3sm\u0016\u0014(BA\u0014)\u0003\u0019Y\u00170^;cS*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E2\u0013aB:feZL7-Z\u0005\u0003gA\u0012q#\u00112tiJ\f7\r\u001e$s_:$XM\u001c3TKJ4\u0018nY3\u0002\u0015M,'O^3sC\ndW-F\u00017!\tys'\u0003\u00029a\tQ1+\u001a:wKJ\f'\r\\3\u0002\u0017M,'O^3sC\ndW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005qr\u0004CA\u001f\u0001\u001b\u0005!\u0003\"\u0002\u001b\u0004\u0001\u00041T#\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r#\u0013AA;j\u0013\t)%IA\u0006KKR$\u0018pU3sm\u0016\u0014\u0018AC:feZ,'o\u0018\u0013fcR\u0011\u0001J\u0014\t\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\u0005+:LG\u000fC\u0004P\u000b\u0005\u0005\t\u0019\u0001!\u0002\u0007a$\u0013'A\u0004tKJ4XM\u001d\u0011\u0002\u0013%\u001c8\u000b^1si\u0016$W#A*\u0011\u0005QkV\"A+\u000b\u0005Y;\u0016AB1u_6L7M\u0003\u0002Y3\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005i[\u0016\u0001B;uS2T\u0011\u0001X\u0001\u0005U\u00064\u0018-\u0003\u0002_+\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f!\"[:Ti\u0006\u0014H/\u001a3!\u0003)A\u0017\rZ8pa\u000e{gNZ\u000b\u0002EB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0005G>tgM\u0003\u0002hQ\u00051\u0001.\u00193p_BL!!\u001b3\u0003\u001b\r{gNZ5hkJ\fG/[8o\u00039\u0019Xm]:j_:l\u0015M\\1hKJ,\u0012\u0001\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0003_\u001a\nqa]3tg&|g.\u0003\u0002r]\n!2*_;vE&\u001cVm]:j_:l\u0015M\\1hKJ\fABY1uG\"\u001c\u0005.Z2lKJ,\u0012\u0001\u001e\t\u0003kZl\u0011aV\u0005\u0003o^\u0013\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u00035\u0011\u0017\r^2i\u0007\",7m[3sA\u0005a!-\u0019;dQN+'O^5dKV\t1\u0010E\u0002JyzL!! &\u0003\r=\u0003H/[8o!\tit0C\u0002\u0002\u0002\u0011\u0012!cS=vk\nL')\u0019;dQN+'O^5dK\u0006!\u0001n\\:u+\t\t9\u0001\u0005\u0003\u0002\n\u0005]a\u0002BA\u0006\u0003'\u00012!!\u0004K\u001b\t\tyAC\u0002\u0002\u00121\na\u0001\u0010:p_Rt\u0014bAA\u000b\u0015\u00061\u0001K]3eK\u001aLA!!\u0007\u0002\u001c\t11\u000b\u001e:j]\u001eT1!!\u0006K\u0003\u0011\u0001xN\u001d;\u0016\u0005\u0005\u0005\u0002cA%\u0002$%\u0019\u0011Q\u0005&\u0003\u0007%sG/A\btK\u000e,(/\u001b;z\u000b:\f'\r\\3e+\t\tY\u0003E\u0002J\u0003[I1!a\fK\u0005\u001d\u0011un\u001c7fC:\fa\"\u00193nS:L7\u000f\u001e:bi>\u00148/\u0006\u0002\u00026A1\u0011\u0011BA\u001c\u0003\u000fIA!!\u000f\u0002\u001c\t\u00191+\u001a;\u0002\u001f%\u001c\u0018\tZ7j]&\u001cHO]1u_J$B!a\u000b\u0002@!9\u0011\u0011\t\nA\u0002\u0005\u001d\u0011\u0001C;tKJt\u0015-\\3\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0002I\u0003\u000fBa!Z\nA\u0002\u0005%\u0003\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=c%\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003'\niE\u0001\u0006LsV,(-[\"p]\u001a\fQbY8o]\u0016\u001cG/[8o+Jd\u0017!D:uCJ$\u0018J\u001c;fe:\fG\u000eF\u0001I\u00031Ign\u001d;bY2<VMY+J\u0003E\u0019H/\u0019:u\u0005\u0006$8\r[\"iK\u000e\\WM]\u0001\u0015e\u0016\u001cwN^3s\u0005\u0006$8\r[*fgNLwN\\:)\u0007a\t\u0019\u0007\u0005\u0003\u0002f\u0005]TBAA4\u0015\u0011\tI'a\u001b\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0005\u0003[\ny'\u0001\u0004d_6lwN\u001c\u0006\u0005\u0003c\n\u0019(\u0001\u0004h_><G.\u001a\u0006\u0003\u0003k\n1aY8n\u0013\u0011\tI(a\u001a\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw-\u0001\u000bxC&$hi\u001c:TKJ4XM]*uCJ$X\rZ\u0001\u0006gR\f'\u000f^\u0001\u0005gR|\u0007/A\u0006hKR\u0014V-\u00197Vg\u0016\u0014HCAA\u0004\u000399W\r^*fgNLwN\\+tKJ$B!a\u0002\u0002\n\"9\u00111R\u000fA\u0002\u0005\u001d\u0011!\u00039s_bLXk]3s)\u0011\t9!a$\t\u000f\u0005Ee\u00041\u0001\u0002\u0014\u0006Y1/Z:tS>t7i\u001c8g!!\tI!!&\u0002\b\u0005\u001d\u0011\u0002BAL\u00037\u00111!T1q\u000319W\r^%q\u0003\u0012$'/Z:t\u000319W\r\u001e)s_bLXk]3s)!\t9!a(\u0002\"\u0006\u0015\u0006bBAIA\u0001\u0007\u00111\u0013\u0005\b\u0003G\u0003\u0003\u0019AA\u0004\u0003%I\u0007/\u00113ee\u0016\u001c8\u000fC\u0004\u0002(\u0002\u0002\r!a\u0002\u0002\u0011I,\u0017\r\\+tKJ\f\u0001\u0003Z5tG>4XM]=TKJ4\u0018nY3\u0016\u0005\u00055\u0006\u0003B%}\u0003_\u00032aLAY\u0013\r\t\u0019\f\r\u0002\b'\u0016\u0014h/[2f\u0003E!\u0017n]2pm\u0016\u0014\u0018pU3sm&\u001cW\r\t")
public class KyuubiRestFrontendService
extends AbstractFrontendService {
    private Option<KyuubiBatchService> batchService;
    private String host;
    private int port;
    private boolean securityEnabled;
    private Set<String> administrators;
    private final Serverable serverable;
    private JettyServer server;
    private final AtomicBoolean isStarted;
    private final ScheduledExecutorService batchChecker;
    private final Option<Service> discoveryService;
    private volatile byte bitmap$0;

    public Serverable serverable() {
        return this.serverable;
    }

    private JettyServer server() {
        return this.server;
    }

    private void server_$eq(JettyServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean isStarted() {
        return this.isStarted;
    }

    private Configuration hadoopConf() {
        return KyuubiServer$.MODULE$.getHadoopConf();
    }

    public KyuubiSessionManager sessionManager() {
        return (KyuubiSessionManager)this.be().sessionManager();
    }

    private ScheduledExecutorService batchChecker() {
        return this.batchChecker;
    }

    private Option<KyuubiBatchService> batchService$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.batchService = BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.BATCH_SUBMITTER_ENABLED())) ? new Some((Object)new KyuubiBatchService(this, this.sessionManager())) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.batchService;
    }

    public Option<KyuubiBatchService> batchService() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.batchService$lzycompute();
        }
        return this.batchService;
    }

    private String host$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.host = (String)((Option)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_HOST())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    if (JavaUtils.isWindows || JavaUtils.isMac) {
                        this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Kyuubi Server run in Windows or Mac environment, binding ").append(this.getName()).append(" to 0.0.0.0").toString());
                        return "0.0.0.0";
                    }
                    if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_CONNECTION_URL_USE_HOSTNAME()))) {
                        return JavaUtils.findLocalInetAddress().getCanonicalHostName();
                    }
                    return JavaUtils.findLocalInetAddress().getHostAddress();
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.host;
    }

    public String host() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.host$lzycompute();
        }
        return this.host;
    }

    private int port$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.port = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_PORT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.port;
    }

    private int port() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.port$lzycompute();
        }
        return this.port;
    }

    private boolean securityEnabled$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                Seq authTypes = (Seq)((TraversableLike)this.conf().get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).map((Function1 & Serializable & scala.Serializable)s -> AuthTypes$.MODULE$.withName(s), Seq$.MODULE$.canBuildFrom());
                this.securityEnabled = AuthUtils$.MODULE$.kerberosEnabled(authTypes) || !AuthUtils$.MODULE$.effectivePlainAuthType(authTypes).contains((Object)AuthTypes$.MODULE$.NONE());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.securityEnabled;
    }

    public boolean securityEnabled() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.securityEnabled$lzycompute();
        }
        return this.securityEnabled;
    }

    private Set<String> administrators$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.administrators = (Set)((SetLike)this.conf().get(KyuubiConf$.MODULE$.SERVER_ADMINISTRATORS())).$plus((Object)Utils$.MODULE$.currentUser());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.administrators;
    }

    private Set<String> administrators() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.administrators$lzycompute();
        }
        return this.administrators;
    }

    public boolean isAdministrator(String userName) {
        if (this.securityEnabled()) {
            return this.administrators().contains((Object)userName);
        }
        return true;
    }

    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.server_$eq(JettyServer$.MODULE$.apply(this.getName(), this.host(), this.port(), BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_MAX_WORKER_THREADS())), BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_JETTY_STOP_TIMEOUT())), BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_JETTY_SEND_VERSION_ENABLED()))));
        this.batchService().foreach((Function1 & Serializable & scala.Serializable)service -> {
            this.addService(service);
            return BoxedUnit.UNIT;
        });
        super.initialize(conf);
    }

    public String connectionUrl() {
        this.checkInitialized();
        Option option = (Option)this.conf().get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_ADVERTISED_HOST());
        if (option instanceof Some) {
            Some some = (Some)option;
            String advertisedHost = (String)some.value();
            return new StringBuilder(1).append(advertisedHost).append(":").append(this.port()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return this.server().getServerUri();
        }
        throw new MatchError((Object)option);
    }

    private void startInternal() {
        ServletContextHandler contextHandler = ApiRootResource$.MODULE$.getServletHandler(this);
        FilterHolder holder = new FilterHolder((Filter)new AuthenticationFilter(this.conf()));
        contextHandler.addFilter(holder, "/v1/*", EnumSet.allOf(DispatcherType.class));
        KyuubiHttpAuthenticationFactory authenticationFactory = new KyuubiHttpAuthenticationFactory(this.conf());
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)contextHandler));
        ServletContextHandler proxyHandler = ApiRootResource$.MODULE$.getEngineUIProxyHandler(this);
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)proxyHandler));
        if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_UI_ENABLED()))) {
            this.installWebUI();
            return;
        }
    }

    private void installWebUI() {
        this.server().addRedirectHandler("/", "/ui");
        ServletContextHandler servletHandler = JettyUtils$.MODULE$.createStaticHandler("dist", "/ui");
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.addErrorPage(404, "/");
        servletHandler.setErrorHandler((ErrorHandler)errorHandler);
        this.server().addHandler((Handler)servletHandler);
    }

    private void startBatchChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.BATCH_CHECK_INTERVAL()));
        Runnable task = new Runnable(this){
            private final /* synthetic */ KyuubiRestFrontendService $outer;

            public void run() {
                try {
                    this.$outer.sessionManager().getPeerInstanceClosedBatchSessions(this.$outer.connectionUrl()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        $anon$1.$anonfun$run$1(this, batch);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable e) {
                    this.$outer.error((Function0 & Serializable & scala.Serializable)() -> "Error checking batch sessions", e);
                }
            }

            public static final /* synthetic */ void $anonfun$run$3(KyuubiBatchSession x$1) {
                x$1.close();
            }

            public static final /* synthetic */ void $anonfun$run$1($anon$1 $this, Metadata batch) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    SessionHandle sessionHandle = SessionHandle$.MODULE$.fromUUID(batch.identifier());
                    $this.$outer.sessionManager().getBatchSession(sessionHandle).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        $anon$1.$anonfun$run$3(x$1);
                        return BoxedUnit.UNIT;
                    });
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata ), $anonfun$run$4(), $anonfun$run$3$adapted(org.apache.kyuubi.session.KyuubiBatchSession ), $anonfun$run$2(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata )}, serializedLambda);
            }
        };
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.batchChecker(), task, interval, interval, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public void recoverBatchSessions() {
        int recoveryNumThreads = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_RECOVERY_THREADS()));
        ThreadPoolExecutor batchRecoveryExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(recoveryNumThreads, "batch-recovery-executor");
        try {
            Seq<KyuubiBatchSession> batchSessionsToRecover = this.sessionManager().getBatchSessionsToRecover(this.connectionUrl());
            AtomicInteger pendingRecoveryTasksCount = new AtomicInteger(0);
            Seq tasks = (Seq)batchSessionsToRecover.flatMap((Function1 & Serializable & scala.Serializable)batchSession -> {
                Iterable iterable;
                String batchId = batchSession.batchJobSubmissionOp().batchId();
                try {
                    Future<Object> task = batchRecoveryExecutor.submit(() -> {
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sessionManager().openBatchSession(batchSession));
                        return BoxedUnit.UNIT;
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(task), (Object)batchId)));
                }
                catch (Throwable e) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error while submitting batch[").append(batchId).append("] for recovery").toString(), e);
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom());
            pendingRecoveryTasksCount.addAndGet(tasks.size());
            tasks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KyuubiRestFrontendService.$anonfun$recoverBatchSessions$5(this, pendingRecoveryTasksCount, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)batchRecoveryExecutor, ThreadUtils$.MODULE$.shutdown$default$2());
        }
    }

    public void waitForServerStarted() {
        while (!this.server().isStarted()) {
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Waiting for ").append(this.getName()).append("'s HTTP server getting started").toString());
            Thread.sleep(1000L);
        }
    }

    public synchronized void start() {
        if (!this.isStarted().get()) {
            try {
                this.server().start();
                this.startInternal();
                this.waitForServerStarted();
                this.isStarted().set(true);
                this.startBatchChecker();
                this.recoverBatchSessions();
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(13).append("Cannot start ").append(this.getName()).toString(), (Throwable)e);
            }
        }
        super.start();
        this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Exposing REST endpoint at: http://").append(this.server().getServerUri()).toString());
    }

    public synchronized void stop() {
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.batchChecker(), ThreadUtils$.MODULE$.shutdown$default$2());
        if (this.isStarted().getAndSet(false)) {
            this.server().stop();
        }
        super.stop();
    }

    public String getRealUser() {
        return ServiceUtils$.MODULE$.getShortName((String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserName()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getRealUser$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous"));
    }

    public String getSessionUser(String proxyUser2) {
        Map sessionConf = (Map)Option$.MODULE$.apply((Object)proxyUser2).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getSessionUser$1(x$3))).map((Function1 & Serializable & scala.Serializable)proxyUser -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiConf$.MODULE$.PROXY_USER().key()), proxyUser)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return this.getSessionUser((Map<String, String>)sessionConf);
    }

    public String getSessionUser(Map<String, String> sessionConf) {
        String string;
        String ipAddress = AuthenticationFilter$.MODULE$.getUserIpAddress();
        String realUser = this.getRealUser();
        try {
            string = this.getProxyUser(sessionConf, ipAddress, realUser);
        }
        catch (Throwable t) {
            throw new WebApplicationException(t.getMessage(), Response.Status.FORBIDDEN);
        }
        return string;
    }

    public String getIpAddress() {
        return (String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress()).getOrElse((Function0 & Serializable & scala.Serializable)() -> AuthenticationFilter$.MODULE$.getUserIpAddress());
    }

    private String getProxyUser(Map<String, String> sessionConf, String ipAddress, String realUser) {
        String proxyUser;
        block1: {
            if (sessionConf == null) {
                return realUser;
            }
            proxyUser = (String)sessionConf.getOrElse((Object)KyuubiConf$.MODULE$.PROXY_USER().key(), (Function0 & Serializable & scala.Serializable)() -> (String)sessionConf.getOrElse((Object)AuthUtils$.MODULE$.HS2_PROXY_USER(), (Function0 & Serializable & scala.Serializable)() -> realUser));
            if (proxyUser.equals(realUser) || this.isAdministrator(realUser)) break block1;
            AuthUtils$.MODULE$.verifyProxyAccess(realUser, proxyUser, ipAddress, this.hadoopConf());
        }
        return proxyUser;
    }

    public Option<Service> discoveryService() {
        return this.discoveryService;
    }

    public static final /* synthetic */ void $anonfun$recoverBatchSessions$5(KyuubiRestFrontendService $this, AtomicInteger pendingRecoveryTasksCount$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Future task = (Future)tuple2._1();
            String batchId = (String)tuple2._2();
            try {
                BoxedUnit boxedUnit;
                try {
                    boxedUnit = (BoxedUnit)task.get();
                }
                catch (Throwable e) {
                    $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Error while recovering batch[").append(batchId).append("]").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                int pendingTasks = pendingRecoveryTasksCount$1.decrementAndGet();
                $this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Batch[").append(batchId).append("] recovery task terminated, current pending tasks ").append(pendingTasks).toString());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getRealUser$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getSessionUser$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public KyuubiRestFrontendService(Serverable serverable) {
        this.serverable = serverable;
        super("KyuubiRestFrontendService");
        this.isStarted = new AtomicBoolean(false);
        this.batchChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("batch-checker", ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
        this.discoveryService = None$.MODULE$;
    }
}

