/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ToolUtil;
import org.apache.kylin.query.UdfManager$;
import org.apache.kylin.query.monitor.SparderContextCanary;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.StandaloneAppClient$;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.MonitorEnv$;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.KylinSession$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderContext$;
import org.apache.spark.sql.SparderContextFacade$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasource.KylinSourceStrategy$;
import org.apache.spark.sql.execution.datasource.ShardFileStatusCache$;
import org.apache.spark.sql.metrics.SparderMetricsListener;
import org.apache.spark.util.Utils$;
import org.apache.spark.utils.YarnInfoFetcherUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class SparderContext$
implements Logging {
    public static SparderContext$ MODULE$;
    private volatile SparkSession org$apache$spark$sql$SparderContext$$spark;
    private volatile Thread org$apache$spark$sql$SparderContext$$initializingThread;
    private volatile String master_app_url;
    private final ThreadLocal<Boolean> _isAsyncQuery;
    private final ThreadLocal<String> _separator;
    private final ThreadLocal<Dataset<Row>> _df;
    private final ThreadLocal<Boolean> _needCompute;
    private final ThreadLocal<Long> _numScanFiles;
    private final ThreadLocal<AtomicReference<Boolean>> _queryRef;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparderContext$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession org$apache$spark$sql$SparderContext$$spark() {
        return this.org$apache$spark$sql$SparderContext$$spark;
    }

    public void org$apache$spark$sql$SparderContext$$spark_$eq(SparkSession x$1) {
        this.org$apache$spark$sql$SparderContext$$spark = x$1;
    }

    private Thread org$apache$spark$sql$SparderContext$$initializingThread() {
        return this.org$apache$spark$sql$SparderContext$$initializingThread;
    }

    public void org$apache$spark$sql$SparderContext$$initializingThread_$eq(Thread x$1) {
        this.org$apache$spark$sql$SparderContext$$initializingThread = x$1;
    }

    public String master_app_url() {
        return this.master_app_url;
    }

    public void master_app_url_$eq(String x$1) {
        this.master_app_url = x$1;
    }

    public SparkSession getOriginalSparkSession() {
        block0: {
            if (this.org$apache$spark$sql$SparderContext$$spark() != null && !this.org$apache$spark$sql$SparderContext$$spark().sparkContext().isStopped()) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Init spark.");
            this.initSpark();
        }
        return this.org$apache$spark$sql$SparderContext$$spark();
    }

    public SparkSession getSparkSession() {
        return SparderContextFacade$.MODULE$.current().getFirst();
    }

    public void closeThreadSparkSession() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Remove SparkSession from thread ").append(Thread.currentThread().getId()).toString());
        SparderContextFacade$.MODULE$.remove();
    }

    public void setSparkSession(SparkSession sparkSession) {
        this.org$apache$spark$sql$SparderContext$$spark_$eq(sparkSession);
        UdfManager$.MODULE$.create(sparkSession);
    }

    public void setAPPMasterTrackURL(String url) {
        this.master_app_url_$eq(url);
    }

    public String appMasterTrackURL() {
        return this.master_app_url() != null ? this.master_app_url() : "";
    }

    public boolean isSparkAvailable() {
        return this.org$apache$spark$sql$SparderContext$$spark() != null && !this.org$apache$spark$sql$SparderContext$$spark().sparkContext().isStopped();
    }

    public synchronized void restartSpark() {
        Object object = this.org$apache$spark$sql$SparderContext$$spark() != null && !this.org$apache$spark$sql$SparderContext$$spark().sparkContext().isStopped() ? Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.org$apache$spark$sql$SparderContext$$spark().stop(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SparkContext$.MODULE$.clearActiveContext()) : BoxedUnit.UNIT;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Restart Spark");
        this.init();
    }

    public synchronized void stopSpark() {
        block0: {
            if (this.org$apache$spark$sql$SparderContext$$spark() == null || this.org$apache$spark$sql$SparderContext$$spark().sparkContext().isStopped()) break block0;
            Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.org$apache$spark$sql$SparderContext$$spark().stop(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SparkContext$.MODULE$.clearActiveContext());
        }
    }

    public void init() {
        this.getOriginalSparkSession();
    }

    public String getSparkConf(String key) {
        return this.getSparkSession().sparkContext().conf().get(key);
    }

    public void initSpark() {
        SparderContext$ sparderContext$ = this;
        synchronized (sparderContext$) {
            if (this.org$apache$spark$sql$SparderContext$$initializingThread() == null && (this.org$apache$spark$sql$SparderContext$$spark() == null || this.org$apache$spark$sql$SparderContext$$spark().sparkContext().isStopped())) {
                this.org$apache$spark$sql$SparderContext$$initializingThread_$eq(new Thread(new Runnable(){

                    public void run() {
                        try {
                            try {
                                String string;
                                String string2;
                                KylinConfig kylinConf = KylinConfig.getInstanceFromEnv();
                                String string3 = System.getProperty("spark.local");
                                String string4 = "true".equals(string3) ? "local" : kylinConf.getSparderConfigOverrideWithSpecificName("spark.master");
                                String master = string4;
                                SparderContext$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("SparderContext deploy with spark master: ").append(master).toString());
                                SparkSession sparkSession = KylinSession$.MODULE$.KylinBuilder(SparkSession$.MODULE$.builder().master(master).config("spark.submit.deployMode", "client").appName(kylinConf.getSparderAppName()).withExtensions((Function1 & Serializable & scala.Serializable)ext -> {
                                    anon.1.$anonfun$run$2(ext);
                                    return BoxedUnit.UNIT;
                                }).enableHiveSupport()).getOrCreateKylinSession();
                                if (kylinConf.isKylinMetricsReporterForQueryEnabled()) {
                                    SparderMetricsListener appStatusListener = new SparderMetricsListener();
                                    sparkSession.sparkContext().addSparkListener((SparkListenerInterface)appStatusListener);
                                    SparderContext$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Query metrics reporter is enabled, sparder metrics listener is added.");
                                }
                                SparderContext$.MODULE$.org$apache$spark$sql$SparderContext$$spark_$eq(sparkSession);
                                String appid = sparkSession.sparkContext().applicationId();
                                String kylinHomePath = KylinConfig.getKylinHomeAtBestEffort().getCanonicalPath();
                                try {
                                    File appidFile = Paths.get(kylinHomePath, "sparkappid").toFile();
                                    FileUtils.writeStringToFile(appidFile, appid);
                                    SparderContext$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Spark application id is ").append(appid).toString());
                                }
                                catch (Exception e) {
                                    SparderContext$.MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Failed to generate spark application id[").append(appid).append("] file").toString(), e);
                                }
                                SparderContext$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Spark context started successfully with stack trace:");
                                SparderContext$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace())).mkString("\n"));
                                SparderContext$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Class loader: ").append(Thread.currentThread().getContextClassLoader().toString()).toString());
                                SparderContext$.MODULE$.initMonitorEnv();
                                String string5 = master;
                                if (string5 != null && (string2 = string5).startsWith("local")) {
                                    String hostName = ToolUtil.getHostName();
                                    if (hostName.equals("Unknown")) {
                                        hostName = "localhost";
                                    }
                                    SparderContext$.MODULE$.master_app_url_$eq(new StringBuilder(8).append("http://").append(hostName).append(":").append(sparkSession.sparkContext().getConf().get("spark.ui.port", "4040")).toString());
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else if (string5 != null && (string = string5).startsWith("spark")) {
                                    String hostName = StandaloneAppClient$.MODULE$.getMasterHost(kylinConf.getSparderConfigOverrideWithSpecificName("spark.master"));
                                    SparderContext$.MODULE$.master_app_url_$eq(new StringBuilder(8).append("http://").append(hostName).append(":").append(sparkSession.sparkContext().getConf().get("spark.ui.port", "4040")).toString());
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    SparderContext$.MODULE$.master_app_url_$eq(YarnInfoFetcherUtils.getTrackingUrl(appid));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                kylinConf.getHdfsWorkingDirectoryInternal(SparderContext$.MODULE$.org$apache$spark$sql$SparderContext$$spark().sparkContext().hadoopConfiguration());
                            }
                            catch (Throwable throwable) {
                                SparderContext$.MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error for initializing spark ", throwable);
                            }
                        }
                        finally {
                            SparderContext$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Setting initializing Spark thread to null.");
                            SparderContext$.MODULE$.org$apache$spark$sql$SparderContext$$initializingThread_$eq(null);
                        }
                    }

                    public static final /* synthetic */ void $anonfun$run$2(SparkSessionExtensions ext) {
                        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$1 -> KylinSourceStrategy$.MODULE$);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(java.lang.String ), $anonfun$run$2$adapted(org.apache.spark.sql.SparkSessionExtensions ), $anonfun$run$4(), $anonfun$run$5(java.lang.String ), $anonfun$run$6(java.lang.String ), $anonfun$run$7(), $anonfun$run$8(), $anonfun$run$9(), $anonfun$run$10(), $anonfun$run$11(), $anonfun$run$3(org.apache.spark.sql.SparkSession )}, serializedLambda);
                    }
                }));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Initializing Spark thread starting.");
                this.org$apache$spark$sql$SparderContext$$initializingThread().start();
            }
            if (this.org$apache$spark$sql$SparderContext$$initializingThread() != null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Initializing Spark, waiting for done.");
                this.org$apache$spark$sql$SparderContext$$initializingThread().join();
            }
            String string = System.getProperty("spark.local");
            String string2 = "true";
            if ((string == null ? string2 != null : !string.equals(string2)) && KylinConfig.getInstanceFromEnv().isSparderCanaryEnabled()) {
                SparderContextCanary.init();
            }
            ShardFileStatusCache$.MODULE$.getFileStatusCache(this.getOriginalSparkSession());
        }
    }

    public void registerListener(SparkContext sc) {
        SparkListener sparkListener = new SparkListener(){

            public void onOtherEvent(SparkListenerEvent event) {
                SparkListenerEvent sparkListenerEvent = event;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        };
        sc.addSparkListener((SparkListenerInterface)sparkListener);
    }

    public void initMonitorEnv() {
        SparkEnv env = SparkEnv$.MODULE$.get();
        RpcEnv rpcEnv = env.rpcEnv();
        SparkConf sparkConf = new SparkConf();
        MonitorEnv$.MODULE$.create(sparkConf, env.executorId(), rpcEnv, null, true);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("setup master endpoint finished.hostPort:").append(rpcEnv.address().hostPort()).toString());
    }

    /*
     * WARNING - void declaration
     */
    public LogicalPlan validateSql(String sqlText) throws ParseException {
        void var2_2;
        LogicalPlan logicalPlan = this.getSparkSession().sessionState().sqlParser().parsePlan(sqlText);
        return var2_2;
    }

    public ThreadLocal<Boolean> _isAsyncQuery() {
        return this._isAsyncQuery;
    }

    public ThreadLocal<String> _separator() {
        return this._separator;
    }

    public ThreadLocal<Dataset<Row>> _df() {
        return this._df;
    }

    public ThreadLocal<Boolean> _needCompute() {
        return this._needCompute;
    }

    public ThreadLocal<Long> _numScanFiles() {
        return this._numScanFiles;
    }

    public ThreadLocal<AtomicReference<Boolean>> _queryRef() {
        return this._queryRef;
    }

    public void accumulateScanFiles(Long numFiles) {
        this._numScanFiles().set(Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(this._numScanFiles().get()) + Predef$.MODULE$.Long2long(numFiles)));
    }

    public Long getNumScanFiles() {
        return this._numScanFiles().get();
    }

    public void setAsAsyncQuery() {
        this._isAsyncQuery().set(Predef$.MODULE$.boolean2Boolean(true));
    }

    public Boolean isAsyncQuery() {
        return this._isAsyncQuery().get() == null ? Predef$.MODULE$.boolean2Boolean(false) : this._isAsyncQuery().get();
    }

    public void setSeparator(String separator) {
        this._separator().set(separator);
    }

    public String getSeparator() {
        return this._separator().get() == null ? "," : this._separator().get();
    }

    public Dataset<Row> getDF() {
        return this._df().get();
    }

    public void setDF(Dataset<Row> df) {
        this._df().set(df);
    }

    public void setResultRef(AtomicReference<Boolean> ref) {
        this._queryRef().set(ref);
    }

    public AtomicReference<Boolean> getResultRef() {
        return this._queryRef().get();
    }

    public void clean() {
        this._isAsyncQuery().set(null);
        this._separator().set(null);
        this._df().set(null);
        this._needCompute().set(null);
    }

    public void cleanQueryInfo() {
        this._numScanFiles().set(Predef$.MODULE$.long2Long(0L));
    }

    public Boolean needCompute() {
        return Predef$.MODULE$.boolean2Boolean(!Predef$.MODULE$.Boolean2boolean(this._needCompute().get()));
    }

    public void skipCompute() {
        this._needCompute().set(Predef$.MODULE$.boolean2Boolean(true));
    }

    public void cleanCompute() {
        this._needCompute().set(Predef$.MODULE$.boolean2Boolean(false));
    }

    private SparderContext$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.org$apache$spark$sql$SparderContext$$initializingThread = null;
        this._isAsyncQuery = new ThreadLocal();
        this._separator = new ThreadLocal();
        this._df = new ThreadLocal();
        this._needCompute = new ThreadLocal<Boolean>(){

            public Boolean initialValue() {
                return Predef$.MODULE$.boolean2Boolean(false);
            }
        };
        this._numScanFiles = new ThreadLocal<Long>(){

            public Long initialValue() {
                return Predef$.MODULE$.long2Long(0L);
            }
        };
        this._queryRef = new ThreadLocal();
    }
}

