/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.extractor;

import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.tool.extractor.AbstractInfoExtractor;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkEnvInfoExtractor
extends AbstractInfoExtractor {
    private static final Logger logger = LoggerFactory.getLogger(SparkEnvInfoExtractor.class);

    public SparkEnvInfoExtractor() {
        this.packageType = "spark";
    }

    private File getSparkConfDir() {
        String sparkHome = KylinConfig.getSparkHome();
        File sparkHomeDir = new File(sparkHome);
        Preconditions.checkArgument((boolean)sparkHomeDir.exists(), (Object)"Your SPARK_HOME does not exist.");
        return new File(sparkHomeDir, "conf");
    }

    private File getHadoopConfDir() {
        String hadoopConf = System.getenv("HADOOP_CONF_DIR");
        Preconditions.checkNotNull((Object)hadoopConf, (Object)"Cannot find HADOOP_CONF_DIR in the environment.");
        File hadoopConfDir = new File(hadoopConf);
        Preconditions.checkArgument((boolean)hadoopConfDir.exists(), (Object)("Your HADOOP_CONF_DIR does not exist: " + hadoopConf));
        return hadoopConfDir;
    }

    private void extractConfDir(File from, File to) {
        File[] confFiles = from.listFiles();
        if (confFiles != null) {
            for (File confFile : confFiles) {
                if (confFile.getName().endsWith(".template")) continue;
                this.addFile(confFile, to);
            }
        }
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        StringBuilder envStrBuilder = new StringBuilder();
        try {
            File sparkHome = this.getSparkConfDir();
            this.extractConfDir(sparkHome, new File(exportDir, "spark-conf"));
            envStrBuilder.append("SPARK_HOME=").append(sparkHome.getAbsolutePath()).append("\n");
        }
        catch (Exception e) {
            logger.error("Failed to extract spark conf: error={}", (Object)e.getMessage());
        }
        try {
            File hadoopConf = this.getHadoopConfDir();
            this.extractConfDir(hadoopConf, new File(exportDir, "hadoop-conf"));
            envStrBuilder.append("HADOOP_CONF_DIR=").append(hadoopConf.getAbsolutePath()).append("\n");
        }
        catch (Exception e) {
            logger.error("Failed to extract hadoop conf: error={}", (Object)e.getMessage());
        }
        FileUtils.write(new File(exportDir, "env"), envStrBuilder.toString());
    }
}

