/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.ServiceDiscoveryStateService;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/service_discovery/state"})
public class ServiceDiscoveryStateController
extends BasicController {
    @Autowired
    @Qualifier(value="serviceDiscoveryStateService")
    ServiceDiscoveryStateService serviceDiscoveryStateService;

    @RequestMapping(value={"/is_active_job_node"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public boolean isActiveJobNode() {
        this.checkCuratorSchedulerEnabled();
        return this.serviceDiscoveryStateService.isActiveJobNode();
    }

    @RequestMapping(value={"/all"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse<ServiceDiscoveryState> getAllNodeStates() throws IOException {
        this.checkCuratorSchedulerEnabled();
        HashSet<String> allNodes = new HashSet<String>();
        HashSet<String> queryNodes = new HashSet<String>();
        HashSet<String> jobNodes = new HashSet();
        Set<String> leaders = new HashSet<String>();
        for (String serverWithMode : KylinConfig.getInstanceFromEnv().getRestServersWithMode()) {
            String[] split = serverWithMode.split(":");
            Preconditions.checkArgument(split.length == 3, "String should be \"host:server:mode\", actual:" + serverWithMode);
            String server = split[0] + ":" + split[1];
            String mode = split[2];
            allNodes.add(server);
            if (mode.equals("query") || mode.equals("all")) {
                queryNodes.add(server);
            }
            if (!mode.equals("job") && !mode.equals("all")) continue;
            jobNodes.add(server);
        }
        Set<Participant> allParticipants = this.serviceDiscoveryStateService.getAllParticipants();
        if (!allParticipants.isEmpty()) {
            jobNodes = allParticipants.stream().map(Participant::getId).collect(Collectors.toSet());
            leaders = allParticipants.stream().filter(Participant::isLeader).map(Participant::getId).collect(Collectors.toSet());
        }
        Set<String> activeJobNodes = this.getActiveJobNodes(allNodes);
        return new EnvelopeResponse<ServiceDiscoveryState>("000", new ServiceDiscoveryState(allNodes, jobNodes, queryNodes, leaders, activeJobNodes), "get service discovery's state");
    }

    private void checkCuratorSchedulerEnabled() {
        if (KylinConfig.getInstanceFromEnv().getSchedulerType() != 100) {
            throw new UnsupportedOperationException("Only meaningful when scheduler is CuratorScheduler, try set kylin.job.scheduler.default to 100 to enable CuratorScheduler.");
        }
    }

    private Set<String> getActiveJobNodes(Collection<String> allNodes) throws IOException {
        Map<String, String> jobServerState = this.serviceDiscoveryStateService.getJobServerState(allNodes);
        Set<String> activeJobNodes = jobServerState.entrySet().stream().filter(e -> ((String)e.getValue()).equals("true")).map(Map.Entry::getKey).collect(Collectors.toSet());
        return activeJobNodes;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    static class ServiceDiscoveryState
    implements Serializable {
        @JsonProperty
        Set<String> allNodes;
        @JsonProperty
        Set<String> jobNodes;
        @JsonProperty
        Set<String> queryNodes;
        @JsonProperty
        Set<String> selectedLeaders;
        @JsonProperty
        Set<String> activeJobNodes;

        ServiceDiscoveryState(Set<String> allNodes, Set<String> participants, Set<String> queryNodes, Set<String> leaders, Set<String> activeJobNodes) {
            this.allNodes = allNodes;
            this.jobNodes = participants;
            this.queryNodes = queryNodes;
            this.selectedLeaders = leaders;
            this.activeJobNodes = activeJobNodes;
        }
    }
}

