/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import org.apache.kylin.common.QueryTrace;
import org.apache.kylin.query.util.SparkJobTrace;
import org.apache.kylin.query.util.SparkJobTraceV2$;
import org.apache.spark.SparkContext;
import org.apache.spark.status.api.v1.JobData;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001\u0002\u000e\u001c\u0001\u0019B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\ts\u0001\u0011\t\u0011)A\u0005u!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0006\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u000be\u0003A\u0011\u0001.\t\u000f\t\u0004!\u0019!C\u0001G\"1\u0011\u000e\u0001Q\u0001\n\u0011DqA\u001b\u0001C\u0002\u0013\u00051\r\u0003\u0004l\u0001\u0001\u0006I\u0001\u001a\u0005\bY\u0002\u0011\r\u0011\"\u0001d\u0011\u0019i\u0007\u0001)A\u0005I\"9a\u000e\u0001b\u0001\n\u0003\u0019\u0007BB8\u0001A\u0003%A\rC\u0004q\u0001\t\u0007I\u0011A2\t\rE\u0004\u0001\u0015!\u0003e\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u0015\u0011\b\u0001\"\u0001w\u0011\u0015i\b\u0001\"\u0011\u007f\u000f%\t)aGA\u0001\u0012\u0003\t9A\u0002\u0005\u001b7\u0005\u0005\t\u0012AA\u0005\u0011\u0019If\u0003\"\u0001\u0002\u0012!I\u00111\u0003\f\u0012\u0002\u0013\u0005\u0011Q\u0003\u0005\n\u0003W1\u0012\u0013!C\u0001\u0003[\u0011qb\u00159be.TuN\u0019+sC\u000e,gK\r\u0006\u00039u\tA!\u001e;jY*\u0011adH\u0001\u0006cV,'/\u001f\u0006\u0003A\u0005\nQa[=mS:T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u00011C\u0001\u0001(!\tA\u0013&D\u0001\u001c\u0013\tQ3DA\u0007Ta\u0006\u00148NS8c)J\f7-Z\u0001\tU>\u0014wI]8vaB\u0011QF\u000e\b\u0003]Q\u0002\"a\f\u001a\u000e\u0003AR!!M\u0013\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u0012\u0014AC9vKJLHK]1dKB\u00111HP\u0007\u0002y)\u0011QhH\u0001\u0007G>lWn\u001c8\n\u0005}b$AC)vKJLHK]1dK\u0006a1\u000f]1sW\u000e{g\u000e^3yiB\u0011!)R\u0007\u0002\u0007*\u0011A)I\u0001\u0006gB\f'o[\u0005\u0003\r\u000e\u0013Ab\u00159be.\u001cuN\u001c;fqR\faA_8oK&#\u0007CA%O\u001b\u0005Q%BA&M\u0003\u0011!\u0018.\\3\u000b\u00035\u000bAA[1wC&\u0011qJ\u0013\u0002\u00075>tW-\u00133\u0002\u001b\u0011,G/Y5m\u000b:\f'\r\\3e!\t\u00116+D\u00013\u0013\t!&GA\u0004C_>dW-\u00198\u0002\u000fM$\u0018M\u001d;BiB\u0011!kV\u0005\u00031J\u0012A\u0001T8oO\u00061A(\u001b8jiz\"ra\u0017/^=~\u0003\u0017\r\u0005\u0002)\u0001!)1f\u0002a\u0001Y!)\u0011h\u0002a\u0001u!)\u0001i\u0002a\u0001\u0003\")qi\u0002a\u0001\u0011\"9\u0001k\u0002I\u0001\u0002\u0004\t\u0006bB+\b!\u0003\u0005\rAV\u0001\b!\u0006#F+\u0012*O+\u0005!\u0007CA3i\u001b\u00051'BA4M\u0003\u0011a\u0017M\\4\n\u0005]2\u0017\u0001\u0003)B)R+%K\u0014\u0011\u0002\u0013\tLH/Z:SK\u0006$\u0017A\u00032zi\u0016\u001c(+Z1eA\u0005I1\u000f^1hK&sgm\\\u0001\u000bgR\fw-Z%oM>\u0004\u0013a\u0003:v]:Lgn\u001a+j[\u0016\fAB];o]&tw\rV5nK\u0002\n!\u0002\\1v]\u000eDG+[7f\u0003-a\u0017-\u001e8dQRKW.\u001a\u0011\u0002\u000f\u0011\fG/Z*ueR\u0011A\u0006\u001e\u0005\u0006kJ\u0001\rAV\u0001\u0003iN$\"\u0001L<\t\u000bU\u001c\u0002\u0019\u0001=\u0011\u0005e\\X\"\u0001>\u000b\u0005qa\u0015B\u0001?{\u0005\u0011!\u0015\r^3\u0002\u0017)|'MR5oSNDW\r\u001a\u000b\u0002\u007fB\u0019!+!\u0001\n\u0007\u0005\r!G\u0001\u0003V]&$\u0018aD*qCJ\\'j\u001c2Ue\u0006\u001cWM\u0016\u001a\u0011\u0005!22c\u0001\f\u0002\fA\u0019!+!\u0004\n\u0007\u0005=!G\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u000f\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAA\fU\r\t\u0016\u0011D\u0016\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0005\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0005}!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"!a\f+\u0007Y\u000bI\u0002")
public class SparkJobTraceV2
extends SparkJobTrace {
    private final String jobGroup;
    private final QueryTrace queryTrace;
    private final ZoneId zoneId;
    private final long startAt;
    private final String PATTERN;
    private final String bytesRead;
    private final String stageInfo;
    private final String runningTime;
    private final String launchTime;

    public static long $lessinit$greater$default$6() {
        return SparkJobTraceV2$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$5() {
        return SparkJobTraceV2$.MODULE$.$lessinit$greater$default$5();
    }

    public String PATTERN() {
        return this.PATTERN;
    }

    public String bytesRead() {
        return this.bytesRead;
    }

    public String stageInfo() {
        return this.stageInfo;
    }

    public String runningTime() {
        return this.runningTime;
    }

    public String launchTime() {
        return this.launchTime;
    }

    public String dateStr(long ts) {
        return new Date(ts).toInstant().atZone(this.zoneId).toLocalDateTime().format(DateTimeFormatter.ofPattern(this.PATTERN(), Locale.ROOT));
    }

    public String dateStr(Date ts) {
        return ts.toInstant().atZone(this.zoneId).toLocalDateTime().format(DateTimeFormatter.ofPattern(this.PATTERN(), Locale.ROOT));
    }

    @Override
    public void jobFinished() {
        block6: {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Query job finished.");
            long finishedAt = System.currentTimeMillis();
            try {
                Seq<JobData> jobDataSeq = this.appStatus().getJobData(this.jobGroup);
                Option firstSubmissionTime = (Option)((TraversableOnce)jobDataSeq.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.submissionTime(), Seq$.MODULE$.canBuildFrom())).min(Ordering$.MODULE$.Option(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
                Option lastCompletionTime = (Option)((TraversableOnce)jobDataSeq.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.completionTime(), Seq$.MODULE$.canBuildFrom())).max(Ordering$.MODULE$.Option(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
                LongRef firstLaunchTime = LongRef.create((long)-1L);
                if (jobDataSeq.isEmpty()) {
                    this.endAbnormalExecutionTrace();
                    return;
                }
                jobDataSeq.foreach((Function1 & Serializable & scala.Serializable)job -> {
                    SparkJobTraceV2.$anonfun$jobFinished$4(this, firstLaunchTime, job);
                    return BoxedUnit.UNIT;
                });
                LongRef jobExecutionTimeByKylin = LongRef.create((long)(finishedAt - this.startAt));
                if (firstSubmissionTime.isDefined()) {
                    this.queryTrace.amendLast("PREPARE_AND_SUBMIT_JOB", ((Date)firstSubmissionTime.get()).getTime());
                } else {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No firstSubmissionTime");
                }
                if (firstSubmissionTime.isDefined() && lastCompletionTime.isDefined()) {
                    long jobExecutionTimeBySpark = ((Date)lastCompletionTime.get()).getTime() - ((Date)firstSubmissionTime.get()).getTime();
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("jobExecutionTime will change from ").append(jobExecutionTimeByKylin$1.elem).append(" to ").append(jobExecutionTimeBySpark).append(" .").toString());
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append("Kylin submit query at ").append(this.dateStr($this.startAt)).append(", first spark job submitted at ").append(this.dateStr(((Date)firstSubmissionTime.get()).getTime())).append(", last spark job finished at ").append(this.dateStr(((Date)lastCompletionTime.get()).getTime())).append(", query finished at ").append(this.dateStr(finishedAt)).append(" .").toString());
                    jobExecutionTimeByKylin.elem = jobExecutionTimeBySpark;
                    this.queryTrace.appendSpan("WAIT_FOR_EXECUTION", firstLaunchTime.elem - ((Date)firstSubmissionTime.get()).getTime());
                    this.queryTrace.appendSpan("EXECUTION", ((Date)lastCompletionTime.get()).getTime() - firstLaunchTime.elem);
                    this.queryTrace.appendSpan("FETCH_RESULT", finishedAt - ((Date)lastCompletionTime.get()).getTime());
                    this.queryTrace.appendSpan("CALCULATE_STAT", System.currentTimeMillis() - finishedAt);
                    break block6;
                }
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No firstSubmissionTime or lastCompletionTime");
            }
            catch (Throwable e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Failed trace spark job execution for ").append($this.jobGroup).toString(), e);
                this.endAbnormalExecutionTrace();
            }
        }
    }

    public static final /* synthetic */ Seq $anonfun$jobFinished$7(SparkJobTraceV2 $this, int stageId) {
        return $this.appStatus().calStageMetrics(stageId, $this.appStatus().calStageMetrics$default$2());
    }

    public static final /* synthetic */ void $anonfun$jobFinished$4(SparkJobTraceV2 $this, LongRef firstLaunchTime$1, JobData job) {
        String submissionTime = $this.dateStr((Date)job.submissionTime().getOrElse((Function0 & Serializable & scala.Serializable)() -> new Date(0L)));
        String completionTime = $this.dateStr((Date)job.completionTime().getOrElse((Function0 & Serializable & scala.Serializable)() -> new Date(0L)));
        String killedDesc = job.killedTasksSummary().isEmpty() ? "EMPTY" : job.killedTasksSummary().mkString("|");
        String stageMetrics = ((TraversableOnce)((TraversableLike)job.stageIds().flatMap((Function1 & Serializable & scala.Serializable)stageId -> SparkJobTraceV2.$anonfun$jobFinished$7($this, BoxesRunTime.unboxToInt((Object)stageId)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)stage -> {
            String string;
            if (((TraversableOnce)stage.apply((Object)$this.bytesRead())).nonEmpty() && ((TraversableOnce)stage.apply((Object)$this.runningTime())).nonEmpty()) {
                if (firstLaunchTime$1.elem == -1L || BoxesRunTime.unboxToLong((Object)((SeqLike)stage.apply((Object)$this.launchTime())).apply(0)) < firstLaunchTime$1.elem) {
                    firstLaunchTime$1.elem = BoxesRunTime.unboxToLong((Object)((SeqLike)stage.apply((Object)$this.launchTime())).apply(0));
                }
                string = new StringOps(Predef$.MODULE$.augmentString("Stage:%d,%d, launch time of first and last task are %s and %s,  bytesRead is [%s], runningTime is [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((SeqLike)stage.apply((Object)$this.stageInfo())).apply(0), ((SeqLike)stage.apply((Object)$this.stageInfo())).apply(1), $this.dateStr(BoxesRunTime.unboxToLong((Object)((SeqLike)stage.apply((Object)$this.launchTime())).apply(0))), $this.dateStr(BoxesRunTime.unboxToLong((Object)((SeqLike)stage.apply((Object)$this.launchTime())).apply(1))), ((TraversableOnce)stage.apply((Object)$this.bytesRead())).mkString(","), ((TraversableOnce)stage.apply((Object)$this.runningTime())).mkString(", ")}));
            } else {
                string = new StringOps(Predef$.MODULE$.augmentString("Stage:%d,%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((SeqLike)stage.apply((Object)$this.stageInfo())).apply(0), ((SeqLike)stage.apply((Object)$this.stageInfo())).apply(1)}));
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(";");
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(129).append("Job ").append(job.jobId()).append(" is submitted at ").append(submissionTime).append(" and completed at ").append(completionTime).append(".It has ").append(job.numTasks()).append(" tasks, ").append("succeed ").append(job.numCompletedTasks()).append(" tasks, ").append(job.numFailedTasks()).append(" failed tasks,").append(job.numKilledTasks()).append(" killed tasks. ").append("Killed tasks info: ").append(killedDesc).append(". Stages ").append(stageMetrics).append(".").toString());
    }

    public SparkJobTraceV2(String jobGroup, QueryTrace queryTrace, SparkContext sparkContext, ZoneId zoneId, boolean detailEnabled, long startAt) {
        this.jobGroup = jobGroup;
        this.queryTrace = queryTrace;
        this.zoneId = zoneId;
        this.startAt = startAt;
        super(jobGroup, queryTrace, sparkContext, startAt);
        this.PATTERN = "HH:mm:ss.SSS";
        this.bytesRead = "bytesRead";
        this.stageInfo = "stageInfo";
        this.runningTime = "runningTime";
        this.launchTime = "launchTime";
    }
}

