/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.property;

import org.apache.kylin.shaded.com.google.common.base.Strings;

public enum JobPropertyEnum {
    ID_CODE("JOB_ID"),
    USER("KUSER"),
    PROJECT("PROJECT"),
    CUBE("CUBE_NAME"),
    TYPE("JOB_TYPE"),
    ALGORITHM("CUBING_TYPE"),
    STATUS("JOB_STATUS"),
    EXCEPTION("EXCEPTION"),
    EXCEPTION_MSG("EXCEPTION_MSG"),
    SOURCE_SIZE("TABLE_SIZE"),
    CUBE_SIZE("CUBE_SIZE"),
    BUILD_DURATION("DURATION"),
    WAIT_RESOURCE_TIME("WAIT_RESOURCE_TIME"),
    PER_BYTES_TIME_COST("PER_BYTES_TIME_COST"),
    STEP_DURATION_DISTINCT_COLUMNS("STEP_DURATION_DISTINCT_COLUMNS"),
    STEP_DURATION_DICTIONARY("STEP_DURATION_DICTIONARY"),
    STEP_DURATION_INMEM_CUBING("STEP_DURATION_INMEM_CUBING"),
    STEP_DURATION_HFILE_CONVERT("STEP_DURATION_HFILE_CONVERT");

    private final String propertyName;

    private JobPropertyEnum(String name) {
        this.propertyName = name;
    }

    public static JobPropertyEnum getByName(String name) {
        if (Strings.isNullOrEmpty(name)) {
            return null;
        }
        for (JobPropertyEnum property : JobPropertyEnum.values()) {
            if (!property.propertyName.equalsIgnoreCase(name)) continue;
            return property;
        }
        return null;
    }

    public String toString() {
        return this.propertyName;
    }
}

