/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.builder.CreateFlatTable$;
import org.apache.kylin.engine.spark.job.TableAnalyzerJob;
import org.apache.kylin.engine.spark.utils.SchemaProcessor$;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.utils.SparkTypeUtil$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0007\u000f\u0001mA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!a\u0005A!A!\u0002\u00131\u0004\"B'\u0001\t\u0003q\u0005b\u0002,\u0001\u0005\u0004%\ta\u0016\u0005\u00077\u0002\u0001\u000b\u0011\u0002-\t\u000bq\u0003A\u0011A/\t\u000b\u0011\u0004A\u0011A3\t\u000b-\u0004A\u0011\u00017\t\u000bm\u0004A\u0011\u0001?\u0003!Q\u000b'\r\\3B]\u0006d\u0017p]5t\u0015>\u0014'BA\b\u0011\u0003\rQwN\u0019\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0015tw-\u001b8f\u0015\t)b#A\u0003ls2LgN\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<7\u0001A\n\u0005\u0001q\u0011S\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0003;\rJ!\u0001\n\u0010\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005\u0019RS\"A\u0014\u000b\u0005!J\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005E1\u0012BA\u0016(\u0005\u001daunZ4j]\u001e\f\u0011\u0002^1cY\u0016$Um]2\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014!B7pI\u0016d'B\u0001\u001a\u0015\u0003!iW\r^1eCR\f\u0017B\u0001\u001b0\u0005%!\u0016M\u00197f\t\u0016\u001c8-A\u0004qe>TWm\u0019;\u0011\u0005]rdB\u0001\u001d=!\tId$D\u0001;\u0015\tY$$\u0001\u0004=e>|GOP\u0005\u0003{y\ta\u0001\u0015:fI\u00164\u0017BA A\u0005\u0019\u0019FO]5oO*\u0011QHH\u0001\te><8i\\;oiB\u0011QdQ\u0005\u0003\tz\u0011A\u0001T8oO\u0006\u00111o\u001d\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013&\n1a]9m\u0013\tY\u0005J\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0003k_\nLE-\u0001\u0004=S:LGO\u0010\u000b\u0007\u001fF\u00136\u000bV+\u0011\u0005A\u0003Q\"\u0001\b\t\u000b12\u0001\u0019A\u0017\t\u000bU2\u0001\u0019\u0001\u001c\t\u000b\u00053\u0001\u0019\u0001\"\t\u000b\u00153\u0001\u0019\u0001$\t\u000b13\u0001\u0019\u0001\u001c\u0002\u0015Q\f7o\u001b$bGR|'/F\u0001Y!\ti\u0012,\u0003\u0002[=\t\u0019\u0011J\u001c;\u0002\u0017Q\f7o\u001b$bGR|'\u000fI\u0001\u0016O\u0016$8+Y7qY\u0016$\u0016M\u00197f\t\u0006$\u0018mU3u)\u0005q\u0006cA$`C&\u0011\u0001\r\u0013\u0002\b\t\u0006$\u0018m]3u!\t9%-\u0003\u0002d\u0011\n\u0019!k\\<\u0002\u0019\u0005t\u0017\r\\={KR\u000b'\r\\3\u0015\u0005\u0019L\u0007cA\u000fhC&\u0011\u0001N\b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006U*\u0001\rAX\u0001\u000fg\u0006l\u0007\u000f\\3e\t\u0006$\u0018m]3u\u0003A\u0011W/\u001b7e'R\fGo]'fiJL7\r\u0006\u0002nsB\u0019an\u001d<\u000f\u0005=\fhBA\u001dq\u0013\u0005y\u0012B\u0001:\u001f\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001^;\u0003\t1K7\u000f\u001e\u0006\u0003ez\u0001\"aR<\n\u0005aD%AB\"pYVlg\u000eC\u0003{\u0017\u0001\u0007a,A\u0006t_V\u00148-\u001a+bE2,\u0017A\u00052vS2$\u0007*[4i\rJ,\u0017/^3oGf$\u0012\"`A\r\u00037\ty\"a\t\u0011\u000fy\f9!a\u0003\u0002\u00165\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001B;uS2T!!!\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0013y(aA'baB!\u0011QBA\n\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005\r\u0011\u0001\u00027b]\u001eL1aPA\b!\u0011\ti!a\u0006\n\u0007\u0011\u000by\u0001C\u0003{\u0019\u0001\u0007a\f\u0003\u0004\u0002\u001e1\u0001\rAN\u0001\u0007G>dW/\u001c8\t\r\u0005\u0005B\u00021\u0001C\u0003!\tG\u000e\\\"pk:$\bbBA\u0013\u0019\u0001\u0007\u0011qE\u0001\nMJ,\u0017/^3oGf\u00042!HA\u0015\u0013\r\tYC\b\u0002\u0007\t>,(\r\\3")
public class TableAnalysisJob
implements scala.Serializable,
Logging {
    private final TableDesc tableDesc;
    private final long rowCount;
    private final SparkSession ss;
    private final int taskFactor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int taskFactor() {
        return this.taskFactor;
    }

    public Dataset<Row> getSampleTableDataSet() {
        ColumnDesc[] columnDescs = this.tableDesc.getColumns();
        ArrayList tblColNames = Lists.newArrayListWithCapacity((int)columnDescs.length);
        ObjectRef kylinSchema = ObjectRef.create((Object)new StructType());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnDescs)).foreach((Function1 & Serializable & scala.Serializable)columnDesc -> {
            Object object;
            if (!columnDesc.isComputedColumn()) {
                kylinSchema$1.elem = ((StructType)kylinSchema$1.elem).add(columnDesc.getName(), SchemaProcessor$.MODULE$.toSparkType(columnDesc.getType(), SchemaProcessor$.MODULE$.toSparkType$default$2()), true);
                object = BoxesRunTime.boxToBoolean((boolean)tblColNames.add(new StringBuilder(2).append("`").append(columnDesc.getName()).append("`").toString()));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        String colString = Joiner.on((String)",").join((Iterable)tblColNames);
        String sql = String.format(Locale.ROOT, "select %s from %s", colString, this.tableDesc.getIdentity());
        Dataset df = this.ss.sql(sql);
        StructType sparkSchema = df.schema();
        this.log().debug("Source data sql is: {}", new Object[]{sql});
        this.log().debug("Kylin schema: {}", new Object[]{((StructType)kylinSchema.elem).treeString()});
        Column[] columns = SparkTypeUtil$.MODULE$.alignDataType(sparkSchema, (StructType)kylinSchema.elem);
        SparkConf sparkConf = this.ss.sparkContext().getConf();
        int instances = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.instances", "1"))).toInt();
        int cores = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.cores", "1"))).toInt();
        int numPartitions = instances * cores;
        LinkedHashMap<String, String> params = ProjectManager.getInstance(KylinConfig.getInstanceFromEnv()).getProject(this.tableDesc.getProject()).getOverrideKylinProps();
        params.put("maxSampleCount", String.valueOf(this.rowCount));
        Dataset dataFrame = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])columns)).coalesce(numPartitions);
        return CreateFlatTable$.MODULE$.changeSchemaToAliasDotName((Dataset<Row>)dataFrame, this.tableDesc.getIdentity());
    }

    public Row[] analyzeTable(Dataset<Row> sampledDataset) {
        List<Column> statsMetrics = this.buildStatsMetric(sampledDataset);
        Row[] aggData = (Row[])sampledDataset.agg(functions$.MODULE$.count(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))), statsMetrics).collect();
        Row[] sampleData = (Row[])sampledDataset.limit(10).collect();
        return (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggData)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sampleData)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
    }

    public List<Column> buildStatsMetric(Dataset<Row> sourceTable) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceTable.schema().fieldNames())).flatMap((Function1 & Serializable & scala.Serializable)name -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(TableAnalyzerJob.TABLE_STATS_METRICS.toArray()))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Column column;
            Object object = x0$1;
            if ("COUNT".equals(object)) {
                column = functions$.MODULE$.count(functions$.MODULE$.col(name));
            } else if ("COUNT_DISTINCT".equals(object)) {
                column = functions$.MODULE$.approx_count_distinct(functions$.MODULE$.col(name));
            } else if ("MAX".equals(object)) {
                column = functions$.MODULE$.max(functions$.MODULE$.col(name));
            } else if ("MIN".equals(object)) {
                column = functions$.MODULE$.min(functions$.MODULE$.col(name));
            } else {
                throw new IllegalArgumentException("Unsupported metric in TableSampling ");
            }
            return column;
        }, Seq$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).toList();
    }

    public Map<String, Long> buildHighFrequency(Dataset<Row> sourceTable, String column, long allCount, double frequency) {
        HashMap map = Maps.newHashMap();
        Row[] row = (Row[])sourceTable.groupBy(column, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg((Column)functions$.MODULE$.count(column), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).filter(functions$.MODULE$.count(column).$div((Object)BoxesRunTime.boxToLong((long)allCount)).$greater((Object)BoxesRunTime.boxToDouble((double)frequency))).collect();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row)).foreach((Function1 & Serializable & scala.Serializable)x -> map.put(x.getString(0), Predef$.MODULE$.long2Long(x.getLong(1))));
        return map;
    }

    public TableAnalysisJob(TableDesc tableDesc, String project, long rowCount, SparkSession ss, String jobId) {
        this.tableDesc = tableDesc;
        this.rowCount = rowCount;
        this.ss = ss;
        Logging.$init$((Logging)this);
        this.taskFactor = 4;
    }
}

