/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.Serializable;
import org.apache.kylin.engine.spark.job.AggInfo;
import org.apache.kylin.engine.spark.job.AggInfo$;
import org.apache.kylin.engine.spark.job.CuboidStatisticsJob$;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.shaded.com.google.common.hash.HashFunction;
import org.apache.kylin.shaded.com.google.common.hash.Hasher;
import org.apache.kylin.shaded.com.google.common.hash.Hashing;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dw!B\u0013'\u0011\u0003\u0019d!B\u001b'\u0011\u00031\u0004\"\u0002!\u0002\t\u0003\t\u0005\"\u0002\"\u0002\t\u0003\u0019\u0005\"\u0002\"\u0002\t\u0003!\u0007b\u00026\u0002\u0003\u0003%Ia\u001b\u0004\u0005k\u0019\u0002A\u000f\u0003\u0005v\r\t\u0005\t\u0015!\u0003j\u0011!1hA!A!\u0002\u00139\b\"\u0002!\u0007\t\u0003Q\bb\u0002@\u0007\u0005\u0004%Ia \u0005\t\u0003#1\u0001\u0015!\u0003\u0002\u0002!I\u00111\u0003\u0004A\u0002\u0013%\u0011Q\u0003\u0005\n\u0003C1\u0001\u0019!C\u0005\u0003GA\u0001\"a\f\u0007A\u0003&\u0011q\u0003\u0005\n\u0003c1!\u0019!C\u0005\u0003gA\u0001\"!\u0015\u0007A\u0003%\u0011Q\u0007\u0005\n\u0003'2!\u0019!C\u0005\u0003+Bq!a\u0016\u0007A\u0003%\u0011\u000eC\u0005\u0002Z\u0019\u0001\r\u0011\"\u0003\u0002\\!I\u0011Q\f\u0004A\u0002\u0013%\u0011q\f\u0005\b\u0003G2\u0001\u0015)\u0003x\u0011%\t)G\u0002a\u0001\n\u0013\t9\u0007C\u0005\u0002j\u0019\u0001\r\u0011\"\u0003\u0002l!9\u0011q\u000e\u0004!B\u0013Q\u0005\"CA9\r\u0001\u0007I\u0011BA4\u0011%\t\u0019H\u0002a\u0001\n\u0013\t)\bC\u0004\u0002z\u0019\u0001\u000b\u0015\u0002&\t\u0013\u0005md\u00011A\u0005\n\u0005\u001d\u0004\"CA?\r\u0001\u0007I\u0011BA@\u0011\u001d\t\u0019I\u0002Q!\n)Cq!!\"\u0007\t\u0003\t9\tC\u0004\u0002(\u001a!\t!!+\t\u000f\u0005-f\u0001\"\u0001\u0002.\"9\u00111\u0017\u0004\u0005\u0002\u0005U\u0006bBA]\r\u0011\u0005\u00111\u0018\u0005\b\u0003\u000b4A\u0011AAU\u0003M\u0019UOY8jIN#\u0018\r^5ti&\u001c7OS8c\u0015\t9\u0003&A\u0002k_\nT!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB3oO&tWM\u0003\u0002.]\u0005)1.\u001f7j]*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0007\u0001\u0001\"\u0001N\u0001\u000e\u0003\u0019\u00121cQ;c_&$7\u000b^1uSN$\u0018nY:K_\n\u001c2!A\u001c>!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0019\te.\u001f*fMB\u0011\u0001HP\u0005\u0003\u007fe\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#A\u001a\u0002\u0015M$\u0018\r^5ti&\u001c7\u000fF\u0002E!r\u00032\u0001O#H\u0013\t1\u0015HA\u0003BeJ\f\u0017\u0010\u0005\u00039\u0011*k\u0015BA%:\u0005\u0019!V\u000f\u001d7feA\u0011\u0001hS\u0005\u0003\u0019f\u0012A\u0001T8oOB\u0011AGT\u0005\u0003\u001f\u001a\u0012q!Q4h\u0013:4w\u000eC\u0003R\u0007\u0001\u0007!+A\u0004j]B,H\u000fR:\u0011\u0007M;\u0016,D\u0001U\u0015\t)f+A\u0002tc2T!!\u000b\u0018\n\u0005a#&a\u0002#bi\u0006\u001cX\r\u001e\t\u0003'jK!a\u0017+\u0003\u0007I{w\u000fC\u0003^\u0007\u0001\u0007a,A\u0002tK\u001e\u0004\"a\u00182\u000e\u0003\u0001T!!\u0019\u0015\u0002\u00115,G/\u00193bi\u0006L!a\u00191\u0003\u0017M+w-\\3oi&sgm\u001c\u000b\u0005\t\u00164w\rC\u0003R\t\u0001\u0007!\u000bC\u0003^\t\u0001\u0007a\fC\u0003i\t\u0001\u0007\u0011.A\u0005mCf|W\u000f^%egB\u0019\u0001(\u0012&\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002YB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\u0005Y\u0006twMC\u0001r\u0003\u0011Q\u0017M^1\n\u0005Mt'AB(cU\u0016\u001cGoE\u0002\u0007ou\n1!\u001b3t\u0003\r\u00118n\u0019\t\u0003qaL!!_\u001d\u0003\u0007%sG\u000fF\u0002|yv\u0004\"\u0001\u000e\u0004\t\u000bUL\u0001\u0019A5\t\u000bYL\u0001\u0019A<\u0002\t%tgm\\\u000b\u0003\u0003\u0003\u0001R!a\u0001\u0002\u000e5k!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\b[V$\u0018M\u00197f\u0015\r\tY!O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\b\u0003\u000b\u0011q\u0001T8oO6\u000b\u0007/A\u0003j]\u001a|\u0007%\u0001\tbY2\u001cUOY8jIN\u0014\u0015\u000e^*fiV\u0011\u0011q\u0003\t\u0005q\u0015\u000bI\u0002\u0005\u00039\u000b\u0006m\u0001cA7\u0002\u001e%\u0019\u0011q\u00048\u0003\u000f%sG/Z4fe\u0006!\u0012\r\u001c7Dk\n|\u0017\u000eZ:CSR\u001cV\r^0%KF$B!!\n\u0002,A\u0019\u0001(a\n\n\u0007\u0005%\u0012H\u0001\u0003V]&$\b\"CA\u0017\u001b\u0005\u0005\t\u0019AA\f\u0003\rAH%M\u0001\u0012C2d7)\u001e2pS\u0012\u001c()\u001b;TKR\u0004\u0013A\u00015g+\t\t)\u0004\u0005\u0003\u00028\u00055SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\t!\f7\u000f\u001b\u0006\u0005\u0003\u007f\t\t%\u0001\u0004d_6lwN\u001c\u0006\u0005\u0003\u0007\n)%\u0001\u0004h_><G.\u001a\u0006\u0005\u0003\u000f\nI%A\u0002d_6T1!a\u0013-\u0003\u0019\u0019\b.\u00193fI&!\u0011qJA\u001d\u00051A\u0015m\u001d5Gk:\u001cG/[8o\u0003\rAg\rI\u0001\u0011e><\b*Y:i\u0007>$Wm\u001d'p]\u001e,\u0012![\u0001\u0012e><\b*Y:i\u0007>$Wm\u001d'p]\u001e\u0004\u0013aA5eqV\tq/A\u0004jIb|F%Z9\u0015\t\u0005\u0015\u0012\u0011\r\u0005\t\u0003[!\u0012\u0011!a\u0001o\u0006!\u0011\u000e\u001a=!\u0003\u0019iW\r^3seU\t!*\u0001\u0006nKR,'OM0%KF$B!!\n\u0002n!A\u0011QF\f\u0002\u0002\u0003\u0007!*A\u0004nKR,'O\r\u0011\u0002\u0015M$\u0018M\u001d;NS2d7/\u0001\bti\u0006\u0014H/T5mYN|F%Z9\u0015\t\u0005\u0015\u0012q\u000f\u0005\t\u0003[Q\u0012\u0011!a\u0001\u0015\u0006Y1\u000f^1si6KG\u000e\\:!\u0003!)g\u000eZ'jY2\u001c\u0018\u0001D3oI6KG\u000e\\:`I\u0015\fH\u0003BA\u0013\u0003\u0003C\u0001\"!\f\u001e\u0003\u0003\u0005\rAS\u0001\nK:$W*\u001b7mg\u0002\n\u0011d\u001d;bi&\u001cH/[2t/&$\b.\u001b8QCJ$\u0018\u000e^5p]R!\u0011\u0011RAQ!\u0015\tY)a'N\u001d\u0011\ti)a&\u000f\t\u0005=\u0015QS\u0007\u0003\u0003#S1!a%3\u0003\u0019a$o\\8u}%\t!(C\u0002\u0002\u001af\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001e\u0006}%\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005e\u0015\bC\u0004\u0002$~\u0001\r!!*\u0002\tI|wo\u001d\t\u0006\u0003\u0017\u000bY*W\u0001\u0005S:LG\u000f\u0006\u0002\u0002&\u00051Q\u000f\u001d3bi\u0016$B!!\n\u00020\"1\u0011\u0011W\u0011A\u0002e\u000b\u0011A]\u0001\rkB$\u0017\r^3Dk\n|\u0017\u000e\u001a\u000b\u0005\u0003K\t9\f\u0003\u0004\u00022\n\u0002\r!W\u0001\u0010O\u0016$8)\u001e2pS\u0012\u0014\u0015\u000e^*fiR1\u0011qCA_\u0003\u0003Da!a0$\u0001\u0004I\u0017!C2vE>LG-\u00133t\u0011\u0019\t\u0019m\ta\u0001o\u00069aNU8x\u0017\u0016L\u0018!\u00039sS:$8\u000b^1u\u0001")
public class CuboidStatisticsJob
implements scala.Serializable {
    private final long[] ids;
    private final int rkc;
    private final LongMap<AggInfo> info;
    private Integer[][] allCuboidsBitSet;
    private final HashFunction hf;
    private final long[] rowHashCodesLong;
    private int idx;
    private long meter2;
    private long startMills;
    private long endMills;

    public static Tuple2<Object, AggInfo>[] statistics(Dataset<Row> dataset, SegmentInfo segmentInfo, long[] lArray) {
        return CuboidStatisticsJob$.MODULE$.statistics(dataset, segmentInfo, lArray);
    }

    public static Tuple2<Object, AggInfo>[] statistics(Dataset<Row> dataset, SegmentInfo segmentInfo) {
        return CuboidStatisticsJob$.MODULE$.statistics(dataset, segmentInfo);
    }

    private LongMap<AggInfo> info() {
        return this.info;
    }

    private Integer[][] allCuboidsBitSet() {
        return this.allCuboidsBitSet;
    }

    private void allCuboidsBitSet_$eq(Integer[][] x$1) {
        this.allCuboidsBitSet = x$1;
    }

    private HashFunction hf() {
        return this.hf;
    }

    private long[] rowHashCodesLong() {
        return this.rowHashCodesLong;
    }

    private int idx() {
        return this.idx;
    }

    private void idx_$eq(int x$1) {
        this.idx = x$1;
    }

    private long meter2() {
        return this.meter2;
    }

    private void meter2_$eq(long x$1) {
        this.meter2 = x$1;
    }

    private long startMills() {
        return this.startMills;
    }

    private void startMills_$eq(long x$1) {
        this.startMills = x$1;
    }

    private long endMills() {
        return this.endMills;
    }

    private void endMills_$eq(long x$1) {
        this.endMills = x$1;
    }

    public Iterator<AggInfo> statisticsWithinPartition(Iterator<Row> rows) {
        this.init();
        Predef$.MODULE$.println((Object)new StringBuilder(47).append("CuboidStatisticsJob-statisticsWithinPartition1-").append(System.currentTimeMillis()).toString());
        rows.foreach((Function1 & Serializable & scala.Serializable)r -> {
            this.update(r);
            return BoxedUnit.UNIT;
        });
        this.printStat();
        Predef$.MODULE$.println((Object)new StringBuilder(47).append("CuboidStatisticsJob-statisticsWithinPartition2-").append(System.currentTimeMillis()).toString());
        return this.info().valuesIterator();
    }

    public void init() {
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("CuboidStatisticsJob-Init1-").append(System.currentTimeMillis()).toString());
        this.allCuboidsBitSet_$eq(this.getCuboidBitSet(this.ids, this.rkc));
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(this.ids)).foreach((Function1 & Serializable & scala.Serializable)i -> CuboidStatisticsJob.$anonfun$init$1(this, BoxesRunTime.unboxToLong((Object)i)));
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("CuboidStatisticsJob-Init2-").append(System.currentTimeMillis()).toString());
    }

    public void update(Row r) {
        this.idx_$eq(this.idx() + 1);
        if (this.idx() <= 5) {
            Predef$.MODULE$.println((Object)r);
        }
        this.updateCuboid(r);
    }

    public void updateCuboid(Row r) {
        int idx;
        for (idx = 0; idx < this.rkc; ++idx) {
            Hasher hc = this.hf().newHasher();
            String colValue = r.get(idx) == null ? "0" : r.get(idx).toString();
            this.rowHashCodesLong()[idx] = hc.putUnencodedChars(colValue).hash().padToLong() + (long)idx;
        }
        this.startMills_$eq(System.currentTimeMillis());
        int n = this.allCuboidsBitSet().length;
        for (idx = 0; idx < n; ++idx) {
            long value = 0L;
            Integer[] currCuboidBitSet = this.allCuboidsBitSet()[idx];
            int currCuboidLength = currCuboidBitSet.length;
            for (int position = 0; position < currCuboidLength; ++position) {
                value += this.rowHashCodesLong()[Predef$.MODULE$.Integer2int(currCuboidBitSet[position])];
            }
            ((AggInfo)this.info().apply(this.ids[idx])).cuboid().counter().addHashDirectly(value);
        }
        this.endMills_$eq(System.currentTimeMillis());
        this.meter2_$eq(this.meter2() + (this.endMills() - this.startMills()));
    }

    /*
     * WARNING - void declaration
     */
    public Integer[][] getCuboidBitSet(long[] cuboidIds, int nRowKey) {
        void var3_3;
        Integer[][] allCuboidsBitSet = new Integer[cuboidIds.length][];
        for (int j = 0; j < cuboidIds.length; ++j) {
            long cuboidId = cuboidIds[j];
            allCuboidsBitSet[j] = new Integer[Long.bitCount(cuboidId)];
            long mask = 1L << nRowKey - 1;
            int position = 0;
            for (int i = 0; i < nRowKey; ++i) {
                if ((mask & cuboidId) > 0L) {
                    allCuboidsBitSet[j][position] = Predef$.MODULE$.int2Integer(i);
                    ++position;
                }
                mask >>= 1;
            }
        }
        return var3_3;
    }

    public void printStat() {
        Predef$.MODULE$.println((Object)"    Stats");
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("i      :").append(this.idx()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("meter  :").append(this.meter2()).toString());
    }

    public static final /* synthetic */ Option $anonfun$init$1(CuboidStatisticsJob $this, long i) {
        return $this.info().put(i, (Object)new AggInfo(i, AggInfo$.MODULE$.apply$default$2(), AggInfo$.MODULE$.apply$default$3(), AggInfo$.MODULE$.apply$default$4()));
    }

    public CuboidStatisticsJob(long[] ids, int rkc) {
        this.ids = ids;
        this.rkc = rkc;
        this.info = LongMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.allCuboidsBitSet = (Integer[][])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.class)));
        this.hf = Hashing.murmur3_128();
        this.rowHashCodesLong = new long[rkc];
        this.idx = 0;
        this.meter2 = 0L;
        this.startMills = 0L;
        this.endMills = 0L;
    }
}

