/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiClusterVersion;
import com.cloudera.api.swagger.model.ApiDataContextRef;
import com.cloudera.api.swagger.model.ApiEntityStatus;
import com.cloudera.api.swagger.model.ApiEntityTag;
import com.cloudera.api.swagger.model.ApiEntityType;
import com.cloudera.api.swagger.model.ApiParcel;
import com.cloudera.api.swagger.model.ApiService;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="A cluster represents a set of interdependent services running on a set of hosts. All services on a given cluster are of the same software version (e.g. CDH4 or CDH5).")
public class ApiCluster {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="version")
    private ApiClusterVersion version = null;
    @SerializedName(value="fullVersion")
    private String fullVersion = null;
    @SerializedName(value="maintenanceMode")
    private Boolean maintenanceMode = null;
    @SerializedName(value="maintenanceOwners")
    private List<ApiEntityType> maintenanceOwners = null;
    @SerializedName(value="services")
    private List<ApiService> services = null;
    @SerializedName(value="parcels")
    private List<ApiParcel> parcels = null;
    @SerializedName(value="clusterUrl")
    private String clusterUrl = null;
    @SerializedName(value="hostsUrl")
    private String hostsUrl = null;
    @SerializedName(value="entityStatus")
    private ApiEntityStatus entityStatus = null;
    @SerializedName(value="uuid")
    private String uuid = null;
    @SerializedName(value="dataContextRefs")
    private List<ApiDataContextRef> dataContextRefs = null;
    @SerializedName(value="clusterType")
    private String clusterType = null;
    @SerializedName(value="tags")
    private List<ApiEntityTag> tags = null;

    public ApiCluster name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of the cluster. <p> Immutable since API v6. <p> Prior to API v6, will contain the display name of the cluster.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiCluster displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="The display name of the cluster that is shown in the UI. <p> Available since API v6.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiCluster version(ApiClusterVersion version) {
        this.version = version;
        return this;
    }

    @Schema(description="")
    public ApiClusterVersion getVersion() {
        return this.version;
    }

    public void setVersion(ApiClusterVersion version) {
        this.version = version;
    }

    public ApiCluster fullVersion(String fullVersion) {
        this.fullVersion = fullVersion;
        return this;
    }

    @Schema(description="The full CDH version of the cluster. The expected format is three dot separated version numbers, e.g. \"4.2.1\" or \"5.0.0\". The full version takes precedence over the version field during cluster creation. <p> Available since API v6.")
    public String getFullVersion() {
        return this.fullVersion;
    }

    public void setFullVersion(String fullVersion) {
        this.fullVersion = fullVersion;
    }

    public ApiCluster maintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
        return this;
    }

    @Schema(description="Readonly. Whether the cluster is in maintenance mode. Available since API v2.")
    public Boolean isMaintenanceMode() {
        return this.maintenanceMode;
    }

    public void setMaintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }

    public ApiCluster maintenanceOwners(List<ApiEntityType> maintenanceOwners) {
        this.maintenanceOwners = maintenanceOwners;
        return this;
    }

    public ApiCluster addMaintenanceOwnersItem(ApiEntityType maintenanceOwnersItem) {
        if (this.maintenanceOwners == null) {
            this.maintenanceOwners = new ArrayList<ApiEntityType>();
        }
        this.maintenanceOwners.add(maintenanceOwnersItem);
        return this;
    }

    @Schema(description="Readonly. The list of objects that trigger this cluster to be in maintenance mode. Available since API v2.")
    public List<ApiEntityType> getMaintenanceOwners() {
        return this.maintenanceOwners;
    }

    public void setMaintenanceOwners(List<ApiEntityType> maintenanceOwners) {
        this.maintenanceOwners = maintenanceOwners;
    }

    public ApiCluster services(List<ApiService> services) {
        this.services = services;
        return this;
    }

    public ApiCluster addServicesItem(ApiService servicesItem) {
        if (this.services == null) {
            this.services = new ArrayList<ApiService>();
        }
        this.services.add(servicesItem);
        return this;
    }

    @Schema(description="Optional. Used during import/export of settings.")
    public List<ApiService> getServices() {
        return this.services;
    }

    public void setServices(List<ApiService> services) {
        this.services = services;
    }

    public ApiCluster parcels(List<ApiParcel> parcels) {
        this.parcels = parcels;
        return this;
    }

    public ApiCluster addParcelsItem(ApiParcel parcelsItem) {
        if (this.parcels == null) {
            this.parcels = new ArrayList<ApiParcel>();
        }
        this.parcels.add(parcelsItem);
        return this;
    }

    @Schema(description="Optional. Used during import/export of settings. Available since API v4.")
    public List<ApiParcel> getParcels() {
        return this.parcels;
    }

    public void setParcels(List<ApiParcel> parcels) {
        this.parcels = parcels;
    }

    public ApiCluster clusterUrl(String clusterUrl) {
        this.clusterUrl = clusterUrl;
        return this;
    }

    @Schema(description="Readonly. Link into the Cloudera Manager web UI for this specific cluster. <p> Available since API v10.")
    public String getClusterUrl() {
        return this.clusterUrl;
    }

    public void setClusterUrl(String clusterUrl) {
        this.clusterUrl = clusterUrl;
    }

    public ApiCluster hostsUrl(String hostsUrl) {
        this.hostsUrl = hostsUrl;
        return this;
    }

    @Schema(description="Readonly. Link into the Cloudera Manager web UI for host table for this cluster. <p> Available since API v11.")
    public String getHostsUrl() {
        return this.hostsUrl;
    }

    public void setHostsUrl(String hostsUrl) {
        this.hostsUrl = hostsUrl;
    }

    public ApiCluster entityStatus(ApiEntityStatus entityStatus) {
        this.entityStatus = entityStatus;
        return this;
    }

    @Schema(description="")
    public ApiEntityStatus getEntityStatus() {
        return this.entityStatus;
    }

    public void setEntityStatus(ApiEntityStatus entityStatus) {
        this.entityStatus = entityStatus;
    }

    public ApiCluster uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Schema(description="Readonly. The UUID of the cluster. <p> Available since API v15.")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ApiCluster dataContextRefs(List<ApiDataContextRef> dataContextRefs) {
        this.dataContextRefs = dataContextRefs;
        return this;
    }

    public ApiCluster addDataContextRefsItem(ApiDataContextRef dataContextRefsItem) {
        if (this.dataContextRefs == null) {
            this.dataContextRefs = new ArrayList<ApiDataContextRef>();
        }
        this.dataContextRefs.add(dataContextRefsItem);
        return this;
    }

    @Schema(description="")
    public List<ApiDataContextRef> getDataContextRefs() {
        return this.dataContextRefs;
    }

    public void setDataContextRefs(List<ApiDataContextRef> dataContextRefs) {
        this.dataContextRefs = dataContextRefs;
    }

    public ApiCluster clusterType(String clusterType) {
        this.clusterType = clusterType;
        return this;
    }

    @Schema(description="The type of cluster. If unspecified, defaults to either BASE_CLUSTER (if no data contexts are provided) or COMPUTE_CLUSTER (if one or more data contexts are provided). Available since APIv32.")
    public String getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(String clusterType) {
        this.clusterType = clusterType;
    }

    public ApiCluster tags(List<ApiEntityTag> tags) {
        this.tags = tags;
        return this;
    }

    public ApiCluster addTagsItem(ApiEntityTag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<ApiEntityTag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Schema(description="Tags associated with the cluster. Available since V41.")
    public List<ApiEntityTag> getTags() {
        return this.tags;
    }

    public void setTags(List<ApiEntityTag> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiCluster apiCluster = (ApiCluster)o;
        return Objects.equals(this.name, apiCluster.name) && Objects.equals(this.displayName, apiCluster.displayName) && Objects.equals((Object)this.version, (Object)apiCluster.version) && Objects.equals(this.fullVersion, apiCluster.fullVersion) && Objects.equals(this.maintenanceMode, apiCluster.maintenanceMode) && Objects.equals(this.maintenanceOwners, apiCluster.maintenanceOwners) && Objects.equals(this.services, apiCluster.services) && Objects.equals(this.parcels, apiCluster.parcels) && Objects.equals(this.clusterUrl, apiCluster.clusterUrl) && Objects.equals(this.hostsUrl, apiCluster.hostsUrl) && Objects.equals((Object)this.entityStatus, (Object)apiCluster.entityStatus) && Objects.equals(this.uuid, apiCluster.uuid) && Objects.equals(this.dataContextRefs, apiCluster.dataContextRefs) && Objects.equals(this.clusterType, apiCluster.clusterType) && Objects.equals(this.tags, apiCluster.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.displayName, this.version, this.fullVersion, this.maintenanceMode, this.maintenanceOwners, this.services, this.parcels, this.clusterUrl, this.hostsUrl, this.entityStatus, this.uuid, this.dataContextRefs, this.clusterType, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiCluster {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    version: ").append(this.toIndentedString((Object)this.version)).append("\n");
        sb.append("    fullVersion: ").append(this.toIndentedString(this.fullVersion)).append("\n");
        sb.append("    maintenanceMode: ").append(this.toIndentedString(this.maintenanceMode)).append("\n");
        sb.append("    maintenanceOwners: ").append(this.toIndentedString(this.maintenanceOwners)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    parcels: ").append(this.toIndentedString(this.parcels)).append("\n");
        sb.append("    clusterUrl: ").append(this.toIndentedString(this.clusterUrl)).append("\n");
        sb.append("    hostsUrl: ").append(this.toIndentedString(this.hostsUrl)).append("\n");
        sb.append("    entityStatus: ").append(this.toIndentedString((Object)this.entityStatus)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    dataContextRefs: ").append(this.toIndentedString(this.dataContextRefs)).append("\n");
        sb.append("    clusterType: ").append(this.toIndentedString(this.clusterType)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

