/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.whiteboard;

import javax.management.MBeanServer;
import org.apache.aries.jmx.whiteboard.JmxWhiteboardSupport;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private JmxWhiteboardSupport jmxWhiteBoard;
    private ServiceTracker mbeanServerTracker;
    private ServiceTracker mbeanTracker;

    public void start(BundleContext context) throws Exception {
        this.jmxWhiteBoard = new JmxWhiteboardSupport();
        this.mbeanServerTracker = new MBeanServerTracker(context);
        this.mbeanServerTracker.open();
        this.mbeanTracker = new MBeanTracker(context);
        this.mbeanTracker.open(true);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.mbeanTracker != null) {
            this.mbeanTracker.close();
            this.mbeanTracker = null;
        }
        if (this.mbeanServerTracker != null) {
            this.mbeanServerTracker.close();
            this.mbeanServerTracker = null;
        }
        this.jmxWhiteBoard = null;
    }

    private class MBeanTracker
    extends ServiceTracker {
        private static final String SIMPLE_MBEAN_FILTER = "(jmx.objectname=*)";

        public MBeanTracker(BundleContext context) throws InvalidSyntaxException {
            super(context, context.createFilter(SIMPLE_MBEAN_FILTER), null);
        }

        public Object addingService(ServiceReference reference) {
            Object mbean = super.addingService(reference);
            Activator.this.jmxWhiteBoard.registerMBean(mbean, reference);
            return mbean;
        }

        public void removedService(ServiceReference reference, Object service) {
            Activator.this.jmxWhiteBoard.unregisterMBean(service);
            super.removedService(reference, service);
        }
    }

    private class MBeanServerTracker
    extends ServiceTracker {
        public MBeanServerTracker(BundleContext context) {
            super(context, MBeanServer.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            MBeanServer mbeanServer = (MBeanServer)super.addingService(reference);
            Activator.this.jmxWhiteBoard.addMBeanServer(mbeanServer);
            return mbeanServer;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof MBeanServer) {
                Activator.this.jmxWhiteBoard.removeMBeanServer((MBeanServer)service);
            }
            super.removedService(reference, service);
        }
    }
}

