/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.apache.camel.blueprint.BlueprintCamelStateService;
import org.apache.karaf.bundle.core.BundleState;
import org.apache.karaf.bundle.core.BundleStateService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class KarafBundleStateService
implements BundleStateService {
    BlueprintCamelStateService camelStateService;

    public KarafBundleStateService(BlueprintCamelStateService camelStateService) {
        this.camelStateService = camelStateService;
    }

    public String getName() {
        return "Camel Blueprint";
    }

    public String getDiag(Bundle bundle) {
        if (this.getState(bundle) == BundleState.Failure) {
            Map<String, Throwable> exceptions = this.camelStateService.getExceptions(bundle);
            StringWriter sw = new StringWriter();
            for (String contextId : exceptions.keySet()) {
                sw.append("Camel context \"").append(contextId).append("\"\n");
                Throwable t = exceptions.get(contextId);
                if (t instanceof NullPointerException) {
                    sw.append("Exception: NullPointerException\n");
                } else if (t.getMessage() != null) {
                    sw.append("Exception: ").append(t.getMessage()).append("\n");
                }
                t.printStackTrace(new PrintWriter(sw));
                sw.append("\n");
            }
            return sw.toString();
        }
        return null;
    }

    public BundleState getState(Bundle bundle) {
        BundleState effective = BundleState.Unknown;
        for (BlueprintCamelStateService.State s : this.camelStateService.getStates(bundle)) {
            if (effective != BundleState.Unknown && s != BlueprintCamelStateService.State.Failure) continue;
            switch (s) {
                case Starting: {
                    effective = BundleState.Starting;
                    break;
                }
                case Active: {
                    effective = BundleState.Active;
                    break;
                }
                case Failure: {
                    effective = BundleState.Failure;
                    break;
                }
            }
        }
        return effective;
    }

    public ServiceRegistration<?> register(BundleContext context) {
        return context.registerService(BundleStateService.class, (Object)this, null);
    }
}

