/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.useradmin.Authorization;

public class AuthorizationData {
    private String name;
    private String[] roles;

    public AuthorizationData(Authorization auth) {
        this.name = auth.getName();
        this.roles = auth.getRoles();
    }

    public AuthorizationData(String name, String[] roles) {
        this.name = name;
        this.roles = roles;
    }

    public CompositeData toCompositeData() {
        try {
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("Name", this.name);
            items.put("Roles", this.roles);
            return new CompositeDataSupport(UserAdminMBean.AUTORIZATION_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData" + e);
        }
    }

    public static AuthorizationData from(CompositeData data) {
        if (data == null) {
            return null;
        }
        String name = (String)data.get("Name");
        String[] roles = (String[])data.get("Roles");
        return new AuthorizationData(name, roles);
    }

    public String getName() {
        return this.name;
    }

    public String[] getRoles() {
        return this.roles;
    }
}

