/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.Beanc;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.svl.VarResolverSession;

public class BeancAnnotation {
    public static final Beanc DEFAULT = BeancAnnotation.create().build();

    public static Beanc copy(Beanc a, VarResolverSession r) {
        return BeancAnnotation.create().on(r.resolve(a.on())).properties(r.resolve(a.properties())).build();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(String ... on) {
        return BeancAnnotation.create().on(on);
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderC {
        private String[] description = new String[0];
        private String properties = "";

        protected Builder() {
            super(Beanc.class);
        }

        public Beanc build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder properties(String value) {
            this.properties = value;
            return this;
        }

        @Override
        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Constructor<?> ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(ConstructorInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedAnnotationObject
    implements Beanc {
        private final String[] description;
        private final String properties;

        Object(Builder b) {
            super(b);
            this.description = CollectionUtils.copyOf(b.description);
            this.properties = b.properties;
        }

        @Override
        public String[] description() {
            return this.description;
        }

        @Override
        public String properties() {
            return this.properties;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Beanc[] value();
    }

    public static class Applier
    extends AnnotationApplier<Beanc, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Beanc.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Beanc> ai, BeanContext.Builder b) {
            Beanc a = ai.inner();
            if (CollectionUtils.isEmptyArray(a.on())) {
                return;
            }
            b.annotations(BeancAnnotation.copy(a, this.vr()));
        }
    }
}

