/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.Context;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.annotation.AppliedOnClassAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.svl.VarResolverSession;

public class HtmlAnnotation {
    public static final Html DEFAULT = HtmlAnnotation.create().build();

    public static Html copy(Html a, VarResolverSession r) {
        return HtmlAnnotation.create().anchorText(r.resolve(a.anchorText())).format(a.format()).link(r.resolve(a.link())).noTableHeaders(a.noTableHeaders()).noTables(a.noTables()).on(r.resolve(a.on())).onClass(a.onClass()).render(a.render()).build();
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return HtmlAnnotation.create().on(on);
    }

    public static Builder create(String ... on) {
        return HtmlAnnotation.create().on(on);
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderTMF {
        private String[] description = new String[0];
        private String anchorText = "";
        private String link = "";
        private String style = "";
        private HtmlFormat format = HtmlFormat.HTML;
        private boolean noTableHeaders;
        private boolean noTables;
        private Class<? extends HtmlRender> render = HtmlRender.class;

        protected Builder() {
            super(Html.class);
        }

        public Builder anchorText(String value) {
            this.anchorText = value;
            return this;
        }

        public Html build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder format(HtmlFormat value) {
            this.format = value;
            return this;
        }

        public Builder link(String value) {
            this.link = value;
            return this;
        }

        public Builder noTableHeaders(boolean value) {
            this.noTableHeaders = value;
            return this;
        }

        public Builder noTables(boolean value) {
            this.noTables = value;
            return this;
        }

        public Builder render(Class<? extends HtmlRender> value) {
            this.render = value;
            return this;
        }

        public Builder style(String value) {
            this.style = value;
            return this;
        }

        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        public Builder on(ClassInfo ... value) {
            super.on(value);
            return this;
        }

        public Builder onClass(ClassInfo ... value) {
            super.onClass(value);
            return this;
        }

        public Builder on(FieldInfo ... value) {
            super.on(value);
            return this;
        }

        public Builder on(MethodInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedOnClassAnnotationObject
    implements Html {
        private final String[] description;
        private final boolean noTableHeaders;
        private final boolean noTables;
        private final Class<? extends HtmlRender> render;
        private final String anchorText;
        private final String link;
        private final String style;
        private final HtmlFormat format;

        Object(Builder b) {
            super((AppliedAnnotationObject.BuilderT)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.anchorText = b.anchorText;
            this.format = b.format;
            this.link = b.link;
            this.noTableHeaders = b.noTableHeaders;
            this.noTables = b.noTables;
            this.render = b.render;
            this.style = b.style;
        }

        @Override
        public String anchorText() {
            return this.anchorText;
        }

        @Override
        public HtmlFormat format() {
            return this.format;
        }

        @Override
        public String link() {
            return this.link;
        }

        @Override
        public boolean noTableHeaders() {
            return this.noTableHeaders;
        }

        @Override
        public boolean noTables() {
            return this.noTables;
        }

        @Override
        public Class<? extends HtmlRender> render() {
            return this.render;
        }

        @Override
        public String style() {
            return this.style;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Html[] value();
    }

    public static class Apply
    extends AnnotationApplier<Html, Context.Builder> {
        public Apply(VarResolverSession vr) {
            super(Html.class, Context.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Html> ai, Context.Builder b) {
            Html a = (Html)ai.inner();
            if (CollectionUtils.isEmptyArray((java.lang.Object[])a.on()) && CollectionUtils.isEmptyArray((java.lang.Object[])a.onClass())) {
                return;
            }
            b.annotations(HtmlAnnotation.copy(a, this.vr()));
        }
    }
}

