/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.concurrent.SimpleLock;
import org.apache.juneau.commons.concurrent.SimpleReadWriteLock;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ExecutableInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreateMethodFinder;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStoreEntry;

public class BeanStore {
    public static final BeanStore INSTANCE = BeanStore.create().readOnly().build();
    private final Deque<BeanStoreEntry<?>> entries;
    private final Map<Class<?>, BeanStoreEntry<?>> unnamedEntries;
    final Optional<BeanStore> parent;
    final Optional<Object> outer;
    final boolean readOnly;
    final boolean threadSafe;
    final SimpleReadWriteLock lock;

    public static Builder create() {
        return new Builder();
    }

    public static BeanStore of(BeanStore parent) {
        return BeanStore.create().parent(parent).build();
    }

    public static BeanStore of(BeanStore parent, Object outer) {
        return BeanStore.create().parent(parent).outer(outer).build();
    }

    protected BeanStore(Builder builder) {
        this.parent = Utils.opt((Object)builder.parent);
        this.outer = Utils.opt((Object)builder.outer);
        this.readOnly = builder.readOnly;
        this.threadSafe = builder.threadSafe;
        this.lock = this.threadSafe ? new SimpleReadWriteLock() : SimpleReadWriteLock.NO_OP;
        this.entries = this.threadSafe ? new ConcurrentLinkedDeque() : new LinkedList();
        this.unnamedEntries = this.threadSafe ? new ConcurrentHashMap() : CollectionUtils.map();
    }

    BeanStore() {
        this(BeanStore.create());
    }

    public <T> T add(Class<T> beanType, T bean) {
        this.add(beanType, bean, null);
        return bean;
    }

    public <T> T add(Class<T> beanType, T bean, String name) {
        this.addBean(beanType, bean, name);
        return bean;
    }

    public <T> BeanStore addBean(Class<T> beanType, T bean) {
        return this.addBean(beanType, bean, null);
    }

    public <T> BeanStore addBean(Class<T> beanType, T bean, String name) {
        return this.addSupplier(beanType, () -> bean, name);
    }

    public <T> BeanStore addSupplier(Class<T> beanType, Supplier<T> bean) {
        return this.addSupplier(beanType, bean, null);
    }

    public <T> BeanStore addSupplier(Class<T> beanType, Supplier<T> bean, String name) {
        this.assertCanWrite();
        BeanStoreEntry<T> e = this.createEntry(beanType, bean, name);
        try (SimpleLock x = this.lock.write();){
            this.entries.addFirst(e);
            if (Utils.e((CharSequence)name)) {
                this.unnamedEntries.put(beanType, e);
            }
        }
        return this;
    }

    public BeanStore clear() {
        this.assertCanWrite();
        try (SimpleLock x = this.lock.write();){
            this.unnamedEntries.clear();
            this.entries.clear();
        }
        return this;
    }

    public <T> BeanCreator<T> createBean(Class<T> beanType) {
        return new BeanCreator<T>(beanType, this);
    }

    public <T> BeanCreateMethodFinder<T> createMethodFinder(Class<T> beanType) {
        return new BeanCreateMethodFinder<T>(beanType, this.outer.orElseThrow(() -> new IllegalArgumentException("Method cannot be used without outer bean definition.")), this);
    }

    public <T> BeanCreateMethodFinder<T> createMethodFinder(Class<T> beanType, Class<?> resourceClass) {
        return new BeanCreateMethodFinder<T>(beanType, resourceClass, this);
    }

    public <T> BeanCreateMethodFinder<T> createMethodFinder(Class<T> beanType, Object resource) {
        return new BeanCreateMethodFinder<T>(beanType, resource, this);
    }

    public <T> Optional<T> getBean(Class<T> beanType) {
        try (SimpleLock x = this.lock.read();){
            BeanStoreEntry<?> e = this.unnamedEntries.get(beanType);
            if (Utils.nn(e)) {
                Optional optional = Utils.opt(e.get());
                return optional;
            }
            if (this.parent.isPresent()) {
                Optional<T> optional = this.parent.get().getBean(beanType);
                return optional;
            }
            Optional optional = Utils.opte();
            return optional;
        }
    }

    public <T> Optional<T> getBean(Class<T> beanType, String name) {
        try (SimpleLock x = this.lock.read();){
            BeanStoreEntry e = this.entries.stream().filter(x2 -> x2.matches(beanType, name)).findFirst().orElse(null);
            if (Utils.nn((Object)e)) {
                Optional optional = Utils.opt(e.get());
                return optional;
            }
            if (this.parent.isPresent()) {
                Optional<T> optional = this.parent.get().getBean(beanType, name);
                return optional;
            }
            Optional optional = Utils.opte();
            return optional;
        }
    }

    public String getMissingParams(ExecutableInfo executable) {
        List params = executable.getParameters();
        List l = CollectionUtils.list((Object[])new String[0]);
        for (int i = 0; i < params.size(); ++i) {
            ParameterInfo pi = (ParameterInfo)params.get(i);
            ClassInfo pt = pi.getParameterType();
            if (i == 0 && this.outer.isPresent() && pt.isInstance(this.outer.get()) || pt.is(Optional.class) || pt.is(BeanStore.class)) continue;
            String beanName = pi.getResolvedQualifier();
            Class ptc = pt.inner();
            if (beanName == null && !this.hasBean(ptc)) {
                l.add(pt.getNameSimple());
            }
            if (!Utils.nn((Object)beanName) || this.hasBean(ptc, beanName)) continue;
            l.add(pt.getNameSimple() + "@" + beanName);
        }
        return l.isEmpty() ? null : l.stream().sorted().collect(Collectors.joining(","));
    }

    public Object[] getParams(ExecutableInfo executable) {
        Object[] o = new Object[executable.getParameterCount()];
        for (int i = 0; i < executable.getParameterCount(); ++i) {
            ParameterInfo pi = executable.getParameter(i);
            ClassInfo pt = pi.getParameterType();
            if (i == 0 && this.outer.isPresent() && pt.isInstance(this.outer.get())) {
                o[i] = this.outer.get();
                continue;
            }
            if (pt.is(BeanStore.class)) {
                o[i] = this;
                continue;
            }
            String beanQualifier = pi.getResolvedQualifier();
            Class ptc = pt.unwrap(new Class[]{Optional.class}).inner();
            Optional<Object> o2 = beanQualifier == null ? this.getBean(ptc) : this.getBean(ptc, beanQualifier);
            o[i] = pt.is(Optional.class) ? o2 : o2.orElse(null);
        }
        return o;
    }

    public boolean hasAllParams(ExecutableInfo executable) {
        for (int i = 0; i < executable.getParameterCount(); ++i) {
            ParameterInfo pi = executable.getParameter(i);
            ClassInfo pt = pi.getParameterType();
            if (i == 0 && this.outer.isPresent() && pt.isInstance(this.outer.get()) || pt.is(Optional.class) || pt.is(BeanStore.class)) continue;
            String beanQualifier = pi.getResolvedQualifier();
            Class ptc = pt.inner();
            if ((beanQualifier != null || this.hasBean(ptc)) && (!Utils.nn((Object)beanQualifier) || this.hasBean(ptc, beanQualifier))) continue;
            return false;
        }
        return true;
    }

    public boolean hasBean(Class<?> beanType) {
        return this.unnamedEntries.containsKey(beanType) || this.parent.map(x -> x.hasBean(beanType)).orElse(false) != false;
    }

    public boolean hasBean(Class<?> beanType, String name) {
        return this.entries.stream().anyMatch(x -> x.matches(beanType, name)) || this.parent.map(x -> x.hasBean(beanType, name)).orElse(false) != false;
    }

    public BeanStore removeBean(Class<?> beanType) {
        return this.removeBean(beanType, null);
    }

    public BeanStore removeBean(Class<?> beanType, String name) {
        this.assertCanWrite();
        try (SimpleLock x = this.lock.write();){
            if (name == null) {
                this.unnamedEntries.remove(beanType);
            }
            this.entries.removeIf(y -> y.matches(beanType, name));
        }
        return this;
    }

    public <T> Stream<BeanStoreEntry<T>> stream(Class<T> beanType) {
        Stream<BeanStoreEntry<T>> s = this.entries.stream().filter(x -> x.matches(beanType)).map(x -> x);
        if (this.parent.isPresent()) {
            s = Stream.concat(s, this.parent.get().stream(beanType));
        }
        return s;
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a((Object)"entries", this.entries.stream().map(BeanStoreEntry::properties).collect(Collectors.toList())).a((Object)"identity", (Object)Utils.id((Object)this)).a((Object)"outer", (Object)Utils.id(this.outer.orElse(null))).a((Object)"parent", this.parent.map(BeanStore::properties).orElse(null)).ai(this.readOnly, (Object)"readOnly", (Object)this.readOnly).ai(this.threadSafe, (Object)"threadSafe", (Object)this.threadSafe);
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    private void assertCanWrite() {
        if (this.readOnly) {
            throw new IllegalStateException("Method cannot be used because BeanStore is read-only.");
        }
    }

    protected <T> BeanStoreEntry<T> createEntry(Class<T> type, Supplier<T> bean, String name) {
        return BeanStoreEntry.create(type, bean, name);
    }

    public static class Builder {
        BeanStore parent;
        boolean readOnly;
        boolean threadSafe;
        Object outer;
        Class<? extends BeanStore> type;
        BeanStore impl;

        protected Builder() {
        }

        public BeanStore build() {
            if (Utils.nn((Object)this.impl)) {
                return this.impl;
            }
            if (this.type == null || this.type == BeanStore.class) {
                return new BeanStore(this);
            }
            ClassInfoTyped c = ReflectionUtils.info(this.type);
            Optional<BeanStore> result = c.getDeclaredMethod(x -> x.isPublic() && x.getParameterCount() == 0 && x.isStatic() && x.hasName("getInstance")).map(m -> (BeanStore)m.invoke(null, new Object[0]));
            if (result.isPresent()) {
                return result.get();
            }
            result = c.getPublicConstructor(x -> x.canAccept(new Object[]{this})).map(ci -> (BeanStore)ci.newInstance(new Object[]{this}));
            if (result.isPresent()) {
                return result.get();
            }
            result = c.getDeclaredConstructor(x -> x.isProtected() && x.canAccept(new Object[]{this})).map(ci -> (BeanStore)ci.accessible().newInstance(new Object[]{this}));
            if (result.isPresent()) {
                return result.get();
            }
            throw ThrowableUtils.rex((String)"Could not find a way to instantiate class {0}", (Object[])new Object[]{Utils.cn(this.type)});
        }

        public Builder impl(BeanStore value) {
            this.impl = value;
            return this;
        }

        public Builder outer(Object value) {
            this.outer = value;
            return this;
        }

        public Builder parent(BeanStore value) {
            this.parent = value;
            return this;
        }

        public Builder readOnly() {
            this.readOnly = true;
            return this;
        }

        public Builder threadSafe() {
            this.threadSafe = true;
            return this;
        }

        public Builder type(Class<? extends BeanStore> value) {
            this.type = value;
            return this;
        }
    }

    public static final class Void
    extends BeanStore {
    }
}

