/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import jakarta.servlet.ServletInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.commons.io.CharSequenceReader;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderSet;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.http.response.UnsupportedMediaType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserMatch;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ParserSet;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.util.BoundedServletInputStream;

public class RequestContent {
    private byte[] content;
    private final RestRequest req;
    private EncoderSet encoders;
    private Encoder encoder;
    private ParserSet parsers;
    private long maxInput;
    private int contentLength;
    private MediaType mediaType;
    private Parser parser;
    private HttpPartSchema schema;

    public RequestContent(RestRequest req) {
        this.req = req;
    }

    public <T> T as(Class<T> type) throws BadRequest, UnsupportedMediaType, InternalServerError {
        return this.getInner(this.getClassMeta(type));
    }

    public <T> T as(Type type, Type ... args) throws BadRequest, UnsupportedMediaType, InternalServerError {
        return this.getInner(this.getClassMeta(type, args));
    }

    public byte[] asBytes() throws IOException {
        this.cache();
        return this.content;
    }

    public String asHex() throws IOException {
        this.cache();
        return StringUtils.toHex(this.content);
    }

    public String asSpacedHex() throws IOException {
        this.cache();
        return StringUtils.toSpacedHex(this.content);
    }

    public String asString() throws IOException {
        this.cache();
        return new String(this.content, IoUtils.UTF8);
    }

    public RequestContent cache() throws IOException {
        if (this.content == null) {
            this.content = IoUtils.readBytes((InputStream)this.getInputStream());
        }
        return this;
    }

    public RequestContent content(byte[] value) {
        this.content = value;
        return this;
    }

    public RequestContent encoders(EncoderSet value) {
        this.encoders = value;
        return this;
    }

    public int getContentLength() {
        return this.contentLength == 0 ? this.req.getHttpServletRequest().getContentLength() : this.contentLength;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (Utils.nn(this.content)) {
            return new BoundedServletInputStream(this.content);
        }
        Encoder enc = this.getEncoder();
        ServletInputStream is = this.req.getHttpServletRequest().getInputStream();
        if (enc == null) {
            return new BoundedServletInputStream(is, this.maxInput);
        }
        return new BoundedServletInputStream(enc.getInputStream((InputStream)is), this.maxInput);
    }

    public Optional<ParserMatch> getParserMatch() {
        if (Utils.nn(this.mediaType) && Utils.nn(this.parser)) {
            return Utils.opt(new ParserMatch(this.mediaType, this.parser));
        }
        MediaType mt = this.getMediaType();
        return Utils.opt(mt).map(x -> this.parsers.getParserMatch((MediaType)x));
    }

    public BufferedReader getReader() throws IOException {
        Reader r = this.getUnbufferedReader();
        if (r instanceof BufferedReader) {
            BufferedReader r2 = (BufferedReader)r;
            return r2;
        }
        int len = this.req.getHttpServletRequest().getContentLength();
        int buffSize = len <= 0 ? 8192 : Math.max(len, 8192);
        return new BufferedReader(r, buffSize);
    }

    public RequestContent maxInput(long value) {
        this.maxInput = value;
        return this;
    }

    public RequestContent mediaType(MediaType value) {
        this.mediaType = value;
        return this;
    }

    public RequestContent parser(Parser value) {
        this.parser = value;
        return this;
    }

    public RequestContent parsers(ParserSet value) {
        this.parsers = value;
        return this;
    }

    public RequestContent setSchema(HttpPartSchema schema) {
        this.schema = schema;
        return this;
    }

    private <T> ClassMeta<T> getClassMeta(Class<T> type) {
        return this.req.getBeanSession().getClassMeta(type);
    }

    private <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        return this.req.getBeanSession().getClassMeta(type, args);
    }

    private Encoder getEncoder() throws UnsupportedMediaType {
        if (this.encoder == null) {
            String ce = this.req.getHeaderParam("content-encoding").orElse(null);
            if (Utils.ne(ce)) {
                ce = ce.trim();
                this.encoder = this.encoders.getEncoder(ce);
                if (this.encoder == null) {
                    throw new UnsupportedMediaType("Unsupported encoding in request header ''Content-Encoding'': ''{0}''\n\tSupported codings: {1}", this.req.getHeaderParam("content-encoding").orElse(null), Json5.of(this.encoders.getSupportedEncodings()));
                }
            }
            if (Utils.nn(this.encoder)) {
                this.contentLength = -1;
            }
        }
        if (this.encoder == IdentityEncoder.INSTANCE) {
            return null;
        }
        return this.encoder;
    }

    private <T> T getInner(ClassMeta<T> cm) throws BadRequest, UnsupportedMediaType, InternalServerError {
        try {
            return this.parse(cm);
        }
        catch (UnsupportedMediaType e) {
            throw e;
        }
        catch (SchemaValidationException e) {
            throw new BadRequest("Validation failed on request content. " + ThrowableUtils.lm(e), new Object[0]);
        }
        catch (ParseException e) {
            throw new BadRequest(e, "Could not convert request content content to class type ''{0}''.", cm);
        }
        catch (IOException e) {
            throw new InternalServerError(e, "I/O exception occurred while parsing request content.", new Object[0]);
        }
        catch (Exception e) {
            throw new InternalServerError(e, "Exception occurred while parsing request content.", new Object[0]);
        }
    }

    private MediaType getMediaType() {
        if (Utils.nn(this.mediaType)) {
            return this.mediaType;
        }
        Optional<ContentType> ct = this.req.getHeader(ContentType.class);
        if (!ct.isPresent() && Utils.nn(this.content)) {
            return MediaType.UON;
        }
        return ct.isPresent() ? (MediaType)ct.get().asMediaType().orElse(null) : null;
    }

    private <T> T parse(ClassMeta<T> cm) throws SchemaValidationException, ParseException, UnsupportedMediaType, IOException {
        if (cm.isReader()) {
            return (T)this.getReader();
        }
        if (cm.isInputStream()) {
            return (T)this.getInputStream();
        }
        Optional<TimeZone> timeZone = this.req.getTimeZone();
        Locale locale = this.req.getLocale();
        ParserMatch pm = this.getParserMatch().orElse(null);
        if (this.schema == null) {
            this.schema = HttpPartSchema.DEFAULT;
        }
        if (Utils.nn(pm)) {
            Parser p = pm.getParser();
            MediaType mediaType = pm.getMediaType();
            ParserSession session = ((ParserSession.Builder)((ParserSession.Builder)p.createSession().properties((Map)this.req.getAttributes().asMap())).javaMethod(this.req.getOpContext().getJavaMethod()).locale(locale).timeZone(timeZone.orElse(null)).mediaType(mediaType).apply(ReaderParser.Builder.class, x -> x.streamCharset(this.req.getCharset()))).schema(this.schema).debug(this.req.isDebug() ? Boolean.valueOf(true) : null).outer(this.req.getContext().getResource()).build();
            try (Reader in = session.isReaderParser() ? this.getUnbufferedReader() : this.getInputStream();){
                T o = session.parse((Object)in, cm);
                if (Utils.nn(this.schema)) {
                    this.schema.validateOutput(o, cm.getBeanContext());
                }
                T t = o;
                return t;
            }
        }
        if (cm.hasReaderMutater()) {
            return cm.getReaderMutater().mutate(this.getReader());
        }
        if (cm.hasInputStreamMutater()) {
            return cm.getInputStreamMutater().mutate((InputStream)this.getInputStream());
        }
        MediaType mt = this.getMediaType();
        if ((StringUtils.isEmpty(Utils.s(mt)) || mt.toString().startsWith("text/plain")) && cm.hasStringMutater()) {
            return cm.getStringMutater().mutate(this.asString());
        }
        Optional<ContentType> ct = this.req.getHeader(ContentType.class);
        throw new UnsupportedMediaType("Unsupported media-type in request header ''Content-Type'': ''{0}''\n\tSupported media-types: {1}", ct.isPresent() ? ct.get().asMediaType().orElse(null) : "not-specified", Json5.of(this.req.getOpContext().getParsers().getSupportedMediaTypes()));
    }

    protected Reader getUnbufferedReader() throws IOException {
        if (Utils.nn(this.content)) {
            return new CharSequenceReader(new String(this.content, IoUtils.UTF8));
        }
        return new InputStreamReader((InputStream)this.getInputStream(), this.req.getCharset());
    }

    boolean isLoaded() {
        return Utils.nn(this.content);
    }
}

