/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.AnnotationProvider;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.ConfigException;
import org.apache.juneau.ContextSession;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.annotation.ContextApply;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.internal.Flag;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.SystemEnv;
import org.apache.juneau.internal.TwoKeyConcurrentCache;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.utils.HashKey;
import org.apache.juneau.utils.ReflectionMap;

public abstract class Context
implements AnnotationProvider {
    private static final Map<Class<?>, MethodInfo> BUILDER_CREATE_METHODS = new ConcurrentHashMap();
    public static final Predicate<AnnotationInfo<?>> CONTEXT_APPLY_FILTER = x -> x.hasAnnotation(ContextApply.class);
    final List<Annotation> annotations;
    final boolean debug;
    private final ReflectionMap<Annotation> annotationMap;
    private final TwoKeyConcurrentCache<Class<?>, Class<? extends Annotation>, Annotation[]> classAnnotationCache;
    private final TwoKeyConcurrentCache<Class<?>, Class<? extends Annotation>, Annotation[]> declaredClassAnnotationCache;
    private final TwoKeyConcurrentCache<Method, Class<? extends Annotation>, Annotation[]> methodAnnotationCache;
    private final TwoKeyConcurrentCache<Field, Class<? extends Annotation>, Annotation[]> fieldAnnotationCache;
    private final TwoKeyConcurrentCache<Constructor<?>, Class<? extends Annotation>, Annotation[]> constructorAnnotationCache;

    public static Builder createBuilder(Class<? extends Context> type) {
        try {
            MethodInfo mi = BUILDER_CREATE_METHODS.get(type);
            if (mi == null) {
                ClassInfo c = ClassInfo.of(type);
                for (ConstructorInfo ci : c.getPublicConstructors()) {
                    if (ci.matches(x -> x.hasNumParams(1) && !x.getParam(0).getParameterType().is(type)) && (mi = c.getPublicMethod(x -> x.isStatic() && x.isNotDeprecated() && x.hasName("create") && x.hasReturnType(ci.getParam(0).getParameterType()))) != null) break;
                }
                if (mi == null) {
                    throw new BasicRuntimeException("Could not find builder create method on class {0}", type);
                }
                BUILDER_CREATE_METHODS.put(type, mi);
            }
            Builder b = (Builder)mi.invoke(null, new Object[0]);
            b.type(type);
            return b;
        }
        catch (ExecutableException e) {
            throw ThrowableUtils.asRuntimeException((Throwable)e);
        }
    }

    protected Context(Context copyFrom) {
        this.annotationMap = copyFrom.annotationMap;
        this.annotations = copyFrom.annotations;
        this.debug = copyFrom.debug;
        this.classAnnotationCache = copyFrom.classAnnotationCache;
        this.declaredClassAnnotationCache = copyFrom.declaredClassAnnotationCache;
        this.methodAnnotationCache = copyFrom.methodAnnotationCache;
        this.fieldAnnotationCache = copyFrom.fieldAnnotationCache;
        this.constructorAnnotationCache = copyFrom.constructorAnnotationCache;
    }

    protected Context(Builder builder) {
        this.init(builder);
        this.debug = builder.debug;
        this.annotations = CollectionUtils.optional(builder.annotations).orElseGet(CollectionUtils::emptyList);
        ReflectionMap.Builder<Annotation> rmb = ReflectionMap.create(Annotation.class);
        this.annotations.forEach(a -> {
            try {
                ClassInfo ci = ClassInfo.of(a.getClass());
                MethodInfo mi = ci.getPublicMethod(x -> x.hasName("onClass"));
                if (mi != null) {
                    if (!mi.getReturnType().is(Class[].class)) {
                        throw new ConfigException("Invalid annotation @{0} used in BEAN_annotations property.  Annotation must define an onClass() method that returns a Class array.", a.getClass().getSimpleName());
                    }
                    for (Class c : (Class[])mi.accessible().invoke(a, new Object[0])) {
                        rmb.append(c.getName(), (Annotation)a);
                    }
                }
                if ((mi = ci.getPublicMethod(x -> x.hasName("on"))) != null) {
                    if (!mi.getReturnType().is(String[].class)) {
                        throw new ConfigException("Invalid annotation @{0} used in BEAN_annotations property.  Annotation must define an on() method that returns a String array.", a.getClass().getSimpleName());
                    }
                    for (String s : (String[])mi.accessible().invoke(a, new Object[0])) {
                        rmb.append(s, (Annotation)a);
                    }
                }
            }
            catch (Exception e) {
                throw new ConfigException(e, "Invalid annotation @{0} used in BEAN_annotations property.", ClassUtils.className(a));
            }
        });
        this.annotationMap = rmb.build();
        boolean disabled = Boolean.getBoolean("juneau.disableAnnotationCaching");
        this.classAnnotationCache = new TwoKeyConcurrentCache<Class, Class, Annotation[]>(disabled, (k1, k2) -> this.annotationMap.appendAll((Class<?>)k1, (Class<Annotation>)k2, (V[])k1.getAnnotationsByType(k2)));
        this.declaredClassAnnotationCache = new TwoKeyConcurrentCache<Class, Class, Annotation[]>(disabled, (k1, k2) -> this.annotationMap.appendAll((Class<?>)k1, (Class<Annotation>)k2, (V[])k1.getDeclaredAnnotationsByType(k2)));
        this.methodAnnotationCache = new TwoKeyConcurrentCache<Method, Class, Annotation[]>(disabled, (k1, k2) -> this.annotationMap.appendAll((Method)k1, (Class<Annotation>)k2, (V[])k1.getAnnotationsByType(k2)));
        this.fieldAnnotationCache = new TwoKeyConcurrentCache<Field, Class, Annotation[]>(disabled, (k1, k2) -> this.annotationMap.appendAll((Field)k1, (Class<Annotation>)k2, (V[])k1.getAnnotationsByType(k2)));
        this.constructorAnnotationCache = new TwoKeyConcurrentCache<Constructor, Class, Annotation[]>(disabled, (k1, k2) -> this.annotationMap.appendAll((Constructor<?>)k1, (Class<Annotation>)k2, (V[])k1.getAnnotationsByType(k2)));
    }

    protected void init(Builder builder) {
    }

    public Builder copy() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public ContextSession.Builder createSession() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public ContextSession getSession() {
        return this.createSession().build();
    }

    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public <A extends Annotation> void forEachAnnotation(Class<A> type, Class<?> onClass, Predicate<A> filter, Consumer<A> action) {
        if (type != null && onClass != null) {
            for (Annotation a : this.annotations(type, onClass)) {
                ConsumerUtils.consume(filter, action, a);
            }
        }
    }

    @Override
    public <A extends Annotation> A firstAnnotation(Class<A> type, Class<?> onClass, Predicate<A> filter) {
        if (type != null && onClass != null) {
            for (Annotation a : this.annotations(type, onClass)) {
                if (!ConsumerUtils.test(filter, a)) continue;
                return (A)a;
            }
        }
        return null;
    }

    @Override
    public <A extends Annotation> A lastAnnotation(Class<A> type, Class<?> onClass, Predicate<A> filter) {
        Annotation x = null;
        if (type != null && onClass != null) {
            for (Annotation a : this.annotations(type, onClass)) {
                if (!ConsumerUtils.test(filter, a)) continue;
                x = a;
            }
        }
        return (A)x;
    }

    @Override
    public <A extends Annotation> void forEachDeclaredAnnotation(Class<A> type, Class<?> onClass, Predicate<A> filter, Consumer<A> action) {
        if (type != null && onClass != null) {
            for (Annotation a : this.declaredAnnotations(type, onClass)) {
                ConsumerUtils.consume(filter, action, a);
            }
        }
    }

    @Override
    public <A extends Annotation> A firstDeclaredAnnotation(Class<A> type, Class<?> onClass, Predicate<A> filter) {
        if (type != null && onClass != null) {
            for (Annotation a : this.declaredAnnotations(type, onClass)) {
                if (!ConsumerUtils.test(filter, a)) continue;
                return (A)a;
            }
        }
        return null;
    }

    @Override
    public <A extends Annotation> A lastDeclaredAnnotation(Class<A> type, Class<?> onClass, Predicate<A> filter) {
        Annotation x = null;
        if (type != null && onClass != null) {
            for (Annotation a : this.declaredAnnotations(type, onClass)) {
                if (!ConsumerUtils.test(filter, a)) continue;
                x = a;
            }
        }
        return (A)x;
    }

    @Override
    public <A extends Annotation> void forEachAnnotation(Class<A> type, Method onMethod, Predicate<A> filter, Consumer<A> action) {
        if (type != null && onMethod != null) {
            for (Annotation a : this.annotations(type, onMethod)) {
                ConsumerUtils.consume(filter, action, a);
            }
        }
    }

    @Override
    public <A extends Annotation> A firstAnnotation(Class<A> type, Method onMethod, Predicate<A> filter) {
        if (type != null && onMethod != null) {
            for (Annotation a : this.annotations(type, onMethod)) {
                if (!ConsumerUtils.test(filter, a)) continue;
                return (A)a;
            }
        }
        return null;
    }

    @Override
    public <A extends Annotation> A lastAnnotation(Class<A> type, Method onMethod, Predicate<A> filter) {
        Annotation x = null;
        if (type != null && onMethod != null) {
            for (Annotation a : this.annotations(type, onMethod)) {
                if (!ConsumerUtils.test(filter, a)) continue;
                x = a;
            }
        }
        return (A)x;
    }

    @Override
    public <A extends Annotation> void forEachAnnotation(Class<A> type, Field onField, Predicate<A> filter, Consumer<A> action) {
        if (type != null && onField != null) {
            for (Annotation a : this.annotations(type, onField)) {
                ConsumerUtils.consume(filter, action, a);
            }
        }
    }

    @Override
    public <A extends Annotation> A firstAnnotation(Class<A> type, Field onField, Predicate<A> filter) {
        if (type != null && onField != null) {
            for (Annotation a : this.annotations(type, onField)) {
                if (!ConsumerUtils.test(filter, a)) continue;
                return (A)a;
            }
        }
        return null;
    }

    @Override
    public <A extends Annotation> A lastAnnotation(Class<A> type, Field onField, Predicate<A> filter) {
        Annotation x = null;
        if (type != null && onField != null) {
            for (Annotation a : this.annotations(type, onField)) {
                if (!ConsumerUtils.test(filter, a)) continue;
                x = a;
            }
        }
        return (A)x;
    }

    @Override
    public <A extends Annotation> void forEachAnnotation(Class<A> type, Constructor<?> onConstructor, Predicate<A> filter, Consumer<A> action) {
        if (type != null && onConstructor != null) {
            for (Annotation a : this.annotations(type, onConstructor)) {
                ConsumerUtils.consume(filter, action, a);
            }
        }
    }

    @Override
    public <A extends Annotation> A firstAnnotation(Class<A> type, Constructor<?> onConstructor, Predicate<A> filter) {
        if (type != null && onConstructor != null) {
            for (Annotation a : this.annotations(type, onConstructor)) {
                if (!ConsumerUtils.test(filter, a)) continue;
                return (A)a;
            }
        }
        return null;
    }

    @Override
    public <A extends Annotation> A lastAnnotation(Class<A> type, Constructor<?> onConstructor, Predicate<A> filter) {
        Annotation x = null;
        if (type != null && onConstructor != null) {
            for (Annotation a : this.annotations(type, onConstructor)) {
                if (!ConsumerUtils.test(filter, a)) continue;
                x = a;
            }
        }
        return (A)x;
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> type, Class<?> onClass) {
        return this.annotations(type, onClass).length > 0;
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> type, Method onMethod) {
        return this.annotations(type, onMethod).length > 0;
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> type, Field onField) {
        return this.annotations(type, onField).length > 0;
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> type, Constructor<?> onConstructor) {
        return this.annotations(type, onConstructor).length > 0;
    }

    private <A extends Annotation> A[] annotations(Class<A> type, Class<?> onClass) {
        return this.classAnnotationCache.get(onClass, type);
    }

    private <A extends Annotation> A[] declaredAnnotations(Class<A> type, Class<?> onClass) {
        return this.declaredClassAnnotationCache.get(onClass, type);
    }

    private <A extends Annotation> A[] annotations(Class<A> type, Method onMethod) {
        return this.methodAnnotationCache.get(onMethod, type);
    }

    private <A extends Annotation> A[] annotations(Class<A> type, Field onField) {
        return this.fieldAnnotationCache.get(onField, type);
    }

    private <A extends Annotation> A[] annotations(Class<A> type, Constructor<?> onConstructor) {
        return this.constructorAnnotationCache.get(onConstructor, type);
    }

    protected JsonMap properties() {
        return JsonMap.filteredMap("annotations", this.annotations, "debug", this.debug);
    }

    public String toString() {
        return ObjectUtils.toPropertyMap(this).asReadableString();
    }

    @FluentSetters
    public static abstract class Builder {
        private static final Map<Class<?>, ConstructorInfo> CONTEXT_CONSTRUCTORS = new ConcurrentHashMap();
        boolean debug;
        Class<? extends Context> type;
        Context impl;
        List<Annotation> annotations;
        Cache<HashKey, ? extends Context> cache;
        private final List<Object> builders = CollectionUtils.list(new Object[0]);
        private final AnnotationWorkList applied = AnnotationWorkList.create();

        protected Builder() {
            this.debug = this.env("Context.debug", false);
            this.annotations = null;
            this.registerBuilders(this);
            Class<?> dc = this.getClass().getDeclaringClass();
            if (Context.class.isAssignableFrom(dc)) {
                this.type(dc);
            }
        }

        protected Builder(Context copyFrom) {
            this.debug = copyFrom.debug;
            this.type = copyFrom.getClass();
            this.annotations = CollectionUtils.listFrom(copyFrom.annotations, true);
            this.registerBuilders(this);
        }

        protected Builder(Builder copyFrom) {
            this.debug = copyFrom.debug;
            this.type = copyFrom.type;
            this.annotations = CollectionUtils.listFrom(copyFrom.annotations, true);
            this.registerBuilders(this);
        }

        private Context innerBuild() {
            if (this.type == null) {
                throw new BasicRuntimeException("Type not specified for context builder {0}", this.getClass().getName());
            }
            if (this.impl != null && this.type.isInstance(this.impl)) {
                return this.type.cast(this.impl);
            }
            if (this.cache != null) {
                return this.cache.get(this.hashKey(), () -> (Context)this.getContextConstructor().invoke(this));
            }
            return (Context)this.getContextConstructor().invoke(this);
        }

        private ConstructorInfo getContextConstructor() {
            ConstructorInfo cci = CONTEXT_CONSTRUCTORS.get(this.type);
            if (cci == null) {
                cci = ClassInfo.of(this.type).getPublicConstructor(x -> x.hasNumParams(1) && x.getParam(0).canAccept(this));
                if (cci == null) {
                    throw new BasicRuntimeException("Public constructor not found: {0}({1})", ClassUtils.className(this.type), ClassUtils.className(this));
                }
                CONTEXT_CONSTRUCTORS.put(this.type, cci);
            }
            return cci;
        }

        public abstract Builder copy();

        public Context build() {
            return this.innerBuild();
        }

        public HashKey hashKey() {
            return HashKey.of(this.debug, this.type, this.annotations);
        }

        @FluentSetter
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            this.cache = value;
            return this;
        }

        public final <T extends Context> T build(Class<T> c) {
            if (this.type == null || !c.isAssignableFrom(this.type)) {
                this.type = c;
            }
            return (T)this.innerBuild();
        }

        public <T extends Builder> Builder apply(Class<T> subtype, Consumer<T> consumer) {
            if (subtype.isInstance(this)) {
                consumer.accept((Builder)subtype.cast(this));
            }
            return this;
        }

        @FluentSetter
        public Builder type(Class<? extends Context> value) {
            this.type = value;
            return this;
        }

        public Optional<Class<?>> getType() {
            return CollectionUtils.optional(this.type);
        }

        @FluentSetter
        public Builder impl(Context value) {
            this.impl = value;
            return this;
        }

        public boolean canApply(AnnotationWorkList work) {
            Flag f = Flag.create();
            work.forEach(x -> this.builders.forEach(b -> f.setIf(x.canApply(b))));
            return f.isSet();
        }

        @FluentSetter
        public Builder apply(AnnotationWorkList work) {
            this.applied.addAll(work);
            work.forEach(x -> this.builders.forEach(y -> x.apply(y)));
            return this;
        }

        public AnnotationWorkList getApplied() {
            return this.applied;
        }

        protected void registerBuilders(Object ... builders) {
            for (Object b : builders) {
                if (b == this) {
                    this.builders.add(b);
                    continue;
                }
                if (b instanceof Builder) {
                    this.builders.addAll(((Builder)b).builders);
                    continue;
                }
                this.builders.add(b);
            }
        }

        @FluentSetter
        public Builder applyAnnotations(Class<?> ... fromClasses) {
            AnnotationWorkList work = AnnotationWorkList.create();
            for (Class<?> c : fromClasses) {
                work.add(ClassInfo.of(c).getAnnotationList(CONTEXT_APPLY_FILTER));
            }
            return this.apply(work);
        }

        @FluentSetter
        public Builder applyAnnotations(Method ... fromMethods) {
            AnnotationWorkList work = AnnotationWorkList.create();
            for (Method m : fromMethods) {
                work.add(MethodInfo.of(m).getAnnotationList(CONTEXT_APPLY_FILTER));
            }
            return this.apply(work);
        }

        @FluentSetter
        public Builder annotations(Annotation ... values) {
            this.annotations = CollectionUtils.addAll(this.annotations, values);
            return this;
        }

        @FluentSetter
        public Builder debug() {
            return this.debug(true);
        }

        @FluentSetter
        public Builder debug(boolean value) {
            this.debug = value;
            return this;
        }

        public boolean isDebug() {
            return this.debug;
        }

        protected <T> T env(String name, T def) {
            return SystemEnv.env(name, def);
        }

        protected Optional<String> env(String name) {
            return SystemEnv.env(name);
        }
    }
}

