/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.pojotools;

import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.pojotools.Matcher;
import org.apache.juneau.pojotools.MatcherFactory;

public class StringMatcherFactory
extends MatcherFactory {
    public static final StringMatcherFactory DEFAULT = new StringMatcherFactory();

    @Override
    public boolean canMatch(ClassMeta<?> cm) {
        return true;
    }

    @Override
    public Matcher create(String pattern) {
        return new StringMatcher(pattern);
    }

    private static class StringMatcher
    extends Matcher {
        private String pattern;
        private static final AsciiSet META_CHARS = AsciiSet.create("*?'\"");
        private static final AsciiSet SQ_CHAR = AsciiSet.create("'");
        private static final AsciiSet DQ_CHAR = AsciiSet.create("\"");
        private static final AsciiSet REGEX_CHARS = AsciiSet.create("+\\[]{}()^$.");
        Pattern[] orPatterns;
        Pattern[] andPatterns;
        Pattern[] notPatterns;

        public StringMatcher(String searchPattern) {
            this.pattern = searchPattern.trim();
            LinkedList<Pattern> ors = new LinkedList<Pattern>();
            LinkedList<Pattern> ands = new LinkedList<Pattern>();
            LinkedList<Pattern> nots = new LinkedList<Pattern>();
            for (String s : StringUtils.splitQuoted(this.pattern, true)) {
                char c0 = s.charAt(0);
                char c9 = s.charAt(s.length() - 1);
                if (c0 == '/' && c9 == '/' && s.length() > 1) {
                    ands.add(Pattern.compile(StringUtils.strip(s)));
                    continue;
                }
                int prefix = 94;
                boolean ignoreCase = false;
                if (s.length() > 1 && (c0 == '^' || c0 == '+' || c0 == '-')) {
                    prefix = c0;
                    s = s.substring(1);
                    c0 = s.charAt(0);
                }
                if (c0 == '\'') {
                    s = StringUtils.unEscapeChars(StringUtils.strip(s), SQ_CHAR);
                    ignoreCase = true;
                } else if (c0 == '\"') {
                    s = StringUtils.unEscapeChars(StringUtils.strip(s), DQ_CHAR);
                }
                if (REGEX_CHARS.contains(s) || META_CHARS.contains(s)) {
                    StringBuilder sb = new StringBuilder();
                    boolean isInEscape = false;
                    for (int i = 0; i < s.length(); ++i) {
                        char c = s.charAt(i);
                        if (isInEscape) {
                            if (c == '?' || c == '*' || c == '\\') {
                                sb.append('\\').append(c);
                            } else {
                                sb.append(c);
                            }
                            isInEscape = false;
                            continue;
                        }
                        if (c == '\\') {
                            isInEscape = true;
                            continue;
                        }
                        if (c == '?') {
                            sb.append(".?");
                            continue;
                        }
                        if (c == '*') {
                            sb.append(".*");
                            continue;
                        }
                        if (REGEX_CHARS.contains(c)) {
                            sb.append("\\").append(c);
                            continue;
                        }
                        sb.append(c);
                    }
                    s = sb.toString();
                }
                int flags = 32;
                if (ignoreCase) {
                    flags |= 2;
                }
                Pattern p = Pattern.compile(s, flags);
                if (prefix == 45) {
                    nots.add(p);
                    continue;
                }
                if (prefix == 43) {
                    ands.add(p);
                    continue;
                }
                ors.add(p);
            }
            this.orPatterns = ors.toArray(new Pattern[ors.size()]);
            this.andPatterns = ands.toArray(new Pattern[ands.size()]);
            this.notPatterns = nots.toArray(new Pattern[nots.size()]);
        }

        @Override
        public boolean matches(ClassMeta<?> cm, Object o) {
            int i;
            String s = (String)o;
            for (i = 0; i < this.andPatterns.length; ++i) {
                if (this.andPatterns[i].matcher(s).matches()) continue;
                return false;
            }
            for (i = 0; i < this.notPatterns.length; ++i) {
                if (!this.notPatterns[i].matcher(s).matches()) continue;
                return false;
            }
            for (i = 0; i < this.orPatterns.length; ++i) {
                if (!this.orPatterns[i].matcher(s).matches()) continue;
                return true;
            }
            return this.orPatterns.length == 0;
        }

        public String toString() {
            return this.pattern;
        }
    }
}

