/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.encoders;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroupBuilder;
import org.apache.juneau.encoders.EncoderMatch;
import org.apache.juneau.encoders.GzipEncoder;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.http.AcceptEncoding;
import org.apache.juneau.internal.CollectionUtils;

public final class EncoderGroup {
    public static final EncoderGroup DEFAULT = EncoderGroup.create().append(IdentityEncoder.class, GzipEncoder.class).build();
    private final ConcurrentHashMap<String, EncoderMatch> cache = new ConcurrentHashMap();
    private final String[] encodings;
    private final List<String> encodingsList;
    private final Encoder[] encodingsEncoders;
    private final List<Encoder> encoders;

    public static EncoderGroupBuilder create() {
        return new EncoderGroupBuilder();
    }

    public EncoderGroupBuilder builder() {
        return new EncoderGroupBuilder(this);
    }

    public EncoderGroup(Encoder[] encoders) {
        this.encoders = CollectionUtils.immutableList(encoders);
        ArrayList<String> lc = new ArrayList<String>();
        ArrayList<Encoder> l = new ArrayList<Encoder>();
        for (Encoder e : encoders) {
            for (String c : e.getCodings()) {
                lc.add(c);
                l.add(e);
            }
        }
        this.encodings = lc.toArray(new String[lc.size()]);
        this.encodingsList = CollectionUtils.unmodifiableList(lc);
        this.encodingsEncoders = l.toArray(new Encoder[l.size()]);
    }

    public EncoderMatch getEncoderMatch(String acceptEncoding) {
        EncoderMatch em = this.cache.get(acceptEncoding);
        if (em != null) {
            return em;
        }
        AcceptEncoding ae = AcceptEncoding.forString(acceptEncoding);
        int match = ae.findMatch(this.encodings);
        if (match >= 0) {
            em = new EncoderMatch(this.encodings[match], this.encodingsEncoders[match]);
            this.cache.putIfAbsent(acceptEncoding, em);
        }
        return this.cache.get(acceptEncoding);
    }

    public Encoder getEncoder(String encoding) {
        EncoderMatch em = this.getEncoderMatch(encoding);
        return em == null ? null : em.getEncoder();
    }

    public List<String> getSupportedEncodings() {
        return this.encodingsList;
    }

    public List<Encoder> getEncoders() {
        return this.encoders;
    }
}

