/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.PojoSwap;

public class AutoNumberSwap<T>
extends PojoSwap<T, Number> {
    private static final Set<String> SWAP_METHOD_NAMES = CollectionUtils.newUnmodifiableHashSet("toNumber", "toInteger", "toInt", "toLong", "toFloat", "toDouble", "toShort", "toByte");
    private static final Set<String> UNSWAP_METHOD_NAMES = CollectionUtils.newUnmodifiableHashSet("fromInteger", "fromInt", "fromLong", "fromFloat", "fromDouble", "fromShort", "fromByte", "create", "valueOf");
    private final Method swapMethod;
    private final Method unswapMethod;
    private final Constructor<?> unswapConstructor;
    private final Class<?> unswapType;

    public static PojoSwap<?, ?> find(BeanContext bc, ClassInfo ci) {
        if (AutoNumberSwap.shouldIgnore(bc, ci)) {
            return null;
        }
        for (MethodInfo m : ci.getPublicMethods()) {
            if (!AutoNumberSwap.isSwapMethod(bc, m)) continue;
            ClassInfo rt = m.getReturnType();
            for (MethodInfo m2 : ci.getPublicMethods()) {
                if (!AutoNumberSwap.isUnswapMethod(bc, m2, ci, rt)) continue;
                return new AutoNumberSwap(ci, m, m2, null);
            }
            for (ConstructorInfo cs : ci.getPublicConstructors()) {
                if (!AutoNumberSwap.isUnswapConstructor(bc, cs, rt)) continue;
                return new AutoNumberSwap(ci, m, null, cs);
            }
            return new AutoNumberSwap(ci, m, null, null);
        }
        return null;
    }

    private static boolean shouldIgnore(BeanContext bc, ClassInfo ci) {
        return bc.hasAnnotation(BeanIgnore.class, ci) || ci.isNonStaticMemberClass() || ci.isPrimitive() || ci.isChildOf(Number.class);
    }

    private static boolean isSwapMethod(BeanContext bc, MethodInfo mi) {
        ClassInfo rt = mi.getReturnType();
        return mi.isNotDeprecated() && mi.isNotStatic() && (rt.isChildOf(Number.class) || rt.isPrimitive() && rt.isAny(Integer.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE)) && mi.hasName(SWAP_METHOD_NAMES) && mi.hasFuzzyParamTypes(BeanSession.class) && !bc.hasAnnotation(BeanIgnore.class, mi);
    }

    private static boolean isUnswapMethod(BeanContext bc, MethodInfo mi, ClassInfo ci, ClassInfo rt) {
        return mi.isNotDeprecated() && mi.isStatic() && mi.hasName(UNSWAP_METHOD_NAMES) && mi.hasFuzzyParamTypes(BeanSession.class, rt.inner()) && mi.hasReturnTypeParent(ci) && !bc.hasAnnotation(BeanIgnore.class, mi);
    }

    private static boolean isUnswapConstructor(BeanContext bc, ConstructorInfo cs, ClassInfo rt) {
        return cs.isNotDeprecated() && cs.hasParamTypeParents(rt) && !bc.hasAnnotation(BeanIgnore.class, cs);
    }

    private AutoNumberSwap(ClassInfo ci, MethodInfo swapMethod, MethodInfo unswapMethod, ConstructorInfo unswapConstructor) {
        super(ci.inner(), swapMethod.inner().getReturnType());
        this.swapMethod = swapMethod.inner();
        this.unswapMethod = unswapMethod == null ? null : unswapMethod.inner();
        this.unswapConstructor = unswapConstructor == null ? null : unswapConstructor.inner();
        Class<?> unswapType = null;
        if (unswapMethod != null) {
            for (ParamInfo pi : unswapMethod.getParams()) {
                if (pi.getParameterType().is(BeanSession.class)) continue;
                unswapType = pi.getParameterType().getWrapperIfPrimitive();
            }
        } else if (unswapConstructor != null) {
            for (ParamInfo pi : unswapConstructor.getParams()) {
                if (pi.getParameterType().is(BeanSession.class)) continue;
                unswapType = pi.getParameterType().getWrapperIfPrimitive();
            }
        }
        this.unswapType = unswapType;
    }

    @Override
    public Number swap(BeanSession session, Object o) throws SerializeException {
        try {
            return (Number)this.swapMethod.invoke(o, ClassUtils.getMatchingArgs(this.swapMethod.getParameterTypes(), session));
        }
        catch (Exception e) {
            throw SerializeException.create(e);
        }
    }

    @Override
    public T unswap(BeanSession session, Number o, ClassMeta<?> hint) throws ParseException {
        try {
            Object o2 = ObjectUtils.toType(o, this.unswapType);
            if (this.unswapMethod != null) {
                return (T)this.unswapMethod.invoke(null, ClassUtils.getMatchingArgs(this.unswapMethod.getParameterTypes(), session, o2));
            }
            if (this.unswapConstructor != null) {
                return (T)this.unswapConstructor.newInstance(o2);
            }
            return super.unswap(session, o, hint);
        }
        catch (Exception e) {
            throw ParseException.create(e);
        }
    }
}

