/*
 * Decompiled with CFR 0.152.
 */
package org.freshcookies.security.policy;

import java.io.FilePermission;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.AuthPermission;
import javax.security.auth.kerberos.KerberosPrincipal;
import junit.framework.TestCase;
import org.freshcookies.security.policy.GenericPrincipal;
import org.freshcookies.security.policy.LocalPolicy;
import org.freshcookies.security.policy.SecurityTokenFactory;

public class SecurityTokenFactoryTest
extends TestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void testRegexJavaType() {
        Pattern p2 = Pattern.compile("((?:[a-zA-Z0-9$_]+\\.)*[A-Z$_][a-zA-Z0-9$_]*)");
        Matcher m = p2.matcher("java.util.PropertyPermission");
        SecurityTokenFactoryTest.assertTrue((boolean)m.matches());
        SecurityTokenFactoryTest.assertEquals((String)"java.util.PropertyPermission", (String)m.group(1));
        m = p2.matcher("PropertyPermission");
        SecurityTokenFactoryTest.assertTrue((boolean)m.matches());
        SecurityTokenFactoryTest.assertEquals((String)"PropertyPermission", (String)m.group(1));
        m = p2.matcher("PropertyPermission$1");
        SecurityTokenFactoryTest.assertTrue((boolean)m.matches());
        SecurityTokenFactoryTest.assertEquals((String)"PropertyPermission$1", (String)m.group(1));
        m = p2.matcher("propertyPermission");
        SecurityTokenFactoryTest.assertFalse((boolean)m.matches());
        m = p2.matcher("Property&Permission");
        SecurityTokenFactoryTest.assertFalse((boolean)m.matches());
        m = p2.matcher("$Property&Permission");
        SecurityTokenFactoryTest.assertFalse((boolean)m.matches());
    }

    public void testRegexPermission() {
        String p = "java.util.PropertyPermission \"java.security.auth.login.config\", \"write\"";
        Matcher m = SecurityTokenFactory.PERMISSION_PATTERN.matcher(p);
        SecurityTokenFactoryTest.assertTrue((boolean)m.matches());
        SecurityTokenFactoryTest.assertEquals((String)"java.util.PropertyPermission", (String)m.group(1));
        SecurityTokenFactoryTest.assertEquals((String)"java.security.auth.login.config", (String)m.group(2));
        SecurityTokenFactoryTest.assertEquals((String)"write", (String)m.group(3));
        p = "java.security.SecurityPermission \"getPolicy\"";
        m = SecurityTokenFactory.PERMISSION_PATTERN.matcher(p);
        SecurityTokenFactoryTest.assertTrue((boolean)m.matches());
        SecurityTokenFactoryTest.assertEquals((String)"java.security.SecurityPermission", (String)m.group(1));
        SecurityTokenFactoryTest.assertEquals((String)"getPolicy", (String)m.group(2));
        SecurityTokenFactoryTest.assertEquals(null, (String)m.group(3));
        p = "com.ecyrd.jspwiki.auth.permissions.AllPermission \"JSPWiki\"";
        m = SecurityTokenFactory.PERMISSION_PATTERN.matcher(p);
        SecurityTokenFactoryTest.assertTrue((boolean)m.matches());
        SecurityTokenFactoryTest.assertEquals((String)"com.ecyrd.jspwiki.auth.permissions.AllPermission", (String)m.group(1));
        SecurityTokenFactoryTest.assertEquals((String)"JSPWiki", (String)m.group(2));
        SecurityTokenFactoryTest.assertEquals(null, (String)m.group(3));
        p = "java.security.AllPermission";
        m = SecurityTokenFactory.PERMISSION_PATTERN.matcher(p);
        SecurityTokenFactoryTest.assertTrue((boolean)m.matches());
        SecurityTokenFactoryTest.assertEquals((String)"java.security.AllPermission", (String)m.group(1));
        SecurityTokenFactoryTest.assertEquals(null, (String)m.group(2));
        SecurityTokenFactoryTest.assertEquals(null, (String)m.group(3));
        p = "java.security.AllPermission foo";
        m = SecurityTokenFactory.PERMISSION_PATTERN.matcher(p);
        SecurityTokenFactoryTest.assertFalse((boolean)m.matches());
        p = "java.security.AllPermission \"foo\" bar";
        m = SecurityTokenFactory.PERMISSION_PATTERN.matcher(p);
        SecurityTokenFactoryTest.assertFalse((boolean)m.matches());
    }

    public void testFindPrincipal() throws MalformedURLException {
        SecurityTokenFactory tokenFactory = new SecurityTokenFactory(new URL[0]);
        Principal p = tokenFactory.getPrincipal("javax.security.auth.kerberos.KerberosPrincipal \"Ernesto@example.com\"");
        SecurityTokenFactoryTest.assertEquals((Object)new KerberosPrincipal("Ernesto@example.com"), (Object)p);
        p = tokenFactory.getPrincipal("org.freshcookies.security.policy.GenericPrincipal \"Fred\"");
        SecurityTokenFactoryTest.assertEquals((Object)new GenericPrincipal("Fred"), (Object)p);
        p = tokenFactory.getPrincipal("\"Pope Gregory\"");
        SecurityTokenFactoryTest.assertEquals((Object)new LocalPolicy.AnyPrincipal("Pope Gregory"), (Object)p);
        p = tokenFactory.getPrincipal("com.ecyrd.jspwiki.auth.WikiPrincipal \"Horatio Alger\"");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.freshcookies.security.policy.UnresolvedPrincipal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SecurityTokenFactoryTest.assertEquals((Object)clazz, p.getClass());
        SecurityTokenFactoryTest.assertEquals((String)"Horatio Alger", (String)p.getName());
        final URL url = new URL("file:ext/JSPWiki.jar");
        tokenFactory = (SecurityTokenFactory)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new SecurityTokenFactory(new URL[]{url});
            }
        });
        p = tokenFactory.getPrincipal("com.ecyrd.jspwiki.auth.WikiPrincipal \"Horatio Alger\"");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.freshcookies.security.policy.UnresolvedPrincipal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SecurityTokenFactoryTest.assertNotSame((Object)clazz2, p.getClass());
        SecurityTokenFactoryTest.assertEquals((String)"Horatio Alger", (String)p.getName());
    }

    public void testFindPermission() throws MalformedURLException, ClassNotFoundException {
        SecurityTokenFactory factory = new SecurityTokenFactory(new URL[0]);
        Permission p = factory.getPermission("javax.security.auth.AuthPermission \"setLoginConfiguration\"");
        SecurityTokenFactoryTest.assertEquals((Object)new AuthPermission("setLoginConfiguration"), (Object)p);
        p = factory.getPermission("java.io.FilePermission \"/Users/arj/\", \"read\"");
        SecurityTokenFactoryTest.assertEquals((Object)new FilePermission("/Users/arj/", "read"), (Object)p);
        p = factory.getPermission("java.io.FilePermission");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.security.UnresolvedPermission");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SecurityTokenFactoryTest.assertEquals((Object)clazz, p.getClass());
        p = factory.getPermission("com.ecyrd.jspwiki.auth.permissions.PagePermission \"*:Main\",\"view\"");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.security.UnresolvedPermission");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SecurityTokenFactoryTest.assertEquals((Object)clazz2, p.getClass());
        SecurityTokenFactoryTest.assertEquals((String)"com.ecyrd.jspwiki.auth.permissions.PagePermission", (String)p.getName());
        SecurityTokenFactoryTest.assertEquals((String)"", (String)p.getActions());
        final URL url = new URL("file:ext/JSPWiki.jar");
        factory = (SecurityTokenFactory)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new SecurityTokenFactory(new URL[]{url});
            }
        });
        p = factory.getPermission("com.ecyrd.jspwiki.auth.permissions.PagePermission \"*:Main\",\"view\"");
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("java.security.UnresolvedPermission");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SecurityTokenFactoryTest.assertNotSame((Object)clazz3, p.getClass());
        SecurityTokenFactoryTest.assertEquals((String)"*:Main", (String)p.getName());
        SecurityTokenFactoryTest.assertEquals((String)"view", (String)p.getActions());
    }
}

