/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error.level;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ErrorLevel
implements IErrorLevel {
    private final String m_sID;
    private final int m_nNumericLevel;

    public ErrorLevel(@Nonnull @Nonempty String string, @Nonnegative int n) {
        this.m_sID = ValueEnforcer.notEmpty(string, "ID");
        this.m_nNumericLevel = n;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnegative
    public int getNumericLevel() {
        return this.m_nNumericLevel;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ErrorLevel errorLevel = (ErrorLevel)object;
        return this.m_sID.equals(errorLevel.m_sID) && this.m_nNumericLevel == errorLevel.m_nNumericLevel;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sID).append(this.m_nNumericLevel).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).append("numericLevel", this.m_nNumericLevel).getToString();
    }
}

