/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.Visualizer;

public class ResultCollectorHelper {
    private final Visualizer visualizer;
    private final boolean errorsOnly;
    private final boolean successOnly;

    public ResultCollectorHelper(ResultCollector resultCollector, Visualizer visualizer) {
        this.visualizer = visualizer;
        this.errorsOnly = resultCollector.isErrorLogging();
        this.successOnly = resultCollector.isSuccessOnlyLogging();
    }

    public void add(SampleResult sample) {
        if (ResultCollector.isSampleWanted(sample.isSuccessful(), this.errorsOnly, this.successOnly)) {
            this.visualizer.add(sample);
        }
    }
}

