/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.JLabeledRadioI18N;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.protocol.jms.control.gui.JMSPropertiesPanel;
import org.apache.jmeter.protocol.jms.sampler.JMSProperties;
import org.apache.jmeter.protocol.jms.sampler.PublisherSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledPasswordField;
import org.apache.jorphan.gui.JLabeledTextField;

@TestElementMetadata(labelResource="jms_publisher")
public class JMSPublisherGui
extends AbstractSamplerGui
implements ChangeListener {
    private static final long serialVersionUID = 241L;
    public static final String USE_FILE_RSC = "jms_use_file";
    public static final String USE_RANDOM_RSC = "jms_use_random_file";
    public static final String USE_TEXT_RSC = "jms_use_text";
    public static final String TEXT_MSG_RSC = "jms_text_message";
    public static final String MAP_MSG_RSC = "jms_map_message";
    public static final String OBJECT_MSG_RSC = "jms_object_message";
    public static final String BYTES_MSG_RSC = "jms_bytes_message";
    private static final String[] CONFIG_ITEMS_BYTES_MSG = new String[]{"jms_use_file", "jms_use_random_file"};
    private static final String[] CONFIG_ITEMS = new String[]{"jms_use_text", "jms_use_file", "jms_use_random_file"};
    private static final String[] MSGTYPES_ITEMS = new String[]{"jms_text_message", "jms_map_message", "jms_object_message", "jms_bytes_message"};
    private final JCheckBox useProperties = new JCheckBox(JMeterUtils.getResString((String)"jms_use_properties_file"), false);
    private final JLabeledRadioI18N configChoice = new JLabeledRadioI18N("jms_config", CONFIG_ITEMS, "jms_use_text");
    private final JTextField jndiICF = new JTextField();
    private final JTextField urlField = new JTextField();
    private final JTextField jndiConnFac = new JTextField();
    private final JTextField jmsDestination = new JTextField();
    private final JLabeledTextField expiration = new JLabeledTextField(JMeterUtils.getResString((String)"jms_expiration"), 10);
    private final JTextField jmsErrorReconnectOnCodes = new JTextField();
    private final JLabeledTextField priority = new JLabeledTextField(JMeterUtils.getResString((String)"jms_priority"), 1);
    private final JCheckBox useAuth = new JCheckBox(JMeterUtils.getResString((String)"jms_use_auth"), false);
    private final JLabeledTextField jmsUser = new JLabeledTextField(JMeterUtils.getResString((String)"jms_user"));
    private final JLabeledTextField jmsPwd = new JLabeledPasswordField(JMeterUtils.getResString((String)"jms_pwd"));
    private final JTextField iterations = new JTextField();
    private final FilePanel messageFile = new FilePanel(JMeterUtils.getResString((String)"jms_file"));
    private final FilePanel randomFile = new FilePanel(JMeterUtils.getResString((String)"jms_random_file"), true);
    private final JSyntaxTextArea textMessage = JSyntaxTextArea.getInstance((int)10, (int)50);
    private final JLabeledRadioI18N msgChoice = new JLabeledRadioI18N("jms_message_type", MSGTYPES_ITEMS, "jms_text_message");
    private JComboBox<String> fileEncoding;
    private final JCheckBox useNonPersistentDelivery = new JCheckBox(JMeterUtils.getResString((String)"jms_use_non_persistent_delivery"), false);
    private static final String DEST_SETUP_STATIC = "jms_dest_setup_static";
    private static final String DEST_SETUP_DYNAMIC = "jms_dest_setup_dynamic";
    private static final String[] DEST_SETUP_ITEMS = new String[]{"jms_dest_setup_static", "jms_dest_setup_dynamic"};
    private final JLabeledRadioI18N destSetup = new JLabeledRadioI18N("jms_dest_setup", DEST_SETUP_ITEMS, "jms_dest_setup_static");
    private JMSPropertiesPanel jmsPropertiesPanel;

    public JMSPublisherGui() {
        this.init();
    }

    public String getLabelResource() {
        return "jms_publisher";
    }

    public TestElement createTestElement() {
        PublisherSampler sampler = new PublisherSampler();
        this.setupSamplerProperties(sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement s) {
        PublisherSampler sampler = (PublisherSampler)s;
        this.setupSamplerProperties(sampler);
        sampler.setDestinationStatic(this.destSetup.getText().equals(DEST_SETUP_STATIC));
    }

    private void setupSamplerProperties(PublisherSampler sampler) {
        super.configureTestElement((TestElement)sampler);
        sampler.setUseJNDIProperties(String.valueOf(this.useProperties.isSelected()));
        sampler.setJNDIIntialContextFactory(this.jndiICF.getText());
        sampler.setProviderUrl(this.urlField.getText());
        sampler.setConnectionFactory(this.jndiConnFac.getText());
        sampler.setDestination(this.jmsDestination.getText());
        sampler.setExpiration(this.expiration.getText());
        sampler.setReconnectionErrorCodes(this.jmsErrorReconnectOnCodes.getText());
        sampler.setPriority(this.priority.getText());
        sampler.setUsername(this.jmsUser.getText());
        sampler.setPassword(this.jmsPwd.getText());
        sampler.setTextMessage(this.textMessage.getText());
        sampler.setInputFile(this.messageFile.getFilename());
        sampler.setRandomPath(this.randomFile.getFilename());
        sampler.setConfigChoice(this.configChoice.getText());
        Object item = this.fileEncoding.getSelectedItem();
        if (item == null) {
            sampler.setFileEncoding("");
        } else {
            sampler.setFileEncoding((String)item);
        }
        sampler.setMessageChoice(this.msgChoice.getText());
        sampler.setIterations(this.iterations.getText());
        sampler.setUseAuth(this.useAuth.isSelected());
        sampler.setUseNonPersistentDelivery(this.useNonPersistentDelivery.isSelected());
        JMSProperties args = (JMSProperties)this.jmsPropertiesPanel.createTestElement();
        sampler.setJMSProperties(args);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 3, insets 0", "[][fill,grow]"));
        this.add(mainPanel, "Center");
        mainPanel.add((Component)this.useProperties, "span");
        mainPanel.add(JMeterUtils.labelFor((Component)this.jndiICF, (String)"jms_initial_context_factory"));
        mainPanel.add((Component)this.jndiICF, "span, growx");
        mainPanel.add(JMeterUtils.labelFor((Component)this.urlField, (String)"jms_provider_url"));
        mainPanel.add((Component)this.urlField, "span, growx");
        mainPanel.add(this.useAuth);
        mainPanel.add((Component)this.jmsUser);
        mainPanel.add((Component)this.jmsPwd);
        mainPanel.add(JMeterUtils.labelFor((Component)this.jndiConnFac, (String)"jms_connection_factory"));
        mainPanel.add((Component)this.jndiConnFac, "span, growx");
        mainPanel.add(JMeterUtils.labelFor((Component)this.jmsDestination, (String)"jms_topic"));
        mainPanel.add(this.jmsDestination);
        mainPanel.add((Component)this.destSetup);
        mainPanel.add(this.useNonPersistentDelivery);
        mainPanel.add((Component)this.expiration);
        mainPanel.add((Component)this.priority);
        this.jmsPropertiesPanel = new JMSPropertiesPanel();
        mainPanel.add((Component)this.jmsPropertiesPanel, "span, growx");
        mainPanel.add((Component)this.msgChoice, "span");
        this.fileEncoding = new JComboBox<String>(PublisherSampler.getSupportedEncodings());
        this.fileEncoding.setEditable(true);
        mainPanel.add(JMeterUtils.labelFor(this.fileEncoding, (String)"content_encoding"));
        mainPanel.add(this.fileEncoding, "span, growx");
        mainPanel.add((Component)this.configChoice, "span");
        mainPanel.add((Component)JMeterUtils.labelFor((Component)this.textMessage, (String)"jms_text_area"), "span");
        mainPanel.add((Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.textMessage), "span, growx");
        mainPanel.add((Component)this.messageFile, "span, growx");
        mainPanel.add((Component)this.randomFile, "span, growx");
        mainPanel.add(JMeterUtils.labelFor((Component)this.jmsErrorReconnectOnCodes, (String)"jms_error_reconnect_on_codes"));
        mainPanel.add((Component)this.jmsErrorReconnectOnCodes, "span, growx");
        mainPanel.add(JMeterUtils.labelFor((Component)this.iterations, (String)"jms_itertions"));
        mainPanel.add((Component)this.iterations, "span, growx");
        this.useProperties.addChangeListener(this);
        this.useAuth.addChangeListener(this);
        this.configChoice.addChangeListener((ChangeListener)this);
        this.msgChoice.addChangeListener((ChangeListener)this);
    }

    public void clearGui() {
        super.clearGui();
        this.useProperties.setSelected(false);
        this.jndiICF.setText("");
        this.urlField.setText("");
        this.jndiConnFac.setText("");
        this.jmsDestination.setText("");
        this.expiration.setText("");
        this.jmsErrorReconnectOnCodes.setText("");
        this.priority.setText("");
        this.jmsUser.setText("");
        this.jmsPwd.setText("");
        this.textMessage.setInitialText("");
        this.messageFile.setFilename("");
        this.randomFile.setFilename("");
        this.msgChoice.setText("");
        this.fileEncoding.setSelectedIndex(0);
        this.configChoice.setText(USE_TEXT_RSC);
        this.updateConfig(USE_TEXT_RSC);
        this.msgChoice.setText(TEXT_MSG_RSC);
        this.iterations.setText("1");
        this.useAuth.setSelected(false);
        this.jmsUser.setEnabled(false);
        this.jmsPwd.setEnabled(false);
        this.destSetup.setText(DEST_SETUP_STATIC);
        this.useNonPersistentDelivery.setSelected(false);
        this.jmsPropertiesPanel.clearGui();
    }

    public void configure(TestElement el) {
        super.configure(el);
        PublisherSampler sampler = (PublisherSampler)el;
        this.useProperties.setSelected(sampler.getUseJNDIPropertiesAsBoolean());
        this.jndiICF.setText(sampler.getJNDIInitialContextFactory());
        this.urlField.setText(sampler.getProviderUrl());
        this.jndiConnFac.setText(sampler.getConnectionFactory());
        this.jmsDestination.setText(sampler.getDestination());
        this.jmsUser.setText(sampler.getUsername());
        this.jmsPwd.setText(sampler.getPassword());
        this.textMessage.setInitialText(sampler.getTextMessage());
        this.textMessage.setCaretPosition(0);
        this.messageFile.setFilename(sampler.getInputFile());
        this.randomFile.setFilename(sampler.getRandomPath());
        this.configChoice.setText(sampler.getConfigChoice());
        this.msgChoice.setText(sampler.getMessageChoice());
        this.fileEncoding.setSelectedItem(sampler.getFileEncoding());
        this.iterations.setText(sampler.getIterations());
        this.expiration.setText(sampler.getExpiration());
        this.jmsErrorReconnectOnCodes.setText(sampler.getReconnectionErrorCodes());
        this.priority.setText(sampler.getPriority());
        this.useAuth.setSelected(sampler.isUseAuth());
        this.jmsUser.setEnabled(this.useAuth.isSelected());
        this.jmsPwd.setEnabled(this.useAuth.isSelected());
        this.destSetup.setText(sampler.isDestinationStatic() ? DEST_SETUP_STATIC : DEST_SETUP_DYNAMIC);
        this.useNonPersistentDelivery.setSelected(sampler.getUseNonPersistentDelivery());
        this.jmsPropertiesPanel.configure((TestElement)sampler.getJMSProperties());
        this.updateChoice(this.msgChoice.getText());
        this.updateConfig(sampler.getConfigChoice());
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.configChoice) {
            this.updateConfig(this.configChoice.getText());
        } else if (event.getSource() == this.msgChoice) {
            this.updateChoice(this.msgChoice.getText());
        } else if (event.getSource() == this.useProperties) {
            boolean isUseProperties = this.useProperties.isSelected();
            this.jndiICF.setEnabled(!isUseProperties);
            this.urlField.setEnabled(!isUseProperties);
            this.useAuth.setEnabled(!isUseProperties);
        } else if (event.getSource() == this.useAuth) {
            this.jmsUser.setEnabled(this.useAuth.isSelected() && this.useAuth.isEnabled());
            this.jmsPwd.setEnabled(this.useAuth.isSelected() && this.useAuth.isEnabled());
        }
    }

    private void updateFileEncoding() {
        boolean isTextMode = USE_TEXT_RSC.equals(this.configChoice.getText());
        boolean isObjectType = OBJECT_MSG_RSC.equals(this.msgChoice.getText());
        this.fileEncoding.setEnabled(!isTextMode && !isObjectType);
    }

    private void updateChoice(String command) {
        String oldChoice = this.configChoice.getText();
        if (BYTES_MSG_RSC.equals(command)) {
            String newChoice = USE_TEXT_RSC.equals(oldChoice) ? USE_FILE_RSC : oldChoice;
            this.configChoice.resetButtons(CONFIG_ITEMS_BYTES_MSG, newChoice);
            this.textMessage.setEnabled(false);
        } else {
            this.configChoice.resetButtons(CONFIG_ITEMS, oldChoice);
            this.textMessage.setEnabled(true);
        }
        this.updateFileEncoding();
        this.validate();
    }

    private void updateConfig(String command) {
        if (command.equals(USE_TEXT_RSC)) {
            this.textMessage.setEnabled(true);
            this.messageFile.enableFile(false);
            this.randomFile.enableFile(false);
        } else if (command.equals(USE_RANDOM_RSC)) {
            this.textMessage.setEnabled(false);
            this.messageFile.enableFile(false);
            this.randomFile.enableFile(true);
        } else {
            this.textMessage.setEnabled(false);
            this.messageFile.enableFile(true);
            this.randomFile.enableFile(false);
        }
        this.updateFileEncoding();
    }
}

