/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.graphite;

import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.jmeter.visualizers.backend.graphite.GraphiteMetricsSender;
import org.apache.jmeter.visualizers.backend.graphite.SocketConnectionInfos;
import org.apache.jmeter.visualizers.backend.graphite.SocketOutputStream;
import org.apache.jmeter.visualizers.backend.graphite.SocketOutputStreamPoolFactory;

abstract class AbstractGraphiteMetricsSender
implements GraphiteMetricsSender {
    AbstractGraphiteMetricsSender() {
    }

    protected GenericKeyedObjectPool<SocketConnectionInfos, SocketOutputStream> createSocketOutputStreamPool() {
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        config.setMaxTotalPerKey(-1);
        config.setMaxTotal(-1);
        config.setMaxIdlePerKey(-1);
        config.setMinEvictableIdleDuration(Duration.ofMinutes(3L));
        config.setTimeBetweenEvictionRuns(Duration.ofMinutes(3L));
        return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SocketOutputStreamPoolFactory(1000, 1000), config);
    }

    static String sanitizeString(String s) {
        return StringUtils.replaceChars((String)s, (String)"\\ .", (String)"--_");
    }
}

