/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\tR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/Contour;", "", "()V", "dataFrame", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "getDataFrame", "()Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "myContourGroup", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "myContourLevel", "myContourX", "myContourY", "myGroup", "add", "", "polygon", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "fillLevel", "Companion", "plot-base"})
public final class Contour {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<Double> myContourX = new ArrayList();
    @NotNull
    private final ArrayList<Double> myContourY = new ArrayList();
    @NotNull
    private final ArrayList<Double> myContourLevel = new ArrayList();
    @NotNull
    private final ArrayList<Double> myContourGroup = new ArrayList();
    private double myGroup;

    private Contour() {
    }

    private final DataFrame getDataFrame() {
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), (List<Double>)this.myContourX).putNumeric(Stats.INSTANCE.getY(), (List<Double>)this.myContourY).putNumeric(Stats.INSTANCE.getLEVEL(), (List<Double>)this.myContourLevel).putNumeric(Stats.INSTANCE.getGROUP(), (List<Double>)this.myContourGroup).build();
    }

    public final void add(@NotNull List<DoubleVector> polygon, double fillLevel) {
        Intrinsics.checkNotNullParameter(polygon, (String)"polygon");
        for (DoubleVector p : polygon) {
            this.myContourX.add(p.getX());
            this.myContourY.add(p.getY());
            this.myContourLevel.add(fillLevel);
            this.myContourGroup.add(this.myGroup);
        }
        this.myGroup += 1.0;
    }

    public /* synthetic */ Contour(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u001e\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\u00060\tJ.\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/Contour$Companion;", "", "()V", "getPathDataFrame", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "levels", "", "", "pathListByLevel", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getPolygonDataFrame", "fillLevels", "polygonListByFillLevel", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataFrame getPathDataFrame(@NotNull List<Double> levels, @NotNull Map<Double, ? extends List<? extends List<DoubleVector>>> pathListByLevel) {
            Intrinsics.checkNotNullParameter(levels, (String)"levels");
            Intrinsics.checkNotNullParameter(pathListByLevel, (String)"pathListByLevel");
            Contour contour = new Contour(null);
            Iterator<Double> iterator = levels.iterator();
            while (iterator.hasNext()) {
                List<? extends List<DoubleVector>> paths;
                double level = ((Number)iterator.next()).doubleValue();
                Intrinsics.checkNotNull(pathListByLevel.get(level));
                for (List<DoubleVector> list2 : paths) {
                    contour.add(list2, level);
                }
            }
            return contour.getDataFrame();
        }

        @NotNull
        public final DataFrame getPolygonDataFrame(@NotNull List<Double> fillLevels, @NotNull Map<Double, ? extends List<DoubleVector>> polygonListByFillLevel) {
            Intrinsics.checkNotNullParameter(fillLevels, (String)"fillLevels");
            Intrinsics.checkNotNullParameter(polygonListByFillLevel, (String)"polygonListByFillLevel");
            Contour contour = new Contour(null);
            Iterator<Double> iterator = fillLevels.iterator();
            while (iterator.hasNext()) {
                List<DoubleVector> polygon;
                double fillLevel = ((Number)iterator.next()).doubleValue();
                Intrinsics.checkNotNull(polygonListByFillLevel.get(fillLevel));
                contour.add(polygon, fillLevel);
            }
            return contour.getDataFrame();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

