/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.http.HttpVersion;
import org.apache.http.params.HttpParams;
import org.apache.jmeter.NewDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HttpClientDefaultParameters {
    private static final Logger log = LoggerFactory.getLogger(HttpClientDefaultParameters.class);

    private HttpClientDefaultParameters() {
    }

    public static void load(String file, final HttpParams params) {
        HttpClientDefaultParameters.load(file, new GenericHttpParams(){

            @Override
            public void setParameter(String name, Object value) {
                params.setParameter(name, value);
            }

            @Override
            public void setVersion(String name, String value) {
                String[] parts = value.split("\\.");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Version must have form m.n");
                }
                params.setParameter(name, (Object)new HttpVersion(Integer.parseInt(parts[0]), Integer.parseInt(parts[1])));
            }
        });
    }

    private static void load(String file, GenericHttpParams params) {
        log.info("Trying httpclient parameters from " + file);
        File f = new File(file);
        if (!f.exists() || !f.canRead()) {
            f = new File(NewDriver.getJMeterDir() + File.separator + "bin" + File.separator + file);
            log.info(file + " httpclient parameters does not exist, trying " + f.getAbsolutePath());
            if (!f.exists() || !f.canRead()) {
                log.error("Cannot read parameters file for HttpClient: " + file);
                return;
            }
        }
        log.info("Reading httpclient parameters from " + f.getAbsolutePath());
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(f);){
            props.load(is);
            for (Map.Entry<Object, Object> me : props.entrySet()) {
                String key = (String)me.getKey();
                String value = (String)me.getValue();
                int typeSep = key.indexOf(36);
                try {
                    if (typeSep > 0) {
                        String type = key.substring(typeSep + 1);
                        String name = key.substring(0, typeSep);
                        log.info("Defining " + name + " as " + value + " (" + type + ")");
                        if (type.equals("Integer")) {
                            params.setParameter(name, Integer.valueOf(value));
                            continue;
                        }
                        if (type.equals("Long")) {
                            params.setParameter(name, Long.valueOf(value));
                            continue;
                        }
                        if (type.equals("Boolean")) {
                            params.setParameter(name, Boolean.valueOf(value));
                            continue;
                        }
                        if (type.equals("HttpVersion")) {
                            params.setVersion(name, value);
                            continue;
                        }
                        log.warn("Unexpected type: " + type + " for name " + name);
                        continue;
                    }
                    log.info("Defining " + key + " as " + value);
                    params.setParameter(key, value);
                }
                catch (Exception e) {
                    log.error("Error in property: " + key + "=" + value + " " + e.toString());
                }
            }
        }
        catch (IOException e) {
            log.error("Problem loading properties " + e.toString());
        }
    }

    private static abstract class GenericHttpParams {
        private GenericHttpParams() {
        }

        public abstract void setParameter(String var1, Object var2);

        public abstract void setVersion(String var1, String var2) throws Exception;
    }
}

