/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.types;

import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;

public class Millisecond {
    private static final int NANOS_PER_MILLISECOND = 1000000;
    private final int value;

    public static Millisecond of(int value) {
        return new Millisecond(value);
    }

    public static Millisecond ofNanos(int nano) {
        return Millisecond.of(nano / 1000000);
    }

    public static Millisecond from(TemporalAccessor temporal) {
        return new Millisecond(temporal.get(ChronoField.MILLI_OF_SECOND));
    }

    private Millisecond(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        return Integer.valueOf(this.value).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Millisecond that = (Millisecond)obj;
        return this.value == that.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

