/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.util;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.spec.FigKind;
import org.jetbrains.letsPlot.core.spec.config.CompositeFigureConfig;
import org.jetbrains.letsPlot.core.spec.config.PlotConfig;
import org.jetbrains.letsPlot.core.spec.front.PlotConfigFrontend;
import org.jetbrains.letsPlot.core.util.PlotSizeHelper;
import org.jetbrains.letsPlot.core.util.PlotSizeUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J*\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/util/PlotSizeUtil;", "", "()V", "fitPlotInContainer", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plotSize", "containerSize", "preferredFigureSize", "figureSpec", "", "", "preserveAspectRatio", "", "plot-stem"})
public final class PlotSizeUtil {
    @NotNull
    public static final PlotSizeUtil INSTANCE = new PlotSizeUtil();

    private PlotSizeUtil() {
    }

    @NotNull
    public final DoubleVector preferredFigureSize(@NotNull Map<String, ? extends Object> figureSpec, boolean preserveAspectRatio, @NotNull DoubleVector containerSize) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter(figureSpec, (String)"figureSpec");
        Intrinsics.checkNotNullParameter((Object)containerSize, (String)"containerSize");
        if (PlotConfig.Companion.isFailure(figureSpec)) {
            return containerSize;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind(figureSpec).ordinal()]) {
            case 1: {
                DoubleVector bunchSize = PlotSizeHelper.INSTANCE.plotBunchSize(figureSpec);
                doubleVector = new DoubleVector(bunchSize.getX(), bunchSize.getY());
                break;
            }
            case 2: {
                if (!preserveAspectRatio) {
                    return containerSize;
                }
                CompositeFigureConfig compositeFigureConfig2 = new CompositeFigureConfig(figureSpec, null, (Function1<? super List<String>, Unit>)((Function1)preferredFigureSize.compositeFigureConfig.1.INSTANCE));
                DoubleVector defaultSize = PlotSizeHelper.INSTANCE.compositeFigureSize(compositeFigureConfig2, null, null, null);
                doubleVector = this.fitPlotInContainer(defaultSize, containerSize);
                break;
            }
            case 3: {
                if (!preserveAspectRatio) {
                    return containerSize;
                }
                PlotConfigFrontend config2 = PlotConfigFrontend.Companion.create(figureSpec, null, (Function1<? super List<String>, Unit>)((Function1)preferredFigureSize.config.1.INSTANCE));
                DoubleVector defaultSize = PlotSizeHelper.INSTANCE.singlePlotSize(figureSpec, null, null, null, config2.getFacets(), config2.getContainsLiveMap());
                doubleVector = this.fitPlotInContainer(defaultSize, containerSize);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    private final DoubleVector fitPlotInContainer(DoubleVector plotSize2, DoubleVector containerSize) {
        DoubleVector doubleVector;
        double aspectRatio = plotSize2.getX() / plotSize2.getY();
        double width = containerSize.getX();
        double height = containerSize.getY();
        if (aspectRatio >= 1.0) {
            double plotHeight = width / aspectRatio;
            double scaling = plotHeight > height ? height / plotHeight : 1.0;
            doubleVector = new DoubleVector(width * scaling, plotHeight * scaling);
        } else {
            double plotWidth = height * aspectRatio;
            double scaling = plotWidth > width ? width / plotWidth : 1.0;
            doubleVector = new DoubleVector(plotWidth * scaling, height * scaling);
        }
        return doubleVector;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FigKind.values().length];
            try {
                nArray[FigKind.GG_BUNCH_SPEC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.SUBPLOTS_SPEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.PLOT_SPEC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

