/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.DatasetGraphWrapperView;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.Context;

public class QueryEngineFactoryWrapper
implements QueryEngineFactory {
    private static QueryEngineFactory instance = new QueryEngineFactoryWrapper();

    public static QueryEngineFactory get() {
        return instance;
    }

    @Override
    public boolean accept(Query query2, DatasetGraph dsg, Context context2) {
        DatasetGraphWrapper dsgw;
        block3: {
            block2: {
                if (!(dsg instanceof DatasetGraphWrapper)) break block2;
                dsgw = (DatasetGraphWrapper)dsg;
                if (!(dsg instanceof DatasetGraphWrapperView)) break block3;
            }
            return false;
        }
        DatasetGraph dsg2 = dsgw.getWrapped();
        return QueryEngineRegistry.findFactory(query2, dsg2, context2).accept(query2, dsg2, context2);
    }

    @Override
    public Plan create(Query query2, DatasetGraph dsg, Binding inputBinding, Context context2) {
        DatasetGraphWrapper dsgw;
        block3: {
            block2: {
                if (!(dsg instanceof DatasetGraphWrapper)) break block2;
                dsgw = (DatasetGraphWrapper)dsg;
                if (!(dsg instanceof DatasetGraphWrapperView)) break block3;
            }
            return null;
        }
        DatasetGraph dsg2 = dsgw.getWrapped();
        return QueryEngineRegistry.findFactory(query2, dsg2, context2).create(query2, dsg2, inputBinding, context2);
    }

    @Override
    public boolean accept(Op op, DatasetGraph dsg, Context context2) {
        if (!(dsg instanceof DatasetGraphWrapper) || dsg instanceof DatasetGraphWrapperView) {
            return false;
        }
        DatasetGraph dsg2 = ((DatasetGraphWrapper)dsg).getWrapped();
        return QueryEngineRegistry.findFactory(op, dsg2, context2).accept(op, dsg2, context2);
    }

    @Override
    public Plan create(Op op, DatasetGraph dsg, Binding inputBinding, Context context2) {
        if (!(dsg instanceof DatasetGraphWrapper) || dsg instanceof DatasetGraphWrapperView) {
            return null;
        }
        DatasetGraph dsg2 = ((DatasetGraphWrapper)dsg).getWrapped();
        return QueryEngineRegistry.findFactory(op, dsg2, context2).create(op, dsg2, inputBinding, context2);
    }
}

