/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out.quoted;

import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.riot.out.quoted.QuotedStringOutput;

public class QuotedStringOutputBase
implements QuotedStringOutput {
    protected final CharSpace charSpace;
    protected final char quoteChar;

    protected QuotedStringOutputBase(char quoteChar, CharSpace charSpace) {
        this.charSpace = charSpace;
        this.quoteChar = quoteChar;
    }

    @Override
    public char getQuoteChar() {
        return this.quoteChar;
    }

    @Override
    public void writeStr(AWriter writer, String str2) {
        writer.print(this.getQuoteChar());
        EscapeStr.stringEsc(writer, str2, this.getQuoteChar(), true, this.charSpace);
        writer.print(this.getQuoteChar());
    }

    @Override
    public void writeStrMultiLine(AWriter writer, String str2) {
        this.writeStr(writer, str2);
    }
}

