/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

public enum NodeIdType {
    PTR(0, null),
    XSD_INTEGER(TYPES.T_INTEGER, "Integer"),
    XSD_DECIMAL(TYPES.T_DECIMAL, "Decimal"),
    XSD_FLOAT(TYPES.T_FLOAT, "Float"),
    XSD_DOUBLE(TYPES.T_DOUBLE, "Double"),
    XSD_DATETIME(TYPES.T_DATETIME, "DateTime"),
    XSD_DATETIMESTAMP(TYPES.T_DATETIMESTAMP, "DateTimeStamp"),
    XSD_DATE(TYPES.T_DATE, "Date"),
    XSD_BOOLEAN(TYPES.T_BOOLEAN, "Boolean"),
    XSD_SHORTSTRING(TYPES.T_SHORTSTRING, "ShortString"),
    XSD_POSITIVE_INTEGER(TYPES.T_POSITIVE_INTEGER, "Positive Integer"),
    XSD_NEGATIVE_INTEGER(TYPES.T_NEGATIVE_INTEGER, "Negative Integer"),
    XSD_NON_NEGATIVE_INTEGER(TYPES.T_NON_NEGATIVE_INTEGER, "Non-negative Integer"),
    XSD_NON_POSITIVE_INTEGER(TYPES.T_NON_POSITIVE_INTEGER, "Non-positive Integer"),
    XSD_LONG(TYPES.T_LONG, "Long"),
    XSD_INT(TYPES.T_INT, "Int"),
    XSD_SHORT(TYPES.T_SHORT, "Short"),
    XSD_BYTE(TYPES.T_BYTE, "Byte"),
    XSD_UNSIGNEDLONG(TYPES.T_UNSIGNEDLONG, "UnsignedLong"),
    XSD_UNSIGNEDINT(TYPES.T_UNSIGNEDINT, "UnsignedInt"),
    XSD_UNSIGNEDSHORT(TYPES.T_UNSIGNEDSHORT, "UnsignedShort"),
    XSD_UNSIGNEDBYTE(TYPES.T_UNSIGNEDBYTE, "UnsignedByte"),
    SPECIAL(TYPES.T_SPECIAL, "Special"),
    INVALID$(TYPES.T_INVALID, "Invalid");

    private final int value;
    private final String displayName;

    static boolean isStorable(NodeIdType type) {
        return !NodeIdType.isSpecial(type);
    }

    static boolean isInteger(NodeIdType type) {
        switch (type.ordinal()) {
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    static boolean isDecimal(NodeIdType type) {
        return type == XSD_DECIMAL;
    }

    static boolean isDouble(NodeIdType type) {
        return type == XSD_DOUBLE;
    }

    static boolean isFloat(NodeIdType type) {
        return type == XSD_FLOAT;
    }

    static boolean isNumber(NodeIdType type) {
        return NodeIdType.isInteger(type) || NodeIdType.isDecimal(type) || NodeIdType.isDouble(type) || NodeIdType.isFloat(type);
    }

    static boolean isSpecial(NodeIdType type) {
        return type == SPECIAL;
    }

    static boolean isInline(NodeIdType type) {
        switch (type.ordinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    public int type() {
        return TYPES.dec(this.value);
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name();
    }

    private NodeIdType(int value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public static NodeIdType intToEnum(int x) {
        NodeIdType t;
        if (x >= 128) {
            throw new IllegalArgumentException("Value '" + x + "' not legal: too large");
        }
        if (x != 0) {
            x = TYPES.enc(x);
        }
        if ((t = NodeIdType.intToEnum$(x)) == INVALID$) {
            throw new IllegalArgumentException("Value '" + x + "' not legal for " + NodeIdType.class.getSimpleName());
        }
        return t;
    }

    private static NodeIdType intToEnum$(int x) {
        if (x == NodeIdType.PTR.value) {
            return PTR;
        }
        if (x == NodeIdType.XSD_DOUBLE.value) {
            return XSD_DOUBLE;
        }
        if (x == NodeIdType.XSD_INTEGER.value) {
            return XSD_INTEGER;
        }
        if (x == NodeIdType.XSD_DECIMAL.value) {
            return XSD_DECIMAL;
        }
        if (x == NodeIdType.XSD_FLOAT.value) {
            return XSD_FLOAT;
        }
        if (x == NodeIdType.XSD_DATETIME.value) {
            return XSD_DATETIME;
        }
        if (x == NodeIdType.XSD_DATETIMESTAMP.value) {
            return XSD_DATETIMESTAMP;
        }
        if (x == NodeIdType.XSD_DATE.value) {
            return XSD_DATE;
        }
        if (x == NodeIdType.XSD_BOOLEAN.value) {
            return XSD_BOOLEAN;
        }
        if (x == NodeIdType.XSD_SHORTSTRING.value) {
            return XSD_SHORTSTRING;
        }
        if (x == NodeIdType.XSD_POSITIVE_INTEGER.value) {
            return XSD_POSITIVE_INTEGER;
        }
        if (x == NodeIdType.XSD_NEGATIVE_INTEGER.value) {
            return XSD_NEGATIVE_INTEGER;
        }
        if (x == NodeIdType.XSD_NON_NEGATIVE_INTEGER.value) {
            return XSD_NON_NEGATIVE_INTEGER;
        }
        if (x == NodeIdType.XSD_NON_POSITIVE_INTEGER.value) {
            return XSD_NON_POSITIVE_INTEGER;
        }
        if (x == NodeIdType.XSD_LONG.value) {
            return XSD_LONG;
        }
        if (x == NodeIdType.XSD_INT.value) {
            return XSD_INT;
        }
        if (x == NodeIdType.XSD_SHORT.value) {
            return XSD_SHORT;
        }
        if (x == NodeIdType.XSD_BYTE.value) {
            return XSD_BYTE;
        }
        if (x == NodeIdType.XSD_UNSIGNEDLONG.value) {
            return XSD_UNSIGNEDLONG;
        }
        if (x == NodeIdType.XSD_UNSIGNEDINT.value) {
            return XSD_UNSIGNEDINT;
        }
        if (x == NodeIdType.XSD_UNSIGNEDSHORT.value) {
            return XSD_UNSIGNEDSHORT;
        }
        if (x == NodeIdType.XSD_UNSIGNEDBYTE.value) {
            return XSD_UNSIGNEDBYTE;
        }
        return INVALID$;
    }

    public static class TYPES {
        public static final int T_PTR = 0;
        public static final int T_DOUBLE = TYPES.enc(64);
        public static final int T_INTEGER = TYPES.enc(1);
        public static final int T_DECIMAL = TYPES.enc(2);
        public static final int T_FLOAT = TYPES.enc(3);
        public static final int T_DATETIME = TYPES.enc(5);
        public static final int T_DATETIMESTAMP = TYPES.enc(6);
        public static final int T_DATE = TYPES.enc(7);
        public static final int T_BOOLEAN = TYPES.enc(8);
        public static final int T_SHORTSTRING = TYPES.enc(9);
        public static final int T_POSITIVE_INTEGER = TYPES.enc(10);
        public static final int T_NEGATIVE_INTEGER = TYPES.enc(11);
        public static final int T_NON_NEGATIVE_INTEGER = TYPES.enc(12);
        public static final int T_NON_POSITIVE_INTEGER = TYPES.enc(13);
        public static final int T_LONG = TYPES.enc(14);
        public static final int T_INT = TYPES.enc(15);
        public static final int T_SHORT = TYPES.enc(16);
        public static final int T_BYTE = TYPES.enc(17);
        public static final int T_UNSIGNEDLONG = TYPES.enc(18);
        public static final int T_UNSIGNEDINT = TYPES.enc(19);
        public static final int T_UNSIGNEDSHORT = TYPES.enc(20);
        public static final int T_UNSIGNEDBYTE = TYPES.enc(21);
        public static final int T_SPECIAL = TYPES.enc(48);
        public static final int T_INVALID = TYPES.enc(49);
        public static final int T_EXTENSION = TYPES.enc(63);

        static int enc(int v) {
            return v;
        }

        static int dec(int v) {
            return v;
        }
    }
}

