/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.droplists.postgres;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.mail.internet.AddressException;
import java.util.List;
import java.util.UUID;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.droplists.api.DeniedEntityType;
import org.apache.james.droplists.api.DropList;
import org.apache.james.droplists.api.DropListEntry;
import org.apache.james.droplists.api.OwnerScope;
import org.apache.james.droplists.postgres.PostgresDropListDataDefinition;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresDropList
implements DropList {
    private final PostgresExecutor postgresExecutor;

    @Inject
    public PostgresDropList(@Named(value="default") PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Mono<Void> add(DropListEntry entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0);
        String specifiedOwner = entry.getOwnerScope().equals((Object)OwnerScope.GLOBAL) ? "" : entry.getOwner();
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresDropListDataDefinition.PostgresDropListsTable.TABLE_NAME, PostgresDropListDataDefinition.PostgresDropListsTable.DROPLIST_ID, PostgresDropListDataDefinition.PostgresDropListsTable.OWNER_SCOPE, PostgresDropListDataDefinition.PostgresDropListsTable.OWNER, PostgresDropListDataDefinition.PostgresDropListsTable.DENIED_ENTITY_TYPE, PostgresDropListDataDefinition.PostgresDropListsTable.DENIED_ENTITY).values((Object)UUID.randomUUID(), (Object)entry.getOwnerScope().name(), (Object)specifiedOwner, (Object)entry.getDeniedEntityType().name(), (Object)entry.getDeniedEntity())));
    }

    public Mono<Void> remove(DropListEntry entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0);
        return this.postgresExecutor.executeVoid(dsl -> Mono.from((Publisher)dsl.deleteFrom(PostgresDropListDataDefinition.PostgresDropListsTable.TABLE_NAME).where(PostgresDropListDataDefinition.PostgresDropListsTable.OWNER_SCOPE.eq((Object)entry.getOwnerScope().name())).and(PostgresDropListDataDefinition.PostgresDropListsTable.OWNER.eq((Object)entry.getOwner())).and(PostgresDropListDataDefinition.PostgresDropListsTable.DENIED_ENTITY.eq((Object)entry.getDeniedEntity()))));
    }

    public Flux<DropListEntry> list(OwnerScope ownerScope, String owner) {
        Preconditions.checkArgument((ownerScope != null ? 1 : 0) != 0);
        Preconditions.checkArgument((owner != null ? 1 : 0) != 0);
        return this.postgresExecutor.executeRows(dsl -> Flux.from((Publisher)dsl.selectFrom(PostgresDropListDataDefinition.PostgresDropListsTable.TABLE_NAME).where(PostgresDropListDataDefinition.PostgresDropListsTable.OWNER_SCOPE.eq((Object)ownerScope.name())).and(PostgresDropListDataDefinition.PostgresDropListsTable.OWNER.eq((Object)owner)))).map(PostgresDropList::mapRecordToDropListEntry);
    }

    public Mono<DropList.Status> query(OwnerScope ownerScope, String owner, MailAddress sender) {
        Preconditions.checkArgument((ownerScope != null ? 1 : 0) != 0);
        Preconditions.checkArgument((owner != null ? 1 : 0) != 0);
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0);
        String specifiedOwner = ownerScope.equals((Object)OwnerScope.GLOBAL) ? "" : owner;
        return this.postgresExecutor.executeExists(dsl -> dsl.selectOne().from(PostgresDropListDataDefinition.PostgresDropListsTable.TABLE_NAME).where(PostgresDropListDataDefinition.PostgresDropListsTable.OWNER_SCOPE.eq((Object)ownerScope.name())).and(PostgresDropListDataDefinition.PostgresDropListsTable.OWNER.eq((Object)specifiedOwner)).and(PostgresDropListDataDefinition.PostgresDropListsTable.DENIED_ENTITY.in(List.of(sender.asString(), sender.getDomain().asString())))).map(isExist -> Boolean.TRUE.equals(isExist) ? DropList.Status.BLOCKED : DropList.Status.ALLOWED);
    }

    private static DropListEntry mapRecordToDropListEntry(Record dropListRecord) {
        String deniedEntity = (String)dropListRecord.get(PostgresDropListDataDefinition.PostgresDropListsTable.DENIED_ENTITY);
        String deniedEntityType = (String)dropListRecord.get(PostgresDropListDataDefinition.PostgresDropListsTable.DENIED_ENTITY_TYPE);
        OwnerScope ownerScope = OwnerScope.valueOf((String)((String)dropListRecord.get(PostgresDropListDataDefinition.PostgresDropListsTable.OWNER_SCOPE)));
        try {
            DropListEntry.Builder builder = DropListEntry.builder();
            switch (ownerScope) {
                case USER: {
                    builder.userOwner(new MailAddress((String)dropListRecord.get(PostgresDropListDataDefinition.PostgresDropListsTable.OWNER)));
                    break;
                }
                case DOMAIN: {
                    builder.domainOwner(Domain.of((String)((String)dropListRecord.get(PostgresDropListDataDefinition.PostgresDropListsTable.OWNER))));
                    break;
                }
                case GLOBAL: {
                    builder.forAll();
                }
            }
            if (DeniedEntityType.DOMAIN.name().equals(deniedEntityType)) {
                builder.denyDomain(Domain.of((String)deniedEntity));
            } else {
                builder.denyAddress(new MailAddress(deniedEntity));
            }
            return builder.build();
        }
        catch (AddressException e) {
            throw new IllegalArgumentException("Entity could not be parsed as a MailAddress", e);
        }
    }
}

