/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.SearchConfiguration;
import org.apache.james.backends.postgres.PostgresConfiguration;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.jmap.JMAPModule;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.server.core.JamesServerResourceLoader;
import org.apache.james.server.core.MissingArgumentException;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.server.core.configuration.FileConfigurationProvider;
import org.apache.james.server.core.filesystem.FileSystemImpl;
import org.apache.james.utils.PropertiesProvider;
import org.apache.james.vault.VaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresJamesConfiguration
implements Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.apache.james.CONFIGURATION");
    private static final BlobStoreConfiguration.BlobStoreImplName DEFAULT_BLOB_STORE = BlobStoreConfiguration.BlobStoreImplName.POSTGRES;
    private final Configuration.ConfigurationPath configurationPath;
    private final JamesDirectoriesProvider directories;
    private final SearchConfiguration searchConfiguration;
    private final UsersRepositoryModuleChooser.Implementation usersRepositoryImplementation;
    private final BlobStoreConfiguration blobStoreConfiguration;
    private final EventBusImpl eventBusImpl;
    private final VaultConfiguration deletedMessageVaultConfiguration;
    private final boolean jmapEnabled;
    private final boolean dropListsEnabled;
    private final boolean rlsEnabled;

    public static Builder builder() {
        return new Builder();
    }

    private PostgresJamesConfiguration(Configuration.ConfigurationPath configurationPath, JamesDirectoriesProvider directories, SearchConfiguration searchConfiguration, UsersRepositoryModuleChooser.Implementation usersRepositoryImplementation, BlobStoreConfiguration blobStoreConfiguration, EventBusImpl eventBusImpl, VaultConfiguration deletedMessageVaultConfiguration, boolean jmapEnabled, boolean dropListsEnabled, boolean rlsEnabled) {
        this.configurationPath = configurationPath;
        this.directories = directories;
        this.searchConfiguration = searchConfiguration;
        this.usersRepositoryImplementation = usersRepositoryImplementation;
        this.blobStoreConfiguration = blobStoreConfiguration;
        this.eventBusImpl = eventBusImpl;
        this.deletedMessageVaultConfiguration = deletedMessageVaultConfiguration;
        this.jmapEnabled = jmapEnabled;
        this.dropListsEnabled = dropListsEnabled;
        this.rlsEnabled = rlsEnabled;
    }

    public Configuration.ConfigurationPath configurationPath() {
        return this.configurationPath;
    }

    public JamesDirectoriesProvider directories() {
        return this.directories;
    }

    public SearchConfiguration searchConfiguration() {
        return this.searchConfiguration;
    }

    public UsersRepositoryModuleChooser.Implementation getUsersRepositoryImplementation() {
        return this.usersRepositoryImplementation;
    }

    public BlobStoreConfiguration blobStoreConfiguration() {
        return this.blobStoreConfiguration;
    }

    public EventBusImpl eventBusImpl() {
        return this.eventBusImpl;
    }

    public VaultConfiguration getDeletedMessageVaultConfiguration() {
        return this.deletedMessageVaultConfiguration;
    }

    public boolean isJmapEnabled() {
        return this.jmapEnabled;
    }

    public boolean isDropListsEnabled() {
        return this.dropListsEnabled;
    }

    public boolean isRlsEnabled() {
        return this.rlsEnabled;
    }

    public static class Builder {
        private Optional<String> rootDirectory;
        private Optional<Configuration.ConfigurationPath> configurationPath;
        private Optional<UsersRepositoryModuleChooser.Implementation> usersRepositoryImplementation;
        private Optional<SearchConfiguration> searchConfiguration = Optional.empty();
        private Optional<BlobStoreConfiguration> blobStoreConfiguration;
        private Optional<EventBusImpl> eventBusImpl;
        private Optional<VaultConfiguration> deletedMessageVaultConfiguration;
        private Optional<Boolean> jmapEnabled;
        private Optional<Boolean> dropListsEnabled;
        private Optional<Boolean> rlsEnabled;

        private Builder() {
            this.rootDirectory = Optional.empty();
            this.configurationPath = Optional.empty();
            this.usersRepositoryImplementation = Optional.empty();
            this.blobStoreConfiguration = Optional.empty();
            this.eventBusImpl = Optional.empty();
            this.deletedMessageVaultConfiguration = Optional.empty();
            this.jmapEnabled = Optional.empty();
            this.dropListsEnabled = Optional.empty();
            this.rlsEnabled = Optional.empty();
        }

        public Builder workingDirectory(String path) {
            this.rootDirectory = Optional.of(path);
            return this;
        }

        public Builder workingDirectory(File file) {
            this.rootDirectory = Optional.of(file.getAbsolutePath());
            return this;
        }

        public Builder useWorkingDirectoryEnvProperty() {
            this.rootDirectory = Optional.ofNullable(System.getProperty("working.directory"));
            if (!this.rootDirectory.isPresent()) {
                throw new MissingArgumentException("Server needs a working.directory env entry");
            }
            return this;
        }

        public Builder configurationPath(Configuration.ConfigurationPath path) {
            this.configurationPath = Optional.of(path);
            return this;
        }

        public Builder configurationFromClasspath() {
            this.configurationPath = Optional.of(new Configuration.ConfigurationPath("classpath:"));
            return this;
        }

        public Builder usersRepository(UsersRepositoryModuleChooser.Implementation implementation) {
            this.usersRepositoryImplementation = Optional.of(implementation);
            return this;
        }

        public Builder searchConfiguration(SearchConfiguration searchConfiguration) {
            this.searchConfiguration = Optional.of(searchConfiguration);
            return this;
        }

        public Builder blobStore(BlobStoreConfiguration blobStoreConfiguration) {
            this.blobStoreConfiguration = Optional.of(blobStoreConfiguration);
            return this;
        }

        public Builder eventBusImpl(EventBusImpl eventBusImpl) {
            this.eventBusImpl = Optional.of(eventBusImpl);
            return this;
        }

        public Builder deletedMessageVaultConfiguration(VaultConfiguration vaultConfiguration) {
            this.deletedMessageVaultConfiguration = Optional.of(vaultConfiguration);
            return this;
        }

        public Builder jmapEnabled(Optional<Boolean> jmapEnabled) {
            this.jmapEnabled = jmapEnabled;
            return this;
        }

        public Builder enableDropLists() {
            this.dropListsEnabled = Optional.of(true);
            return this;
        }

        public Builder rlsEnabled(Optional<Boolean> rlsEnabled) {
            this.rlsEnabled = rlsEnabled;
            return this;
        }

        public PostgresJamesConfiguration build() {
            Configuration.ConfigurationPath configurationPath = this.configurationPath.orElse(new Configuration.ConfigurationPath("file://conf/"));
            JamesServerResourceLoader directories = new JamesServerResourceLoader(this.rootDirectory.orElseThrow(() -> new MissingArgumentException("Server needs a working.directory env entry")));
            FileSystemImpl fileSystem = new FileSystemImpl((JamesDirectoriesProvider)directories);
            PropertiesProvider propertiesProvider = new PropertiesProvider((FileSystem)fileSystem, configurationPath);
            SearchConfiguration searchConfiguration = this.searchConfiguration.orElseGet((Supplier<SearchConfiguration>)Throwing.supplier(() -> SearchConfiguration.parse((PropertiesProvider)propertiesProvider)));
            BlobStoreConfiguration blobStoreConfiguration = this.blobStoreConfiguration.orElseGet((Supplier<BlobStoreConfiguration>)Throwing.supplier(() -> BlobStoreConfiguration.parse((PropertiesProvider)propertiesProvider, (BlobStoreConfiguration.BlobStoreImplName)DEFAULT_BLOB_STORE)));
            Preconditions.checkState((!blobStoreConfiguration.getImplementation().equals((Object)BlobStoreConfiguration.BlobStoreImplName.CASSANDRA) ? 1 : 0) != 0, (Object)"Cassandra BlobStore is not supported by postgres-app.");
            Preconditions.checkState((!blobStoreConfiguration.cacheEnabled() ? 1 : 0) != 0, (Object)"BlobStore caching is not supported by postgres-app.");
            FileConfigurationProvider configurationProvider = new FileConfigurationProvider((FileSystem)fileSystem, (Configuration)Configuration.Basic.builder().configurationPath(configurationPath).workingDirectory(directories.getRootDirectory()).build());
            UsersRepositoryModuleChooser.Implementation usersRepositoryChoice = this.usersRepositoryImplementation.orElseGet(() -> UsersRepositoryModuleChooser.Implementation.parse((FileConfigurationProvider)configurationProvider));
            EventBusImpl eventBusImpl = this.eventBusImpl.orElseGet(() -> EventBusImpl.from(propertiesProvider));
            VaultConfiguration deletedMessageVaultConfiguration = this.deletedMessageVaultConfiguration.orElseGet(() -> {
                try {
                    return VaultConfiguration.from((org.apache.commons.configuration2.Configuration)propertiesProvider.getConfiguration("deletedMessageVault"));
                }
                catch (FileNotFoundException e) {
                    return VaultConfiguration.DEFAULT;
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException(e);
                }
            });
            boolean rlsEnabled = this.rlsEnabled.orElse(this.readRLSEnabledFromFile(propertiesProvider));
            boolean jmapEnabled = this.jmapEnabled.orElseGet(() -> {
                try {
                    return JMAPModule.parseConfiguration((PropertiesProvider)propertiesProvider).isEnabled();
                }
                catch (FileNotFoundException e) {
                    return false;
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException(e);
                }
            });
            boolean dropListsEnabled = this.dropListsEnabled.orElseGet(() -> {
                try {
                    return configurationProvider.getConfiguration("droplists").getBoolean("enabled", false);
                }
                catch (ConfigurationException e) {
                    return false;
                }
            });
            LOGGER.info("BlobStore configuration {}", (Object)blobStoreConfiguration);
            return new PostgresJamesConfiguration(configurationPath, (JamesDirectoriesProvider)directories, searchConfiguration, usersRepositoryChoice, blobStoreConfiguration, eventBusImpl, deletedMessageVaultConfiguration, jmapEnabled, dropListsEnabled, rlsEnabled);
        }

        private boolean readRLSEnabledFromFile(PropertiesProvider propertiesProvider) {
            try {
                return PostgresConfiguration.from((org.apache.commons.configuration2.Configuration)propertiesProvider.getConfiguration("postgres")).getRowLevelSecurity().isRowLevelSecurityEnabled();
            }
            catch (FileNotFoundException | ConfigurationException e) {
                return false;
            }
        }
    }

    public static enum EventBusImpl {
        IN_MEMORY,
        RABBITMQ;


        public static EventBusImpl from(PropertiesProvider configurationProvider) {
            try {
                configurationProvider.getConfiguration("rabbitmq");
                return RABBITMQ;
            }
            catch (FileNotFoundException e) {
                LOGGER.info("RabbitMQ configuration was not found, defaulting to in memory event bus");
                return IN_MEMORY;
            }
            catch (ConfigurationException e) {
                LOGGER.warn("Error reading rabbitmq.xml, defaulting to in memory event bus", (Throwable)e);
                return IN_MEMORY;
            }
        }
    }
}

