/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.PKCS8PEMFileReader;
import com.unboundid.util.ssl.cert.PKCS8PrivateKey;
import com.unboundid.util.ssl.cert.X509Certificate;
import com.unboundid.util.ssl.cert.X509PEMFileReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.X509KeyManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PEMFileKeyManager
implements X509KeyManager,
Serializable {
    private static final long serialVersionUID = 1973401278035832777L;
    @NotNull
    private static final String ALIAS_FINGERPRINT_ALGORITHM = "SHA-256";
    @NotNull
    private final java.security.cert.X509Certificate[] certificateChain;
    @NotNull
    private final PrivateKey privateKey;
    @NotNull
    private final String alias;

    public PEMFileKeyManager(@NotNull File certificateChainPEMFile, @NotNull File privateKeyPEMFile) throws KeyStoreException {
        this(Collections.singletonList(certificateChainPEMFile), privateKeyPEMFile);
    }

    public PEMFileKeyManager(@NotNull File[] certificateChainPEMFiles, @NotNull File privateKeyPEMFile) throws KeyStoreException {
        this(StaticUtils.toList(certificateChainPEMFiles), privateKeyPEMFile);
    }

    public PEMFileKeyManager(@NotNull List<File> certificateChainPEMFiles, @NotNull File privateKeyPEMFile) throws KeyStoreException {
        Validator.ensureNotNullWithMessage(certificateChainPEMFiles, "PEMFileKeyManager.certificateChainPEMFiles must not be null.");
        Validator.ensureFalse(certificateChainPEMFiles.isEmpty(), "PEMFileKeyManager.certificateChainPEMFiles must not be empty.");
        Validator.ensureNotNullWithMessage(privateKeyPEMFile, "PEMFileKeyManager.privateKeyPEMFile must not be null.");
        this.certificateChain = PEMFileKeyManager.readCertificateChain(certificateChainPEMFiles);
        this.privateKey = PEMFileKeyManager.readPrivateKey(privateKeyPEMFile);
        try {
            MessageDigest sha256 = CryptoHelper.getMessageDigest(ALIAS_FINGERPRINT_ALGORITHM);
            byte[] digestBytes = sha256.digest(this.certificateChain[0].getEncoded());
            this.alias = StaticUtils.toHex(digestBytes);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_KEY_MANAGER_CANNOT_COMPUTE_ALIAS.get(ALIAS_FINGERPRINT_ALGORITHM, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static java.security.cert.X509Certificate[] readCertificateChain(@NotNull List<File> certificateChainPEMFiles) throws KeyStoreException {
        X509Certificate lastCert = null;
        ArrayList<java.security.cert.X509Certificate> certList = new ArrayList<java.security.cert.X509Certificate>();
        block15: for (File f : certificateChainPEMFiles) {
            if (!f.exists()) {
                throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_KEY_MANAGER_NO_SUCH_CERT_FILE.get(f.getAbsolutePath()));
            }
            boolean readCert = false;
            try {
                X509PEMFileReader r = new X509PEMFileReader(f);
                Throwable throwable = null;
                try {
                    while (true) {
                        X509Certificate c;
                        if ((c = r.readCertificate()) == null) {
                            if (readCert) continue block15;
                            throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_KEY_MANAGER_EMPTY_CERT_FILE.get(f.getAbsolutePath()));
                        }
                        readCert = true;
                        if (lastCert != null && !c.isIssuerFor(lastCert)) {
                            throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_KEY_MANAGER_SUBSEQUENT_CERT_NOT_ISSUER.get(c.getSubjectDN().toString(), f.getAbsolutePath(), lastCert.getSubjectDN().toString()));
                        }
                        try {
                            certList.add((java.security.cert.X509Certificate)c.toCertificate());
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_KEY_MANAGER_CANNOT_DECODE_CERT.get(c.getSubjectDN().toString(), f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
                        }
                        lastCert = c;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (r == null) continue;
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    r.close();
                }
            }
            catch (KeyStoreException e) {
                Debug.debugException(e);
                throw e;
            }
            catch (IOException e) {
                Debug.debugException(e);
                throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_KEY_MANAGER_ERROR_READING_FROM_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
            catch (CertException e) {
                Debug.debugException(e);
                throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_KEY_MANAGER_ERROR_READING_CERT.get(f.getAbsolutePath(), e.getMessage()), e);
            }
        }
        java.security.cert.X509Certificate[] chain = new java.security.cert.X509Certificate[certList.size()];
        return certList.toArray(chain);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static PrivateKey readPrivateKey(@NotNull File privateKeyPEMFile) throws KeyStoreException {
        if (!privateKeyPEMFile.exists()) {
            throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_KEY_MANAGER_NO_SUCH_KEY_FILE.get(privateKeyPEMFile.getAbsolutePath()));
        }
        try {
            Throwable throwable = null;
            try (PKCS8PEMFileReader r = new PKCS8PEMFileReader(privateKeyPEMFile);){
                PKCS8PrivateKey privateKey = r.readPrivateKey();
                if (privateKey == null) {
                    throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_KEY_MANAGER_EMPTY_KEY_FILE.get(privateKeyPEMFile.getAbsolutePath()));
                }
                if (r.readPrivateKey() != null) {
                    throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_KEY_MANAGER_MULTIPLE_KEYS_IN_FILE.get(privateKeyPEMFile.getAbsolutePath()));
                }
                try {
                    PrivateKey privateKey2 = privateKey.toPrivateKey();
                    return privateKey2;
                }
                catch (Exception e) {
                    try {
                        Debug.debugException(e);
                        throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_KEY_MANAGER_CANNOT_DECODE_KEY.get(privateKeyPEMFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (KeyStoreException e) {
            Debug.debugException(e);
            throw e;
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_KEY_MANAGER_ERROR_READING_FROM_FILE.get(privateKeyPEMFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
        catch (CertException e) {
            Debug.debugException(e);
            throw new KeyStoreException(SSLMessages.ERR_PEM_FILE_KEY_MANAGER_ERROR_READING_KEY.get(privateKeyPEMFile.getAbsolutePath(), e.getMessage()), e);
        }
    }

    @Override
    @Nullable
    public String[] getClientAliases(@Nullable String keyType, @Nullable Principal[] issuers) {
        return this.getAliases(keyType, issuers);
    }

    @Override
    @Nullable
    public String[] getServerAliases(@Nullable String keyType, @Nullable Principal[] issuers) {
        return this.getAliases(keyType, issuers);
    }

    @Nullable
    private String[] getAliases(@Nullable String keyType, @Nullable Principal[] issuers) {
        if (!this.hasKeyType(keyType)) {
            Debug.debug(Level.WARNING, DebugType.OTHER, "PEMFileKeyManager.getAliases returning null because the requested keyType is '" + keyType + "' but the private " + "key uses an algorithm of '" + this.privateKey.getAlgorithm() + "'.");
            return null;
        }
        if (!this.hasAnyIssuer(issuers)) {
            Debug.debug(Level.WARNING, DebugType.OTHER, "PEMFileKeyManager.getAliases returning null because certificate chain " + Arrays.toString(this.certificateChain) + " does not use any of the allowed issuers " + Arrays.toString(issuers));
            return null;
        }
        return new String[]{this.alias};
    }

    @Override
    @Nullable
    public String chooseClientAlias(@Nullable String[] keyTypes, @Nullable Principal[] issuers, @Nullable Socket socket) {
        return this.chooseAlias(keyTypes, issuers);
    }

    @Override
    @Nullable
    public String chooseServerAlias(@Nullable String keyType, @Nullable Principal[] issuers, @Nullable Socket socket) {
        if (keyType == null) {
            return this.chooseAlias(null, issuers);
        }
        return this.chooseAlias(new String[]{keyType}, issuers);
    }

    @Nullable
    public String chooseAlias(@Nullable String[] keyTypes, @Nullable Principal[] issuers) {
        if (keyTypes != null && keyTypes.length > 0) {
            boolean keyTypeFound = false;
            for (String keyType : keyTypes) {
                if (!this.hasKeyType(keyType)) continue;
                keyTypeFound = true;
                break;
            }
            if (!keyTypeFound) {
                Debug.debug(Level.WARNING, DebugType.OTHER, "PEMFileKeyManager.chooseAlias returning null because certificate chain " + Arrays.toString(this.certificateChain) + " uses a key type of " + this.privateKey.getAlgorithm() + ", which does not match any of the allowed key types of " + Arrays.toString(keyTypes));
                return null;
            }
        }
        if (!this.hasAnyIssuer(issuers)) {
            Debug.debug(Level.WARNING, DebugType.OTHER, "PEMFileKeyManager.chooseAlias returning null because certificate chain " + Arrays.toString(this.certificateChain) + " does not use any of the allowed issuers " + Arrays.toString(issuers));
            return null;
        }
        return this.alias;
    }

    private boolean hasKeyType(@Nullable String keyType) {
        return keyType == null || this.privateKey.getAlgorithm().equalsIgnoreCase(keyType);
    }

    private boolean hasAnyIssuer(@Nullable Principal[] issuers) {
        if (issuers == null || issuers.length == 0) {
            return true;
        }
        for (Principal acceptableIssuer : issuers) {
            String acceptableIssuerString = acceptableIssuer.toString();
            for (java.security.cert.X509Certificate c : this.certificateChain) {
                Principal certificateIssuer = c.getIssuerDN();
                String certificateIssuerString = certificateIssuer.toString();
                try {
                    if (!DN.equals(certificateIssuerString, acceptableIssuerString)) continue;
                    return true;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        Principal endEntitySubject = this.certificateChain[0].getSubjectDN();
        String endEntitySubjectString = endEntitySubject.toString();
        for (Principal acceptableIssuer : issuers) {
            String acceptableIssuerString = acceptableIssuer.toString();
            try {
                if (!DN.equals(endEntitySubjectString, acceptableIssuerString)) continue;
                return true;
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public java.security.cert.X509Certificate[] getCertificateChain(@Nullable String alias) {
        return Arrays.copyOf(this.certificateChain, this.certificateChain.length);
    }

    @Override
    @NotNull
    public PrivateKey getPrivateKey(@Nullable String alias) {
        return this.privateKey;
    }
}

