/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolStatistics;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import java.util.logging.Level;

final class ParallelPoolCloserTask
implements Runnable {
    private final boolean unbind;
    @NotNull
    private final LDAPConnection connection;

    ParallelPoolCloserTask(@NotNull LDAPConnection connection, boolean unbind) {
        this.connection = connection;
        this.unbind = unbind;
    }

    @Override
    public void run() {
        LDAPConnectionPoolStatistics stats;
        AbstractConnectionPool pool = this.connection.getConnectionPool();
        if (pool != null && (stats = pool.getConnectionPoolStatistics()) != null) {
            stats.incrementNumConnectionsClosedUnneeded();
            Debug.debugConnectionPool(Level.INFO, pool, this.connection, "Closing a pooled connection because the pool is closing", null);
        }
        this.connection.setDisconnectInfo(DisconnectType.POOL_CLOSED, null, null);
        if (this.unbind) {
            this.connection.terminate(null);
        } else {
            this.connection.setClosed();
        }
    }
}

