/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.math.BigInteger;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.math.MathSubscriber;
import reactor.math.MonoFromFluxOperator;

public class MonoAverageBigInteger<T>
extends MonoFromFluxOperator<T, BigInteger>
implements Fuseable {
    private final Function<? super T, ? extends Number> mapping;

    MonoAverageBigInteger(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        super(Flux.from(source));
        this.mapping = mapping;
    }

    public void subscribe(CoreSubscriber<? super BigInteger> actual) {
        this.source.subscribe(new AverageBigIntegerSubscriber<T>(actual, this.mapping));
    }

    private static final class AverageBigIntegerSubscriber<T>
    extends MathSubscriber<T, BigInteger> {
        private final Function<? super T, ? extends Number> mapping;
        private int count;
        private BigInteger sum = BigInteger.ZERO;

        AverageBigIntegerSubscriber(CoreSubscriber<? super BigInteger> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void reset() {
            this.count = 0;
            this.sum = BigInteger.ZERO;
        }

        @Override
        protected BigInteger result() {
            return this.count == 0 ? null : this.sum.divide(BigInteger.valueOf(this.count));
        }

        @Override
        protected void updateResult(T newValue) {
            Number number = this.mapping.apply(newValue);
            BigInteger bigIntegerValue = BigInteger.valueOf(number.longValue());
            this.sum = this.sum.add(bigIntegerValue);
            ++this.count;
        }
    }
}

