/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.mailbox.AttachmentContentLoader;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MailboxMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearches;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.apache.james.mailbox.store.search.comparator.CombinedComparator;
import org.apache.james.util.streams.Iterators;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class SimpleMessageSearchIndex
implements MessageSearchIndex {
    private final MessageMapperFactory messageMapperFactory;
    private final MailboxMapperFactory mailboxMapperFactory;
    private final TextExtractor textExtractor;
    private final AttachmentContentLoader attachmentContentLoader;

    @Inject
    public SimpleMessageSearchIndex(MessageMapperFactory messageMapperFactory, MailboxMapperFactory mailboxMapperFactory, TextExtractor textExtractor, AttachmentContentLoader attachmentContentLoader) {
        this.messageMapperFactory = messageMapperFactory;
        this.mailboxMapperFactory = mailboxMapperFactory;
        this.textExtractor = textExtractor;
        this.attachmentContentLoader = attachmentContentLoader;
    }

    @Override
    public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities(EnumSet<MailboxManager.MessageCapabilities> messageCapabilities) {
        return EnumSet.of(MailboxManager.SearchCapabilities.MultimailboxSearch, MailboxManager.SearchCapabilities.Text, MailboxManager.SearchCapabilities.Attachment, MailboxManager.SearchCapabilities.PartialEmailMatch, MailboxManager.SearchCapabilities.AttachmentFileName);
    }

    private static SearchQuery.UidCriterion findConjugatedUidCriterion(List<SearchQuery.Criterion> crits) {
        for (SearchQuery.Criterion crit : crits) {
            if (crit instanceof SearchQuery.UidCriterion) {
                return (SearchQuery.UidCriterion)crit;
            }
            if (!(crit instanceof SearchQuery.ConjunctionCriterion)) continue;
            return SimpleMessageSearchIndex.findConjugatedUidCriterion(((SearchQuery.ConjunctionCriterion)crit).getCriteria());
        }
        return null;
    }

    @Override
    public Flux<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery query) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        return this.searchResults(session, (Flux<Mailbox>)Flux.just((Object)mailbox), query).filter(searchResult -> searchResult.getMailboxId().equals(mailbox.getMailboxId())).map(MessageSearchIndex.SearchResult::getMessageUid);
    }

    private Set<MailboxMessage> searchResults(MailboxSession session, Mailbox mailbox, SearchQuery query) throws MailboxException {
        MessageMapper mapper = this.messageMapperFactory.getMessageMapper(session);
        TreeSet<MailboxMessage> hitSet = new TreeSet<MailboxMessage>();
        SearchQuery.UidCriterion uidCrit = SimpleMessageSearchIndex.findConjugatedUidCriterion(query.getCriteria());
        if (uidCrit != null) {
            SearchQuery.UidRange[] ranges;
            for (SearchQuery.UidRange r : ranges = uidCrit.getOperator().getRange()) {
                Iterator<MailboxMessage> it = mapper.findInMailbox(mailbox, MessageRange.range((MessageUid)r.getLowValue(), (MessageUid)r.getHighValue()), MessageMapper.FetchType.METADATA, -1);
                while (it.hasNext()) {
                    hitSet.add(it.next());
                }
            }
        } else {
            Iterator<MailboxMessage> messages = mapper.findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.FULL, -1);
            while (messages.hasNext()) {
                MailboxMessage m = messages.next();
                hitSet.add(m);
            }
        }
        return hitSet;
    }

    @Override
    public Flux<MessageId> search(MailboxSession session, Collection<MailboxId> mailboxIds, SearchQuery searchQuery, long limit) throws MailboxException {
        MailboxMapper mailboxMapper = this.mailboxMapperFactory.getMailboxMapper(session);
        Flux filteredMailboxes = Flux.fromIterable(mailboxIds).concatMap(mailboxMapper::findMailboxById);
        return this.getAsMessageIds(this.searchResults(session, (Flux<Mailbox>)filteredMailboxes, searchQuery), limit);
    }

    private Flux<? extends MessageSearchIndex.SearchResult> searchResults(MailboxSession session, Flux<Mailbox> mailboxes, SearchQuery query) {
        return mailboxes.concatMap(mailbox -> Mono.fromCallable(() -> this.getSearchResultStream(session, query, (Mailbox)mailbox)).flatMapMany(Flux::fromStream).subscribeOn(Schedulers.elastic())).collectSortedList((Comparator)CombinedComparator.create(query.getSorts())).flatMapMany(list -> Iterators.toFlux(new MessageSearches(list.iterator(), query, this.textExtractor, this.attachmentContentLoader, session).iterator())).subscribeOn(Schedulers.elastic());
    }

    private Stream<MailboxMessage> getSearchResultStream(MailboxSession session, SearchQuery query, Mailbox mailbox) {
        try {
            return this.searchResults(session, mailbox, query).stream();
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }

    private Flux<MessageId> getAsMessageIds(Flux<? extends MessageSearchIndex.SearchResult> temp, long limit) {
        return temp.map(searchResult -> searchResult.getMessageId().get()).filter(SearchUtil.distinct()).take((long)Long.valueOf(limit).intValue());
    }
}

