/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieverepository.api;

import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.james.core.Username;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.ScriptSummary;
import org.apache.james.sieverepository.api.SieveQuotaRepository;
import org.apache.james.sieverepository.api.exception.DuplicateException;
import org.apache.james.sieverepository.api.exception.IsActiveException;
import org.apache.james.sieverepository.api.exception.QuotaExceededException;
import org.apache.james.sieverepository.api.exception.ScriptNotFoundException;
import org.apache.james.sieverepository.api.exception.StorageException;

public interface SieveRepository
extends SieveQuotaRepository {
    public static final ScriptName NO_SCRIPT_NAME = new ScriptName("");

    public void haveSpace(Username var1, ScriptName var2, long var3) throws QuotaExceededException, StorageException;

    public void putScript(Username var1, ScriptName var2, ScriptContent var3) throws StorageException, QuotaExceededException;

    public List<ScriptSummary> listScripts(Username var1) throws StorageException;

    public ZonedDateTime getActivationDateForActiveScript(Username var1) throws StorageException, ScriptNotFoundException;

    public InputStream getActive(Username var1) throws ScriptNotFoundException, StorageException;

    public void setActive(Username var1, ScriptName var2) throws ScriptNotFoundException, StorageException;

    public InputStream getScript(Username var1, ScriptName var2) throws ScriptNotFoundException, StorageException;

    public void deleteScript(Username var1, ScriptName var2) throws ScriptNotFoundException, IsActiveException, StorageException;

    public void renameScript(Username var1, ScriptName var2, ScriptName var3) throws ScriptNotFoundException, DuplicateException, StorageException;
}

