/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;

public class RecoveryRequestTracker {
    private final Map<Long, ListenableFuture<Void>> ongoingRequests = Collections.synchronizedMap(new HashMap());
    private final LocalCheckpointTracker checkpointTracker = new LocalCheckpointTracker(-1L, -1L);

    @Nullable
    public synchronized ActionListener<Void> markReceivedAndCreateListener(final long requestSeqNo, final ActionListener<Void> listener) {
        if (this.checkpointTracker.hasProcessed(requestSeqNo)) {
            ListenableFuture<Void> existingFuture = this.ongoingRequests.get(requestSeqNo);
            if (existingFuture != null) {
                existingFuture.addListener(listener, EsExecutors.newDirectExecutorService());
            } else {
                listener.onResponse(null);
            }
            return null;
        }
        this.checkpointTracker.markSeqNoAsProcessed(requestSeqNo);
        ListenableFuture<Void> future = new ListenableFuture<Void>();
        this.ongoingRequests.put(requestSeqNo, future);
        future.addListener(new ActionListener<Void>(){

            @Override
            public void onResponse(Void v) {
                RecoveryRequestTracker.this.ongoingRequests.remove(requestSeqNo);
                listener.onResponse(v);
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, EsExecutors.newDirectExecutorService());
        return future;
    }
}

