/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.db.exception.metadata.view.InsertNonWritableViewException;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaComputation;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.IDeviceSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.SchemaCacheEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceSchemaCache;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TreeDeviceNormalSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TreeDeviceTemplateSchema;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.ITemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class TreeDeviceSchemaCacheManager {
    private final ITemplateManager templateManager = ClusterTemplateManager.getInstance();
    private final TableDeviceSchemaCache tableDeviceSchemaCache;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(false);

    private TreeDeviceSchemaCacheManager() {
        this.tableDeviceSchemaCache = TableDeviceSchemaCache.getInstance();
    }

    public static TreeDeviceSchemaCacheManager getInstance() {
        return TreeDeviceSchemaCacheManagerHolder.INSTANCE;
    }

    public void takeReadLock() {
        this.readWriteLock.readLock().lock();
    }

    public void releaseReadLock() {
        this.readWriteLock.readLock().unlock();
    }

    public void takeWriteLock() {
        this.readWriteLock.writeLock().lock();
    }

    public void releaseWriteLock() {
        this.readWriteLock.writeLock().unlock();
    }

    public ClusterSchemaTree get(PartialPath devicePath, String[] measurements) {
        ClusterSchemaTree tree = new ClusterSchemaTree();
        IDeviceSchema schema = this.tableDeviceSchemaCache.getDeviceSchema(devicePath.getNodes());
        if (!(schema instanceof TreeDeviceNormalSchema)) {
            return tree;
        }
        TreeDeviceNormalSchema treeSchema = (TreeDeviceNormalSchema)schema;
        for (String measurement : measurements) {
            SchemaCacheEntry entry = treeSchema.getSchemaCacheEntry(measurement);
            if (!Objects.nonNull(entry)) continue;
            tree.appendSingleMeasurement(devicePath.concatNode(measurement), entry.getSchema(), entry.getTagMap(), null, null, treeSchema.isAligned());
        }
        tree.setDatabases(Collections.singleton(treeSchema.getDatabase()));
        return tree;
    }

    public ClusterSchemaTree getMatchedSchemaWithTemplate(PartialPath devicePath) {
        ClusterSchemaTree tree = new ClusterSchemaTree();
        IDeviceSchema schema = this.tableDeviceSchemaCache.getDeviceSchema(devicePath.getNodes());
        if (!(schema instanceof TreeDeviceTemplateSchema)) {
            return tree;
        }
        TreeDeviceTemplateSchema treeSchema = (TreeDeviceTemplateSchema)schema;
        Template template = this.templateManager.getTemplate(treeSchema.getTemplateId());
        tree.appendTemplateDevice(devicePath, template.isDirectAligned(), template.getId(), template);
        tree.setDatabases(Collections.singleton(treeSchema.getDatabase()));
        return tree;
    }

    public ClusterSchemaTree getMatchedSchemaWithoutTemplate(PartialPath fullPath) {
        ClusterSchemaTree tree = new ClusterSchemaTree();
        IDeviceSchema schema = this.tableDeviceSchemaCache.getDeviceSchema(Arrays.copyOf(fullPath.getNodes(), fullPath.getNodeLength() - 1));
        if (!(schema instanceof TreeDeviceNormalSchema)) {
            return tree;
        }
        TreeDeviceNormalSchema treeSchema = (TreeDeviceNormalSchema)schema;
        SchemaCacheEntry entry = treeSchema.getSchemaCacheEntry(fullPath.getMeasurement());
        if (Objects.isNull(entry)) {
            return tree;
        }
        tree.appendSingleMeasurement(fullPath, entry.getSchema(), entry.getTagMap(), null, null, treeSchema.isAligned());
        tree.setDatabases(Collections.singleton(treeSchema.getDatabase()));
        return tree;
    }

    public List<Integer> computeWithoutTemplate(ISchemaComputation schemaComputation) {
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        String[] measurements = schemaComputation.getMeasurements();
        IDeviceSchema schema = this.tableDeviceSchemaCache.getDeviceSchema(schemaComputation.getDevicePath().getNodes());
        if (!(schema instanceof TreeDeviceNormalSchema)) {
            return IntStream.range(0, schemaComputation.getMeasurements().length).boxed().collect(Collectors.toList());
        }
        TreeDeviceNormalSchema treeSchema = (TreeDeviceNormalSchema)schema;
        for (int i = 0; i < schemaComputation.getMeasurements().length; ++i) {
            SchemaCacheEntry value = treeSchema.getSchemaCacheEntry(measurements[i]);
            if (value == null) {
                indexOfMissingMeasurements.add(i);
                continue;
            }
            schemaComputation.computeMeasurement(i, value);
        }
        schemaComputation.computeDevice(treeSchema.isAligned());
        schemaComputation.recordRangeOfLogicalViewSchemaListNow();
        return indexOfMissingMeasurements;
    }

    public Pair<List<Integer>, List<String>> computeSourceOfLogicalView(ISchemaComputation schemaComputation) {
        if (!schemaComputation.hasLogicalViewNeedProcess()) {
            return new Pair(new ArrayList(), new ArrayList());
        }
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        Pair<Integer, Integer> beginToEnd = schemaComputation.getRangeOfLogicalViewSchemaListRecorded();
        List<LogicalViewSchema> logicalViewSchemaList = schemaComputation.getLogicalViewSchemaList();
        List<Integer> indexListOfLogicalViewPaths = schemaComputation.getIndexListOfLogicalViewPaths();
        for (int i = ((Integer)beginToEnd.left).intValue(); i < (Integer)beginToEnd.right; ++i) {
            LogicalViewSchema logicalViewSchema = logicalViewSchemaList.get(i);
            int realIndex = indexListOfLogicalViewPaths.get(i);
            if (!logicalViewSchema.isWritable()) {
                throw new RuntimeException((Throwable)((Object)new InsertNonWritableViewException(schemaComputation.getDevicePath().concatAsMeasurementPath(schemaComputation.getMeasurements()[realIndex]).getFullPath())));
            }
            PartialPath fullPath = logicalViewSchema.getSourcePathIfWritable();
            IDeviceSchema schema = this.tableDeviceSchemaCache.getDeviceSchema(fullPath.getDevicePath().getNodes());
            if (!(schema instanceof TreeDeviceNormalSchema)) {
                indexOfMissingMeasurements.add(i);
                continue;
            }
            TreeDeviceNormalSchema treeSchema = (TreeDeviceNormalSchema)schema;
            SchemaCacheEntry value = treeSchema.getSchemaCacheEntry(fullPath.getMeasurement());
            if (Objects.isNull(value)) {
                indexOfMissingMeasurements.add(i);
                continue;
            }
            if (value.isLogicalView()) {
                throw new RuntimeException(new UnsupportedOperationException(String.format("The source of view [%s] is also a view! Nested view is unsupported! Please check it.", logicalViewSchema.getSourcePathIfWritable())));
            }
            schemaComputation.computeMeasurementOfView(realIndex, value, treeSchema.isAligned());
        }
        return new Pair(indexOfMissingMeasurements, indexOfMissingMeasurements.stream().map(index -> ((LogicalViewSchema)logicalViewSchemaList.get((int)index)).getSourcePathStringIfWritable()).collect(Collectors.toList()));
    }

    public List<Integer> computeWithTemplate(ISchemaComputation computation) {
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        String[] measurements = computation.getMeasurements();
        IDeviceSchema deviceSchema = this.tableDeviceSchemaCache.getDeviceSchema(computation.getDevicePath().getNodes());
        if (!(deviceSchema instanceof TreeDeviceTemplateSchema)) {
            return IntStream.range(0, measurements.length).boxed().collect(Collectors.toList());
        }
        TreeDeviceTemplateSchema deviceTemplateSchema = (TreeDeviceTemplateSchema)deviceSchema;
        computation.computeDevice(this.templateManager.getTemplate(deviceTemplateSchema.getTemplateId()).isDirectAligned());
        Map<String, IMeasurementSchema> templateSchema = this.templateManager.getTemplate(deviceTemplateSchema.getTemplateId()).getSchemaMap();
        for (int i = 0; i < measurements.length; ++i) {
            if (!templateSchema.containsKey(measurements[i])) {
                indexOfMissingMeasurements.add(i);
                continue;
            }
            final IMeasurementSchema schema = templateSchema.get(measurements[i]);
            computation.computeMeasurement(i, new IMeasurementSchemaInfo(){

                @Override
                public String getName() {
                    return schema.getMeasurementName();
                }

                @Override
                public IMeasurementSchema getSchema() {
                    if (this.isLogicalView()) {
                        return new LogicalViewSchema(schema.getMeasurementName(), ((LogicalViewSchema)schema).getExpression());
                    }
                    return this.getSchemaAsMeasurementSchema();
                }

                @Override
                public MeasurementSchema getSchemaAsMeasurementSchema() {
                    return new MeasurementSchema(schema.getMeasurementName(), schema.getType(), schema.getEncodingType(), schema.getCompressor());
                }

                @Override
                public LogicalViewSchema getSchemaAsLogicalViewSchema() {
                    throw new RuntimeException(new UnsupportedOperationException("Function getSchemaAsLogicalViewSchema is not supported in DeviceUsingTemplateSchemaCache."));
                }

                @Override
                public Map<String, String> getTagMap() {
                    return null;
                }

                @Override
                public Map<String, String> getAttributeMap() {
                    return null;
                }

                @Override
                public String getAlias() {
                    return null;
                }

                @Override
                public boolean isLogicalView() {
                    return schema.isLogicalView();
                }
            });
        }
        return indexOfMissingMeasurements;
    }

    public void put(ClusterSchemaTree tree) {
        tree.getAllDevices().forEach(deviceSchemaInfo -> this.tableDeviceSchemaCache.putDeviceSchema(tree.getBelongedDatabase(deviceSchemaInfo.getDevicePath()), (DeviceSchemaInfo)deviceSchemaInfo));
    }

    public TimeValuePair getLastCache(MeasurementPath seriesPath) {
        return this.tableDeviceSchemaCache.getLastEntry(null, seriesPath.getIDeviceID(), seriesPath.getMeasurement());
    }

    public void invalidateLastCache(MeasurementPath path) {
        if (!CommonDescriptor.getInstance().getConfig().isLastCacheEnable()) {
            return;
        }
        this.tableDeviceSchemaCache.invalidateLastCache(path.getDevicePath(), path.getMeasurement());
    }

    public void invalidateDatabaseLastCache(String database) {
        if (!CommonDescriptor.getInstance().getConfig().isLastCacheEnable()) {
            return;
        }
        this.tableDeviceSchemaCache.invalidateLastCache(database);
    }

    public void updateLastCacheIfExists(String database, IDeviceID deviceID, String[] measurements, @Nonnull TimeValuePair[] timeValuePairs, boolean isAligned, IMeasurementSchema[] measurementSchemas) {
        this.tableDeviceSchemaCache.updateLastCache(database, deviceID, measurements, timeValuePairs, isAligned, measurementSchemas, false);
    }

    public void updateLastCache(String database, MeasurementPath measurementPath, boolean isInvalidate) {
        TimeValuePair[] timeValuePairArray;
        IDeviceID iDeviceID = measurementPath.getIDeviceID();
        String[] stringArray = new String[]{measurementPath.getMeasurement()};
        if (isInvalidate) {
            TimeValuePair[] timeValuePairArray2 = new TimeValuePair[1];
            timeValuePairArray = timeValuePairArray2;
            timeValuePairArray2[0] = null;
        } else {
            timeValuePairArray = null;
        }
        this.tableDeviceSchemaCache.updateLastCache(database, iDeviceID, stringArray, timeValuePairArray, measurementPath.isUnderAlignedEntity(), new IMeasurementSchema[]{measurementPath.getMeasurementSchema()}, true);
    }

    public void invalidate(List<MeasurementPath> partialPathList) {
        partialPathList.forEach(measurementPath -> {
            boolean isMultiLevelWildcardMeasurement = PathPatternUtil.isMultiLevelMatchWildcard((String)measurementPath.getMeasurement());
            this.tableDeviceSchemaCache.invalidateCache((PartialPath)(isMultiLevelWildcardMeasurement ? measurementPath : measurementPath.getDevicePath()), isMultiLevelWildcardMeasurement);
        });
    }

    public void cleanUp() {
        this.tableDeviceSchemaCache.invalidateAll();
    }

    private static class TreeDeviceSchemaCacheManagerHolder {
        private static final TreeDeviceSchemaCacheManager INSTANCE = new TreeDeviceSchemaCacheManager();

        private TreeDeviceSchemaCacheManagerHolder() {
        }
    }
}

